/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.ioc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.util.concurrent.RateLimiter;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import io.induct.domain.Entity;
import io.induct.yle.api.YleApi;
import io.induct.yle.api.YleId;
import io.induct.yle.api.common.Language;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;

public class YleApiModule
extends AbstractModule {
    private static Map<String, Language> byApiValue = YleApiModule.createMap();

    protected void configure() {
        this.bind(YleApi.class);
        SimpleModule yleApiCustomDeserializers = new SimpleModule("YleApiEntityDeserializers", new Version(1, 0, 0, null, "io.induct", "yleapi"));
        yleApiCustomDeserializers.addDeserializer(YleId.class, (JsonDeserializer)new JsonDeserializer<YleId>(){

            public YleId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return new YleId(jp.getText());
            }
        });
        yleApiCustomDeserializers.addSerializer(YleId.class, (JsonSerializer)new JsonSerializer<YleId>(){

            public void serialize(YleId value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                gen.writeString(value.identity());
            }
        });
        yleApiCustomDeserializers.addKeyDeserializer(Language.class, (KeyDeserializer)new LanguageKeyDeserializer());
        yleApiCustomDeserializers.addDeserializer(Language.class, (JsonDeserializer)new LanguageValueDeserializer());
        yleApiCustomDeserializers.setMixInAnnotation(Entity.class, EntityIgnores.class);
        Multibinder jacksonModules = Multibinder.newSetBinder((Binder)this.binder(), Module.class);
        jacksonModules.addBinding().toInstance((Object)yleApiCustomDeserializers);
    }

    @Provides
    @Singleton
    @Named(value="yle.api.rateLimit")
    RateLimiter rateLimiter(@Named(value="yle.api.rateLimit") String rateLimit) {
        return RateLimiter.create((double)Double.parseDouble(rateLimit));
    }

    private static Map<String, Language> createMap() {
        HashMap<String, Language> byApiValue = new HashMap<String, Language>(Language.values().length);
        for (Language lang : Language.values()) {
            byApiValue.put(lang.getLanguageCode(), lang);
        }
        return byApiValue;
    }

    private abstract class EntityIgnores {
        private EntityIgnores() {
        }

        @JsonIgnore
        public abstract boolean isIdentified();

        @JsonIgnore
        public abstract boolean isUnidentified();
    }

    private static class LanguageValueDeserializer
    extends JsonDeserializer<Language> {
        private LanguageValueDeserializer() {
        }

        public Language deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Language language = (Language)((Object)byApiValue.get(p.getText()));
            if (language == null) {
                throw new JsonMappingException("Unknown language '" + p.getText() + "'");
            }
            return language;
        }
    }

    private static class LanguageKeyDeserializer
    extends KeyDeserializer {
        private LanguageKeyDeserializer() {
        }

        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            if (byApiValue.containsKey(key)) {
                return byApiValue.get(key);
            }
            throw new JsonMappingException("Unknown language '" + key + "'");
        }
    }
}

