/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.cdn.images;

import com.cloudinary.Transformation;
import com.google.common.base.Optional;
import io.induct.yle.api.YleId;
import io.induct.yle.cdn.images.domain.Format;
import javax.inject.Inject;
import javax.inject.Named;

public class YleImagesCdn {
    private final String imageCdnBaseUrl;

    @Inject
    public YleImagesCdn(@Named(value="yle.images.baseUrl") String imageCdnBaseUrl) {
        this.imageCdnBaseUrl = imageCdnBaseUrl;
    }

    public String urlFor(YleId imageId, Format format) {
        return this.urlFor(imageId, format, (Optional<Transformation>)Optional.absent());
    }

    public String urlFor(YleId imageId, Format format, Optional<Transformation> transformation) {
        StringBuilder url = new StringBuilder();
        url.append(this.imageCdnBaseUrl).append("/image/upload");
        if (transformation.isPresent()) {
            url.append("/").append(((Transformation)transformation.get()).generate());
        }
        url.append("/").append(imageId.identity()).append(".").append(format.getApiValue());
        return url.toString();
    }
}

