/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.api.programs.domain.search;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.induct.domain.Identifiable;
import io.induct.yle.api.YleId;
import io.induct.yle.api.common.Language;
import io.induct.yle.api.common.MediaObject;
import java.util.HashSet;
import java.util.Set;

public class ItemSearch {
    private static final Joiner csv = Joiner.on((char)',').skipNulls();
    private final Set<YleId> ids;
    private final Type type;
    private final String keyword;
    private final MediaObject mediaObject;
    private final Set<YleId> seriesIds;
    private final Availability availability;
    private final boolean downloadable;
    private final Language language;

    private ItemSearch(Set<YleId> ids, Type type, String keyword, MediaObject mediaObject, Set<YleId> seriesIds, Availability availability, boolean downloadable, Language language) {
        this.ids = ids;
        this.type = type;
        this.keyword = keyword;
        this.mediaObject = mediaObject;
        this.seriesIds = seriesIds;
        this.availability = availability;
        this.downloadable = downloadable;
        this.language = language;
    }

    public Multimap<String, String> getParams() {
        HashMultimap params = HashMultimap.create();
        if (!this.ids.isEmpty()) {
            params.put((Object)"id", (Object)csv.join(Iterables.transform(this.ids, Identifiable::identity)));
        }
        if (this.type != null) {
            params.put((Object)"type", (Object)this.type.getApiParamName());
        }
        if (!Strings.isNullOrEmpty((String)this.keyword)) {
            params.put((Object)"q", (Object)this.keyword);
        }
        if (this.mediaObject != null) {
            params.put((Object)"mediaobject", (Object)this.mediaObject.getApiParamName());
        }
        if (!this.seriesIds.isEmpty()) {
            params.put((Object)"series", (Object)csv.join(Iterables.transform(this.seriesIds, Identifiable::identity)));
        }
        if (this.availability != null) {
            params.put((Object)"availability", (Object)this.availability.getApiParamName());
        }
        if (this.downloadable) {
            params.put((Object)"downloadable", (Object)"true");
        }
        if (this.language != null) {
            params.put((Object)"language", (Object)this.language.getLanguageCode());
        }
        return params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<YleId> ids = new HashSet<YleId>();
        private Set<YleId> seriesIds = new HashSet<YleId>();
        private Type type = null;
        private String keyword = null;
        private MediaObject mediaObject;
        private Availability availability;
        private boolean downloadable;
        private Language language;

        private Builder() {
        }

        public Builder byIds(YleId first, YleId ... more) {
            this.ids.add(first);
            for (YleId yleId : more) {
                this.ids.add(yleId);
            }
            return this;
        }

        public Builder byIds(String first, String ... more) {
            this.ids.add(new YleId(first));
            for (String id : more) {
                this.ids.add(new YleId(id));
            }
            return this;
        }

        public Builder ofType(Type type) {
            this.type = type;
            return this;
        }

        public ItemSearch build() {
            return new ItemSearch(this.ids, this.type, this.keyword, this.mediaObject, this.seriesIds, this.availability, this.downloadable, this.language);
        }

        public Builder withKeyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public Builder returnOnly(MediaObject mediaObject) {
            this.mediaObject = mediaObject;
            return this;
        }

        public Builder partOfSeries(YleId first, YleId ... more) {
            this.seriesIds.add(first);
            for (YleId yleId : more) {
                this.seriesIds.add(yleId);
            }
            return this;
        }

        public Builder partOfSeries(String first, String ... more) {
            this.seriesIds.add(new YleId(first));
            for (String id : more) {
                this.seriesIds.add(new YleId(id));
            }
            return this;
        }

        public Builder withAvailability(Availability availability) {
            this.availability = availability;
            return this;
        }

        public Builder isDownloadable(boolean downloadable) {
            this.downloadable = downloadable;
            return this;
        }

        public Builder inLanguage(Language language) {
            if (language != Language.FINNISH && language != Language.SWEDISH) {
                throw new IllegalArgumentException("Only Finnish and Swedish are supported as item search by language parameter. Was given " + (Object)((Object)language) + " instead");
            }
            this.language = language;
            return this;
        }
    }

    public static enum Availability {
        ON_DEMAND("ondemand"),
        FUTURE_ON_DEMAND("future-ondemand"),
        FUTURE_SCHEDULED("future-scheduled"),
        IN_FUTURE("in-future");

        private final String apiParamName;

        private Availability(String apiParamName) {
            this.apiParamName = apiParamName;
        }

        public String getApiParamName() {
            return this.apiParamName;
        }
    }

    public static enum Type {
        PROGRAM("program"),
        CLIP("clip"),
        TV_CONTENT("tvcontent"),
        TV_PROGRAM("tvprogram"),
        TV_CLIP("tvclip"),
        RADIO_CONTENT("radiocontent"),
        RADIO_PROGRAM("radioprogram"),
        RADIO_CLIP("radioclip");

        private final String apiParamName;

        private Type(String apiParamName) {
            this.apiParamName = apiParamName;
        }

        public String getApiParamName() {
            return this.apiParamName;
        }
    }
}

