/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.api.programs.domain.items;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import io.induct.domain.Entity;
import io.induct.yle.api.YleId;
import io.induct.yle.api.common.Language;
import io.induct.yle.api.programs.domain.Item;
import io.induct.yle.api.programs.domain.items.Audio;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

public class TvProgram
extends Item {
    private final Map<Language, String> descriptions;
    private final Video video;
    private final String typeMedia;
    private final List<Creator> creators;
    private final int episodeNumber;
    private final Map<Language, String> promotionTitles;
    private final DateTime indexDataModified;
    private final Season season;
    private final Series series;
    private final List<YleId> alternativeIds;
    private final String duration;
    private final String productionId;
    private final ContentRating contentRating;
    private final Map<Language, String> titles;
    private final List<String> countryOfOrigin;
    private final String typeCreative;
    private final Image image;
    private final List<Audio> audio;
    private final Map<Language, String> originalTitles;
    private final List<PublicationEvent> publicationEvents;
    private final String collection;
    private final List<Subject> subject;
    private final List<Subtitling> subtitling;

    @JsonCreator
    public TvProgram(@JsonProperty(value="id") YleId identity, @JsonProperty(value="description") Map<Language, String> descriptions, @JsonProperty(value="creator") List<Creator> creators, @JsonProperty(value="partOfSeason") Season season, @JsonProperty(value="partOfSeries") Series series, @JsonProperty(value="video") Video video, @JsonProperty(value="typeMedia") String typeMedia, @JsonProperty(value="episodeNumber") int episodeNumber, @JsonProperty(value="promotionTitle") Map<Language, String> promotionTitles, @JsonProperty(value="indexDataModified") DateTime indexDataModified, @JsonProperty(value="alternativeId") List<YleId> alternativeIds, @JsonProperty(value="duration") String duration, @JsonProperty(value="productionId") String productionId, @JsonProperty(value="contentRating") ContentRating contentRating, @JsonProperty(value="title") Map<Language, String> title, @JsonProperty(value="countryOfOrigin") List<String> countryOfOrigin, @JsonProperty(value="typeCreative") String typeCreative, @JsonProperty(value="image") Image image, @JsonProperty(value="audio") List<Audio> audio, @JsonProperty(value="originalTitle") Map<Language, String> originalTitles, @JsonProperty(value="publicationEvent") List<PublicationEvent> publicationEvents, @JsonProperty(value="collection") String collection, @JsonProperty(value="subject") List<Subject> subject, @JsonProperty(value="subtitling") List<Subtitling> subtitling) {
        super(identity);
        this.season = season;
        this.series = series;
        this.alternativeIds = alternativeIds;
        this.descriptions = descriptions;
        this.creators = creators;
        this.video = video;
        this.typeMedia = typeMedia;
        this.episodeNumber = episodeNumber;
        this.promotionTitles = promotionTitles;
        this.indexDataModified = indexDataModified;
        this.duration = duration;
        this.productionId = productionId;
        this.contentRating = contentRating;
        this.titles = title;
        this.countryOfOrigin = countryOfOrigin;
        this.typeCreative = typeCreative;
        this.image = image;
        this.audio = audio;
        this.originalTitles = originalTitles;
        this.publicationEvents = publicationEvents;
        this.collection = collection;
        this.subject = subject;
        this.subtitling = subtitling;
    }

    public String getTitle(Language language) {
        return this.titles.get((Object)language);
    }

    public String getDescription(Language language) {
        return this.descriptions.get((Object)language);
    }

    public Map<Language, String> getDescriptions() {
        return this.descriptions;
    }

    public Video getVideo() {
        return this.video;
    }

    public String getTypeMedia() {
        return this.typeMedia;
    }

    public List<Creator> getCreators() {
        return this.creators;
    }

    public int getEpisodeNumber() {
        return this.episodeNumber;
    }

    public Map<Language, String> getPromotionTitles() {
        return this.promotionTitles;
    }

    public DateTime getIndexDataModified() {
        return this.indexDataModified;
    }

    public Season getSeason() {
        return this.season;
    }

    public Series getSeries() {
        return this.series;
    }

    public List<YleId> getAlternativeIds() {
        return this.alternativeIds;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getProductionId() {
        return this.productionId;
    }

    public ContentRating getContentRating() {
        return this.contentRating;
    }

    public Map<Language, String> getTitles() {
        return this.titles;
    }

    public List<String> getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public String getTypeCreative() {
        return this.typeCreative;
    }

    public Image getImage() {
        return this.image;
    }

    public List<Audio> getAudio() {
        return this.audio;
    }

    public Map<Language, String> getOriginalTitles() {
        return this.originalTitles;
    }

    public List<PublicationEvent> getPublicationEvents() {
        return this.publicationEvents;
    }

    public String getCollection() {
        return this.collection;
    }

    public List<Subject> getSubject() {
        return this.subject;
    }

    public List<Subtitling> getSubtitling() {
        return this.subtitling;
    }

    public String toString() {
        return "TvProgram(descriptions=" + this.getDescriptions() + ", video=" + this.getVideo() + ", typeMedia=" + this.getTypeMedia() + ", creators=" + this.getCreators() + ", episodeNumber=" + this.getEpisodeNumber() + ", promotionTitles=" + this.getPromotionTitles() + ", indexDataModified=" + this.getIndexDataModified() + ", season=" + (Object)((Object)this.getSeason()) + ", series=" + (Object)((Object)this.getSeries()) + ", alternativeIds=" + this.getAlternativeIds() + ", duration=" + this.getDuration() + ", productionId=" + this.getProductionId() + ", contentRating=" + this.getContentRating() + ", titles=" + this.getTitles() + ", countryOfOrigin=" + this.getCountryOfOrigin() + ", typeCreative=" + this.getTypeCreative() + ", image=" + (Object)((Object)this.getImage()) + ", audio=" + this.getAudio() + ", originalTitles=" + this.getOriginalTitles() + ", publicationEvents=" + this.getPublicationEvents() + ", collection=" + this.getCollection() + ", subject=" + this.getSubject() + ", subtitling=" + this.getSubtitling() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TvProgram)) {
            return false;
        }
        TvProgram other = (TvProgram)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<Language, String> this$descriptions = this.getDescriptions();
        Map<Language, String> other$descriptions = other.getDescriptions();
        if (this$descriptions == null ? other$descriptions != null : !((Object)this$descriptions).equals(other$descriptions)) {
            return false;
        }
        Video this$video = this.getVideo();
        Video other$video = other.getVideo();
        if (this$video == null ? other$video != null : !((Object)this$video).equals(other$video)) {
            return false;
        }
        String this$typeMedia = this.getTypeMedia();
        String other$typeMedia = other.getTypeMedia();
        if (this$typeMedia == null ? other$typeMedia != null : !this$typeMedia.equals(other$typeMedia)) {
            return false;
        }
        List<Creator> this$creators = this.getCreators();
        List<Creator> other$creators = other.getCreators();
        if (this$creators == null ? other$creators != null : !((Object)this$creators).equals(other$creators)) {
            return false;
        }
        if (this.getEpisodeNumber() != other.getEpisodeNumber()) {
            return false;
        }
        Map<Language, String> this$promotionTitles = this.getPromotionTitles();
        Map<Language, String> other$promotionTitles = other.getPromotionTitles();
        if (this$promotionTitles == null ? other$promotionTitles != null : !((Object)this$promotionTitles).equals(other$promotionTitles)) {
            return false;
        }
        DateTime this$indexDataModified = this.getIndexDataModified();
        DateTime other$indexDataModified = other.getIndexDataModified();
        if (this$indexDataModified == null ? other$indexDataModified != null : !this$indexDataModified.equals(other$indexDataModified)) {
            return false;
        }
        Season this$season = this.getSeason();
        Season other$season = other.getSeason();
        if (this$season == null ? other$season != null : !((Object)((Object)this$season)).equals((Object)other$season)) {
            return false;
        }
        Series this$series = this.getSeries();
        Series other$series = other.getSeries();
        if (this$series == null ? other$series != null : !((Object)((Object)this$series)).equals((Object)other$series)) {
            return false;
        }
        List<YleId> this$alternativeIds = this.getAlternativeIds();
        List<YleId> other$alternativeIds = other.getAlternativeIds();
        if (this$alternativeIds == null ? other$alternativeIds != null : !((Object)this$alternativeIds).equals(other$alternativeIds)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        String this$productionId = this.getProductionId();
        String other$productionId = other.getProductionId();
        if (this$productionId == null ? other$productionId != null : !this$productionId.equals(other$productionId)) {
            return false;
        }
        ContentRating this$contentRating = this.getContentRating();
        ContentRating other$contentRating = other.getContentRating();
        if (this$contentRating == null ? other$contentRating != null : !((Object)this$contentRating).equals(other$contentRating)) {
            return false;
        }
        Map<Language, String> this$titles = this.getTitles();
        Map<Language, String> other$titles = other.getTitles();
        if (this$titles == null ? other$titles != null : !((Object)this$titles).equals(other$titles)) {
            return false;
        }
        List<String> this$countryOfOrigin = this.getCountryOfOrigin();
        List<String> other$countryOfOrigin = other.getCountryOfOrigin();
        if (this$countryOfOrigin == null ? other$countryOfOrigin != null : !((Object)this$countryOfOrigin).equals(other$countryOfOrigin)) {
            return false;
        }
        String this$typeCreative = this.getTypeCreative();
        String other$typeCreative = other.getTypeCreative();
        if (this$typeCreative == null ? other$typeCreative != null : !this$typeCreative.equals(other$typeCreative)) {
            return false;
        }
        Image this$image = this.getImage();
        Image other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)((Object)this$image)).equals((Object)other$image)) {
            return false;
        }
        List<Audio> this$audio = this.getAudio();
        List<Audio> other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        Map<Language, String> this$originalTitles = this.getOriginalTitles();
        Map<Language, String> other$originalTitles = other.getOriginalTitles();
        if (this$originalTitles == null ? other$originalTitles != null : !((Object)this$originalTitles).equals(other$originalTitles)) {
            return false;
        }
        List<PublicationEvent> this$publicationEvents = this.getPublicationEvents();
        List<PublicationEvent> other$publicationEvents = other.getPublicationEvents();
        if (this$publicationEvents == null ? other$publicationEvents != null : !((Object)this$publicationEvents).equals(other$publicationEvents)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        List<Subject> this$subject = this.getSubject();
        List<Subject> other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !((Object)this$subject).equals(other$subject)) {
            return false;
        }
        List<Subtitling> this$subtitling = this.getSubtitling();
        List<Subtitling> other$subtitling = other.getSubtitling();
        return !(this$subtitling == null ? other$subtitling != null : !((Object)this$subtitling).equals(other$subtitling));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TvProgram;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Map<Language, String> $descriptions = this.getDescriptions();
        result = result * 59 + ($descriptions == null ? 0 : ((Object)$descriptions).hashCode());
        Video $video = this.getVideo();
        result = result * 59 + ($video == null ? 0 : ((Object)$video).hashCode());
        String $typeMedia = this.getTypeMedia();
        result = result * 59 + ($typeMedia == null ? 0 : $typeMedia.hashCode());
        List<Creator> $creators = this.getCreators();
        result = result * 59 + ($creators == null ? 0 : ((Object)$creators).hashCode());
        result = result * 59 + this.getEpisodeNumber();
        Map<Language, String> $promotionTitles = this.getPromotionTitles();
        result = result * 59 + ($promotionTitles == null ? 0 : ((Object)$promotionTitles).hashCode());
        DateTime $indexDataModified = this.getIndexDataModified();
        result = result * 59 + ($indexDataModified == null ? 0 : $indexDataModified.hashCode());
        Season $season = this.getSeason();
        result = result * 59 + ($season == null ? 0 : ((Object)((Object)$season)).hashCode());
        Series $series = this.getSeries();
        result = result * 59 + ($series == null ? 0 : ((Object)((Object)$series)).hashCode());
        List<YleId> $alternativeIds = this.getAlternativeIds();
        result = result * 59 + ($alternativeIds == null ? 0 : ((Object)$alternativeIds).hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 0 : $duration.hashCode());
        String $productionId = this.getProductionId();
        result = result * 59 + ($productionId == null ? 0 : $productionId.hashCode());
        ContentRating $contentRating = this.getContentRating();
        result = result * 59 + ($contentRating == null ? 0 : ((Object)$contentRating).hashCode());
        Map<Language, String> $titles = this.getTitles();
        result = result * 59 + ($titles == null ? 0 : ((Object)$titles).hashCode());
        List<String> $countryOfOrigin = this.getCountryOfOrigin();
        result = result * 59 + ($countryOfOrigin == null ? 0 : ((Object)$countryOfOrigin).hashCode());
        String $typeCreative = this.getTypeCreative();
        result = result * 59 + ($typeCreative == null ? 0 : $typeCreative.hashCode());
        Image $image = this.getImage();
        result = result * 59 + ($image == null ? 0 : ((Object)((Object)$image)).hashCode());
        List<Audio> $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 0 : ((Object)$audio).hashCode());
        Map<Language, String> $originalTitles = this.getOriginalTitles();
        result = result * 59 + ($originalTitles == null ? 0 : ((Object)$originalTitles).hashCode());
        List<PublicationEvent> $publicationEvents = this.getPublicationEvents();
        result = result * 59 + ($publicationEvents == null ? 0 : ((Object)$publicationEvents).hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 0 : $collection.hashCode());
        List<Subject> $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 0 : ((Object)$subject).hashCode());
        List<Subtitling> $subtitling = this.getSubtitling();
        result = result * 59 + ($subtitling == null ? 0 : ((Object)$subtitling).hashCode());
        return result;
    }

    public static class Image
    extends Entity<YleId> {
        private final boolean available;
        private final String type;

        @JsonCreator
        public Image(@JsonProperty(value="id") YleId id, @JsonProperty(value="available") boolean available, @JsonProperty(value="type") String type) {
            super((Serializable)id, (Serializable)YleId.UNIDENTIFIED);
            this.available = available;
            this.type = type;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "TvProgram.Image(available=" + this.isAvailable() + ", type=" + this.getType() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Image)) {
                return false;
            }
            Image other = (Image)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isAvailable() != other.isAvailable()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Image;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            result = result * 59 + (this.isAvailable() ? 79 : 97);
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            return result;
        }
    }

    public static class Video {
        private final List<Format> formats;
        private final String type;

        @JsonCreator
        public Video(@JsonProperty(value="format") List<Format> formats, @JsonProperty(value="type") String type) {
            this.formats = formats;
            this.type = type;
        }

        public List<Format> getFormats() {
            return this.formats;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Video)) {
                return false;
            }
            Video other = (Video)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Format> this$formats = this.getFormats();
            List<Format> other$formats = other.getFormats();
            if (this$formats == null ? other$formats != null : !((Object)this$formats).equals(other$formats)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Video;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Format> $formats = this.getFormats();
            result = result * 59 + ($formats == null ? 0 : ((Object)$formats).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "TvProgram.Video(formats=" + this.getFormats() + ", type=" + this.getType() + ")";
        }

        public static class Format {
            private final String inScheme;
            private final String type;
            private final String key;

            @JsonCreator
            public Format(@JsonProperty(value="inScheme") String inScheme, @JsonProperty(value="type") String type, @JsonProperty(value="key") String key) {
                this.inScheme = inScheme;
                this.type = type;
                this.key = key;
            }

            public String getInScheme() {
                return this.inScheme;
            }

            public String getType() {
                return this.type;
            }

            public String getKey() {
                return this.key;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Format)) {
                    return false;
                }
                Format other = (Format)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$inScheme = this.getInScheme();
                String other$inScheme = other.getInScheme();
                if (this$inScheme == null ? other$inScheme != null : !this$inScheme.equals(other$inScheme)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$key = this.getKey();
                String other$key = other.getKey();
                return !(this$key == null ? other$key != null : !this$key.equals(other$key));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Format;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $inScheme = this.getInScheme();
                result = result * 59 + ($inScheme == null ? 0 : $inScheme.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 0 : $type.hashCode());
                String $key = this.getKey();
                result = result * 59 + ($key == null ? 0 : $key.hashCode());
                return result;
            }

            public String toString() {
                return "TvProgram.Video.Format(inScheme=" + this.getInScheme() + ", type=" + this.getType() + ", key=" + this.getKey() + ")";
            }
        }
    }

    public static class ContentRating {
        private final Map<Language, String> titles;
        private final int ageRestriction;
        private final List<Reason> reasons;

        @JsonCreator
        public ContentRating(@JsonProperty(value="title") Map<Language, String> titles, @JsonProperty(value="ageRestriction") int ageRestriction, @JsonProperty(value="reason") List<Reason> reasons) {
            this.titles = titles;
            this.ageRestriction = ageRestriction;
            this.reasons = reasons;
        }

        public Map<Language, String> getTitles() {
            return this.titles;
        }

        public int getAgeRestriction() {
            return this.ageRestriction;
        }

        public List<Reason> getReasons() {
            return this.reasons;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentRating)) {
                return false;
            }
            ContentRating other = (ContentRating)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Language, String> this$titles = this.getTitles();
            Map<Language, String> other$titles = other.getTitles();
            if (this$titles == null ? other$titles != null : !((Object)this$titles).equals(other$titles)) {
                return false;
            }
            if (this.getAgeRestriction() != other.getAgeRestriction()) {
                return false;
            }
            List<Reason> this$reasons = this.getReasons();
            List<Reason> other$reasons = other.getReasons();
            return !(this$reasons == null ? other$reasons != null : !((Object)this$reasons).equals(other$reasons));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentRating;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Language, String> $titles = this.getTitles();
            result = result * 59 + ($titles == null ? 0 : ((Object)$titles).hashCode());
            result = result * 59 + this.getAgeRestriction();
            List<Reason> $reasons = this.getReasons();
            result = result * 59 + ($reasons == null ? 0 : ((Object)$reasons).hashCode());
            return result;
        }

        public String toString() {
            return "TvProgram.ContentRating(titles=" + this.getTitles() + ", ageRestriction=" + this.getAgeRestriction() + ", reasons=" + this.getReasons() + ")";
        }

        public static class Reason {
            private final Map<Language, String> titles;
            private final String type;
            private final String key;

            @JsonCreator
            public Reason(@JsonProperty(value="title") Map<Language, String> titles, @JsonProperty(value="type") String type, @JsonProperty(value="key") String key) {
                this.titles = titles;
                this.type = type;
                this.key = key;
            }

            public Map<Language, String> getTitles() {
                return this.titles;
            }

            public String getType() {
                return this.type;
            }

            public String getKey() {
                return this.key;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Reason)) {
                    return false;
                }
                Reason other = (Reason)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<Language, String> this$titles = this.getTitles();
                Map<Language, String> other$titles = other.getTitles();
                if (this$titles == null ? other$titles != null : !((Object)this$titles).equals(other$titles)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$key = this.getKey();
                String other$key = other.getKey();
                return !(this$key == null ? other$key != null : !this$key.equals(other$key));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Reason;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<Language, String> $titles = this.getTitles();
                result = result * 59 + ($titles == null ? 0 : ((Object)$titles).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 0 : $type.hashCode());
                String $key = this.getKey();
                result = result * 59 + ($key == null ? 0 : $key.hashCode());
                return result;
            }

            public String toString() {
                return "TvProgram.ContentRating.Reason(titles=" + this.getTitles() + ", type=" + this.getType() + ", key=" + this.getKey() + ")";
            }
        }
    }

    public static class Subtitling {
        private final List<Language> languages;
        private final String type;

        @JsonCreator
        public Subtitling(@JsonProperty(value="language") List<Language> languages, @JsonProperty(value="type") String type) {
            this.languages = languages;
            this.type = type;
        }

        public List<Language> getLanguages() {
            return this.languages;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subtitling)) {
                return false;
            }
            Subtitling other = (Subtitling)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Language> this$languages = this.getLanguages();
            List<Language> other$languages = other.getLanguages();
            if (this$languages == null ? other$languages != null : !((Object)this$languages).equals(other$languages)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Subtitling;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Language> $languages = this.getLanguages();
            result = result * 59 + ($languages == null ? 0 : ((Object)$languages).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "TvProgram.Subtitling(languages=" + this.getLanguages() + ", type=" + this.getType() + ")";
        }
    }

    public static class PublicationEvent
    extends Entity<YleId> {
        private final Service service;
        private final Optional<List<Publisher>> publishers;
        private final DateTime startTime;
        private final String temporalStatus;
        private final DateTime endTime;
        private final String type;
        private final String duration;
        private final String region;
        private final YleId id;
        private final Optional<Media> media;

        @JsonCreator
        public PublicationEvent(@JsonProperty(value="service") Service service, @JsonProperty(value="publisher") Optional<List<Publisher>> publishers, @JsonProperty(value="startTime") DateTime startTime, @JsonProperty(value="temporalStatus") String temporalStatus, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="type") String type, @JsonProperty(value="duration") String duration, @JsonProperty(value="region") String region, @JsonProperty(value="id") YleId id, @JsonProperty(value="media") Optional<Media> media) {
            super((Serializable)id, (Serializable)YleId.UNIDENTIFIED);
            this.service = service;
            this.publishers = publishers;
            this.startTime = startTime;
            this.temporalStatus = temporalStatus;
            this.endTime = endTime;
            this.type = type;
            this.duration = duration;
            this.region = region;
            this.id = id;
            this.media = media;
        }

        public Service getService() {
            return this.service;
        }

        public Optional<List<Publisher>> getPublishers() {
            return this.publishers;
        }

        public DateTime getStartTime() {
            return this.startTime;
        }

        public String getTemporalStatus() {
            return this.temporalStatus;
        }

        public DateTime getEndTime() {
            return this.endTime;
        }

        public String getType() {
            return this.type;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getRegion() {
            return this.region;
        }

        public YleId getId() {
            return this.id;
        }

        public Optional<Media> getMedia() {
            return this.media;
        }

        public String toString() {
            return "TvProgram.PublicationEvent(service=" + this.getService() + ", publishers=" + this.getPublishers() + ", startTime=" + this.getStartTime() + ", temporalStatus=" + this.getTemporalStatus() + ", endTime=" + this.getEndTime() + ", type=" + this.getType() + ", duration=" + this.getDuration() + ", region=" + this.getRegion() + ", id=" + this.getId() + ", media=" + this.getMedia() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PublicationEvent)) {
                return false;
            }
            PublicationEvent other = (PublicationEvent)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Service this$service = this.getService();
            Service other$service = other.getService();
            if (this$service == null ? other$service != null : !((Object)this$service).equals(other$service)) {
                return false;
            }
            Optional<List<Publisher>> this$publishers = this.getPublishers();
            Optional<List<Publisher>> other$publishers = other.getPublishers();
            if (this$publishers == null ? other$publishers != null : !this$publishers.equals(other$publishers)) {
                return false;
            }
            DateTime this$startTime = this.getStartTime();
            DateTime other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
                return false;
            }
            String this$temporalStatus = this.getTemporalStatus();
            String other$temporalStatus = other.getTemporalStatus();
            if (this$temporalStatus == null ? other$temporalStatus != null : !this$temporalStatus.equals(other$temporalStatus)) {
                return false;
            }
            DateTime this$endTime = this.getEndTime();
            DateTime other$endTime = other.getEndTime();
            if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            YleId this$id = this.getId();
            YleId other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Optional<Media> this$media = this.getMedia();
            Optional<Media> other$media = other.getMedia();
            return !(this$media == null ? other$media != null : !this$media.equals(other$media));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PublicationEvent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            Service $service = this.getService();
            result = result * 59 + ($service == null ? 0 : ((Object)$service).hashCode());
            Optional<List<Publisher>> $publishers = this.getPublishers();
            result = result * 59 + ($publishers == null ? 0 : $publishers.hashCode());
            DateTime $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 0 : $startTime.hashCode());
            String $temporalStatus = this.getTemporalStatus();
            result = result * 59 + ($temporalStatus == null ? 0 : $temporalStatus.hashCode());
            DateTime $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 0 : $endTime.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 0 : $duration.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 0 : $region.hashCode());
            YleId $id = this.getId();
            result = result * 59 + ($id == null ? 0 : ((Object)$id).hashCode());
            Optional<Media> $media = this.getMedia();
            result = result * 59 + ($media == null ? 0 : $media.hashCode());
            return result;
        }

        public static class Media
        extends Entity<YleId> {
            private final String duration;
            private final List<ContentProtection> contentProtection;

            @JsonCreator
            public Media(@JsonProperty(value="id") YleId id, @JsonProperty(value="duration") String duration, @JsonProperty(value="contentProtection") List<ContentProtection> contentProtection) {
                super((Serializable)id, (Serializable)YleId.UNIDENTIFIED);
                this.duration = duration;
                this.contentProtection = contentProtection;
            }

            public String getDuration() {
                return this.duration;
            }

            public List<ContentProtection> getContentProtection() {
                return this.contentProtection;
            }

            public String toString() {
                return "TvProgram.PublicationEvent.Media(duration=" + this.getDuration() + ", contentProtection=" + this.getContentProtection() + ")";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Media)) {
                    return false;
                }
                Media other = (Media)((Object)o);
                if (!other.canEqual((Object)this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$duration = this.getDuration();
                String other$duration = other.getDuration();
                if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
                    return false;
                }
                List<ContentProtection> this$contentProtection = this.getContentProtection();
                List<ContentProtection> other$contentProtection = other.getContentProtection();
                return !(this$contentProtection == null ? other$contentProtection != null : !((Object)this$contentProtection).equals(other$contentProtection));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Media;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + super.hashCode();
                String $duration = this.getDuration();
                result = result * 59 + ($duration == null ? 0 : $duration.hashCode());
                List<ContentProtection> $contentProtection = this.getContentProtection();
                result = result * 59 + ($contentProtection == null ? 0 : ((Object)$contentProtection).hashCode());
                return result;
            }

            public static class ContentProtection
            extends Entity<YleId> {
                private final String type;

                @JsonCreator
                public ContentProtection(@JsonProperty(value="id") YleId id, @JsonProperty(value="type") String type) {
                    super((Serializable)id, (Serializable)YleId.UNIDENTIFIED);
                    this.type = type;
                }

                public String getType() {
                    return this.type;
                }

                public String toString() {
                    return "TvProgram.PublicationEvent.Media.ContentProtection(type=" + this.getType() + ")";
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ContentProtection)) {
                        return false;
                    }
                    ContentProtection other = (ContentProtection)((Object)o);
                    if (!other.canEqual((Object)this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ContentProtection;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + super.hashCode();
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 0 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class Publisher {
            private final String id;

            @JsonCreator
            public Publisher(@JsonProperty(value="id") String id) {
                this.id = id;
            }

            public String getId() {
                return this.id;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Publisher)) {
                    return false;
                }
                Publisher other = (Publisher)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                return !(this$id == null ? other$id != null : !this$id.equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Publisher;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 0 : $id.hashCode());
                return result;
            }

            public String toString() {
                return "TvProgram.PublicationEvent.Publisher(id=" + this.getId() + ")";
            }
        }

        public static class Service {
            private final String id;

            @JsonCreator
            public Service(@JsonProperty(value="id") String id) {
                this.id = id;
            }

            public String getId() {
                return this.id;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Service)) {
                    return false;
                }
                Service other = (Service)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                return !(this$id == null ? other$id != null : !this$id.equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Service;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 0 : $id.hashCode());
                return result;
            }

            public String toString() {
                return "TvProgram.PublicationEvent.Service(id=" + this.getId() + ")";
            }
        }
    }

    public static class Subject
    extends Entity<YleId> {
        private final Map<Language, String> titles;
        private final Optional<Set<YleId>> broader;
        private final String inScheme;
        private final String type;
        private final Optional<String> key;
        private final Optional<List<Notation>> notations;

        @JsonCreator
        public Subject(@JsonProperty(value="id") YleId id, @JsonProperty(value="title") Map<Language, String> titles, @JsonProperty(value="broader") Optional<Map<String, YleId>> broader, @JsonProperty(value="inScheme") String inScheme, @JsonProperty(value="type") String type, @JsonProperty(value="key") Optional<String> key, @JsonProperty(value="notation") Optional<List<Notation>> notations) {
            super((Serializable)id, (Serializable)YleId.UNIDENTIFIED);
            this.titles = titles;
            this.broader = broader.isPresent() ? Optional.of((Object)Sets.newHashSet(((Map)broader.get()).values())) : Optional.absent();
            this.inScheme = inScheme;
            this.type = type;
            this.key = key;
            this.notations = notations;
        }

        public Map<Language, String> getTitles() {
            return this.titles;
        }

        public Optional<Set<YleId>> getBroader() {
            return this.broader;
        }

        public String getInScheme() {
            return this.inScheme;
        }

        public String getType() {
            return this.type;
        }

        public Optional<String> getKey() {
            return this.key;
        }

        public Optional<List<Notation>> getNotations() {
            return this.notations;
        }

        public String toString() {
            return "TvProgram.Subject(titles=" + this.getTitles() + ", broader=" + this.getBroader() + ", inScheme=" + this.getInScheme() + ", type=" + this.getType() + ", key=" + this.getKey() + ", notations=" + this.getNotations() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subject)) {
                return false;
            }
            Subject other = (Subject)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<Language, String> this$titles = this.getTitles();
            Map<Language, String> other$titles = other.getTitles();
            if (this$titles == null ? other$titles != null : !((Object)this$titles).equals(other$titles)) {
                return false;
            }
            Optional<Set<YleId>> this$broader = this.getBroader();
            Optional<Set<YleId>> other$broader = other.getBroader();
            if (this$broader == null ? other$broader != null : !this$broader.equals(other$broader)) {
                return false;
            }
            String this$inScheme = this.getInScheme();
            String other$inScheme = other.getInScheme();
            if (this$inScheme == null ? other$inScheme != null : !this$inScheme.equals(other$inScheme)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Optional<String> this$key = this.getKey();
            Optional<String> other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Optional<List<Notation>> this$notations = this.getNotations();
            Optional<List<Notation>> other$notations = other.getNotations();
            return !(this$notations == null ? other$notations != null : !this$notations.equals(other$notations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Subject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            Map<Language, String> $titles = this.getTitles();
            result = result * 59 + ($titles == null ? 0 : ((Object)$titles).hashCode());
            Optional<Set<YleId>> $broader = this.getBroader();
            result = result * 59 + ($broader == null ? 0 : $broader.hashCode());
            String $inScheme = this.getInScheme();
            result = result * 59 + ($inScheme == null ? 0 : $inScheme.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            Optional<String> $key = this.getKey();
            result = result * 59 + ($key == null ? 0 : $key.hashCode());
            Optional<List<Notation>> $notations = this.getNotations();
            result = result * 59 + ($notations == null ? 0 : $notations.hashCode());
            return result;
        }

        public static class Notation {
            private final String value;
            private final String valueType;

            @JsonCreator
            public Notation(@JsonProperty(value="value") String value, @JsonProperty(value="valueType") String valueType) {
                this.value = value;
                this.valueType = valueType;
            }

            public String getValue() {
                return this.value;
            }

            public String getValueType() {
                return this.valueType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Notation)) {
                    return false;
                }
                Notation other = (Notation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                    return false;
                }
                String this$valueType = this.getValueType();
                String other$valueType = other.getValueType();
                return !(this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Notation;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 0 : $value.hashCode());
                String $valueType = this.getValueType();
                result = result * 59 + ($valueType == null ? 0 : $valueType.hashCode());
                return result;
            }

            public String toString() {
                return "TvProgram.Subject.Notation(value=" + this.getValue() + ", valueType=" + this.getValueType() + ")";
            }
        }
    }

    public static class Creator {
        private final String name;
        private final String type;

        @JsonCreator
        public Creator(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Creator)) {
                return false;
            }
            Creator other = (Creator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Creator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 0 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "TvProgram.Creator(name=" + this.getName() + ", type=" + this.getType() + ")";
        }
    }

    public static class Series
    extends Entity<YleId> {
        private final Map<Language, String> descriptions;
        private final List<Creator> creators;
        private final DateTime indexDataModified;
        private final Map<Language, String> titles;
        private final Image coverImage;
        private final List<Season> seasons;
        private final List<String> countryOfOrigin;
        private final List<Subject> subjects;

        @JsonCreator
        public Series(@JsonProperty(value="id") YleId id, @JsonProperty(value="description") Map<Language, String> descriptions, @JsonProperty(value="creator") List<Creator> creators, @JsonProperty(value="indexDataModified") DateTime indexDataModified, @JsonProperty(value="title") Map<Language, String> titles, @JsonProperty(value="coverImage") Image coverImage, @JsonProperty(value="season") List<Season> seasons, @JsonProperty(value="countryOfOrigin") List<String> countryOfOrigin, @JsonProperty(value="subject") List<Subject> subjects) {
            super((Serializable)id, (Serializable)YleId.UNIDENTIFIED);
            this.descriptions = descriptions;
            this.creators = creators;
            this.indexDataModified = indexDataModified;
            this.titles = titles;
            this.coverImage = coverImage;
            this.seasons = seasons;
            this.countryOfOrigin = countryOfOrigin;
            this.subjects = subjects;
        }

        public Map<Language, String> getDescriptions() {
            return this.descriptions;
        }

        public List<Creator> getCreators() {
            return this.creators;
        }

        public DateTime getIndexDataModified() {
            return this.indexDataModified;
        }

        public Map<Language, String> getTitles() {
            return this.titles;
        }

        public Image getCoverImage() {
            return this.coverImage;
        }

        public List<Season> getSeasons() {
            return this.seasons;
        }

        public List<String> getCountryOfOrigin() {
            return this.countryOfOrigin;
        }

        public List<Subject> getSubjects() {
            return this.subjects;
        }

        public String toString() {
            return "TvProgram.Series(descriptions=" + this.getDescriptions() + ", creators=" + this.getCreators() + ", indexDataModified=" + this.getIndexDataModified() + ", titles=" + this.getTitles() + ", coverImage=" + (Object)((Object)this.getCoverImage()) + ", seasons=" + this.getSeasons() + ", countryOfOrigin=" + this.getCountryOfOrigin() + ", subjects=" + this.getSubjects() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Series)) {
                return false;
            }
            Series other = (Series)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<Language, String> this$descriptions = this.getDescriptions();
            Map<Language, String> other$descriptions = other.getDescriptions();
            if (this$descriptions == null ? other$descriptions != null : !((Object)this$descriptions).equals(other$descriptions)) {
                return false;
            }
            List<Creator> this$creators = this.getCreators();
            List<Creator> other$creators = other.getCreators();
            if (this$creators == null ? other$creators != null : !((Object)this$creators).equals(other$creators)) {
                return false;
            }
            DateTime this$indexDataModified = this.getIndexDataModified();
            DateTime other$indexDataModified = other.getIndexDataModified();
            if (this$indexDataModified == null ? other$indexDataModified != null : !this$indexDataModified.equals(other$indexDataModified)) {
                return false;
            }
            Map<Language, String> this$titles = this.getTitles();
            Map<Language, String> other$titles = other.getTitles();
            if (this$titles == null ? other$titles != null : !((Object)this$titles).equals(other$titles)) {
                return false;
            }
            Image this$coverImage = this.getCoverImage();
            Image other$coverImage = other.getCoverImage();
            if (this$coverImage == null ? other$coverImage != null : !((Object)((Object)this$coverImage)).equals((Object)other$coverImage)) {
                return false;
            }
            List<Season> this$seasons = this.getSeasons();
            List<Season> other$seasons = other.getSeasons();
            if (this$seasons == null ? other$seasons != null : !((Object)this$seasons).equals(other$seasons)) {
                return false;
            }
            List<String> this$countryOfOrigin = this.getCountryOfOrigin();
            List<String> other$countryOfOrigin = other.getCountryOfOrigin();
            if (this$countryOfOrigin == null ? other$countryOfOrigin != null : !((Object)this$countryOfOrigin).equals(other$countryOfOrigin)) {
                return false;
            }
            List<Subject> this$subjects = this.getSubjects();
            List<Subject> other$subjects = other.getSubjects();
            return !(this$subjects == null ? other$subjects != null : !((Object)this$subjects).equals(other$subjects));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Series;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            Map<Language, String> $descriptions = this.getDescriptions();
            result = result * 59 + ($descriptions == null ? 0 : ((Object)$descriptions).hashCode());
            List<Creator> $creators = this.getCreators();
            result = result * 59 + ($creators == null ? 0 : ((Object)$creators).hashCode());
            DateTime $indexDataModified = this.getIndexDataModified();
            result = result * 59 + ($indexDataModified == null ? 0 : $indexDataModified.hashCode());
            Map<Language, String> $titles = this.getTitles();
            result = result * 59 + ($titles == null ? 0 : ((Object)$titles).hashCode());
            Image $coverImage = this.getCoverImage();
            result = result * 59 + ($coverImage == null ? 0 : ((Object)((Object)$coverImage)).hashCode());
            List<Season> $seasons = this.getSeasons();
            result = result * 59 + ($seasons == null ? 0 : ((Object)$seasons).hashCode());
            List<String> $countryOfOrigin = this.getCountryOfOrigin();
            result = result * 59 + ($countryOfOrigin == null ? 0 : ((Object)$countryOfOrigin).hashCode());
            List<Subject> $subjects = this.getSubjects();
            result = result * 59 + ($subjects == null ? 0 : ((Object)$subjects).hashCode());
            return result;
        }
    }

    public static class Season
    extends Entity<YleId> {
        private final Map<Language, String> description;
        private final int number;
        private final List<Creator> creators;
        private final YleId series;
        private final DateTime indexDataModified;
        private final Map<Language, String> title;
        private final List<String> countryOfOrigin;
        private final List<Subject> subjects;

        @JsonCreator
        public Season(@JsonProperty(value="description") Map<Language, String> description, @JsonProperty(value="seasonNumber") int number, @JsonProperty(value="creator") List<Creator> creators, @JsonProperty(value="partOfSeries") Map<String, YleId> series, @JsonProperty(value="indexDataModified") DateTime indexDataModified, @JsonProperty(value="title") Map<Language, String> title, @JsonProperty(value="countryOfOrigin") List<String> countryOfOrigin, @JsonProperty(value="id") YleId id, @JsonProperty(value="subject") List<Subject> subjects) {
            super((Serializable)id, (Serializable)YleId.UNIDENTIFIED);
            this.description = description;
            this.number = number;
            this.creators = creators;
            this.series = series.get("id");
            this.indexDataModified = indexDataModified;
            this.title = title;
            this.countryOfOrigin = countryOfOrigin;
            this.subjects = subjects;
        }

        public Map<Language, String> getDescription() {
            return this.description;
        }

        public int getNumber() {
            return this.number;
        }

        public List<Creator> getCreators() {
            return this.creators;
        }

        public YleId getSeries() {
            return this.series;
        }

        public DateTime getIndexDataModified() {
            return this.indexDataModified;
        }

        public Map<Language, String> getTitle() {
            return this.title;
        }

        public List<String> getCountryOfOrigin() {
            return this.countryOfOrigin;
        }

        public List<Subject> getSubjects() {
            return this.subjects;
        }

        public String toString() {
            return "TvProgram.Season(description=" + this.getDescription() + ", number=" + this.getNumber() + ", creators=" + this.getCreators() + ", series=" + this.getSeries() + ", indexDataModified=" + this.getIndexDataModified() + ", title=" + this.getTitle() + ", countryOfOrigin=" + this.getCountryOfOrigin() + ", subjects=" + this.getSubjects() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Season)) {
                return false;
            }
            Season other = (Season)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<Language, String> this$description = this.getDescription();
            Map<Language, String> other$description = other.getDescription();
            if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
                return false;
            }
            if (this.getNumber() != other.getNumber()) {
                return false;
            }
            List<Creator> this$creators = this.getCreators();
            List<Creator> other$creators = other.getCreators();
            if (this$creators == null ? other$creators != null : !((Object)this$creators).equals(other$creators)) {
                return false;
            }
            YleId this$series = this.getSeries();
            YleId other$series = other.getSeries();
            if (this$series == null ? other$series != null : !((Object)this$series).equals(other$series)) {
                return false;
            }
            DateTime this$indexDataModified = this.getIndexDataModified();
            DateTime other$indexDataModified = other.getIndexDataModified();
            if (this$indexDataModified == null ? other$indexDataModified != null : !this$indexDataModified.equals(other$indexDataModified)) {
                return false;
            }
            Map<Language, String> this$title = this.getTitle();
            Map<Language, String> other$title = other.getTitle();
            if (this$title == null ? other$title != null : !((Object)this$title).equals(other$title)) {
                return false;
            }
            List<String> this$countryOfOrigin = this.getCountryOfOrigin();
            List<String> other$countryOfOrigin = other.getCountryOfOrigin();
            if (this$countryOfOrigin == null ? other$countryOfOrigin != null : !((Object)this$countryOfOrigin).equals(other$countryOfOrigin)) {
                return false;
            }
            List<Subject> this$subjects = this.getSubjects();
            List<Subject> other$subjects = other.getSubjects();
            return !(this$subjects == null ? other$subjects != null : !((Object)this$subjects).equals(other$subjects));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Season;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            Map<Language, String> $description = this.getDescription();
            result = result * 59 + ($description == null ? 0 : ((Object)$description).hashCode());
            result = result * 59 + this.getNumber();
            List<Creator> $creators = this.getCreators();
            result = result * 59 + ($creators == null ? 0 : ((Object)$creators).hashCode());
            YleId $series = this.getSeries();
            result = result * 59 + ($series == null ? 0 : ((Object)$series).hashCode());
            DateTime $indexDataModified = this.getIndexDataModified();
            result = result * 59 + ($indexDataModified == null ? 0 : $indexDataModified.hashCode());
            Map<Language, String> $title = this.getTitle();
            result = result * 59 + ($title == null ? 0 : ((Object)$title).hashCode());
            List<String> $countryOfOrigin = this.getCountryOfOrigin();
            result = result * 59 + ($countryOfOrigin == null ? 0 : ((Object)$countryOfOrigin).hashCode());
            List<Subject> $subjects = this.getSubjects();
            result = result * 59 + ($subjects == null ? 0 : ((Object)$subjects).hashCode());
            return result;
        }
    }
}

