/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.api.programs;

import com.fasterxml.jackson.core.type.TypeReference;
import io.induct.rest.ApiResponse;
import io.induct.rest.Request;
import io.induct.yle.api.StandardizedApi;
import io.induct.yle.api.YleId;
import io.induct.yle.api.common.Language;
import io.induct.yle.api.programs.domain.CuratedList;
import io.induct.yle.api.programs.domain.Item;
import io.induct.yle.api.programs.domain.NowPlaying;
import io.induct.yle.api.programs.domain.items.Service;
import io.induct.yle.api.programs.domain.search.ItemSearch;
import java.util.List;
import javax.inject.Inject;

public class YleProgramsApi
extends StandardizedApi {
    public static final String PROGRAMS_BASE_URL = "https://external.api.yle.fi";
    private final TypeReference<ApiResponse<List<Service>>> listOfServices = new TypeReference<ApiResponse<List<Service>>>(){};
    private final TypeReference<ApiResponse<List<Item>>> listOfItems = new TypeReference<ApiResponse<List<Item>>>(){};
    private final TypeReference<ApiResponse<Item>> singleItem = new TypeReference<ApiResponse<Item>>(){};
    private final TypeReference<ApiResponse<List<CuratedList>>> listOfCuratedLists = new TypeReference<ApiResponse<List<CuratedList>>>(){};
    private final TypeReference<ApiResponse<List<NowPlaying>>> nowPlaying = new TypeReference<ApiResponse<List<NowPlaying>>>(){};

    @Inject
    public YleProgramsApi() {
        super(PROGRAMS_BASE_URL);
    }

    public ApiResponse<List<Service>> listServices(Service.Type type, int limit, int offset) {
        Request request = this.createRequestBuilder().withPath("/v1/programs/services.json").withParams(params -> {
            params.put((Object)"type", (Object)type.value());
            params.put((Object)"limit", (Object)Integer.toString(limit));
            params.put((Object)"offset", (Object)Integer.toString(offset));
        }).build();
        return this.handleApiCall(request, this.listOfServices);
    }

    public ApiResponse<List<Item>> search(ItemSearch search) {
        Request request = this.createRequestBuilder().withPath("/v1/programs/items.json").withParams(params -> params.putAll(search.getParams())).build();
        return this.handleApiCall(request, this.listOfItems);
    }

    public ApiResponse<List<CuratedList>> listCuratedLists(Language language, CuratedList.Type type, int limit, int offset) {
        Request request = this.createRequestBuilder().withPath("/v1/programs/lists.json").withParams(params -> {
            params.put((Object)"language", (Object)language.getLanguageCode());
            params.put((Object)"type", (Object)type.value());
            params.put((Object)"limit", (Object)Integer.toString(limit));
            params.put((Object)"offset", (Object)Integer.toString(offset));
        }).build();
        return this.handleApiCall(request, this.listOfCuratedLists);
    }

    public ApiResponse<Item> getItem(YleId yleId) {
        Request request = this.createRequestBuilder().withPath("/v1/programs/items/" + yleId.identity() + ".json").build();
        return this.handleApiCall(request, this.singleItem);
    }

    public ApiResponse<List<NowPlaying>> nowPlaying(String id) {
        Request request = this.createRequestBuilder().withPath("/v1/programs/nowplaying/" + id + ".json").withParams(params -> {
            params.put((Object)"start", (Object)Integer.toString(-1));
            params.put((Object)"end", (Object)Integer.toString(1));
        }).build();
        return this.handleApiCall(request, this.nowPlaying);
    }
}

