/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.api.common;

import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.RateLimiter;
import io.induct.rest.Request;
import io.induct.rest.RequestBuilder;
import io.induct.yle.api.common.RateLimitingRequest;
import java.io.InputStream;
import java.util.function.Consumer;

public class RateLimitingRequestBuilder
implements RequestBuilder {
    private final RateLimiter rateLimiter;
    private final RequestBuilder delegate;

    public RateLimitingRequestBuilder(RateLimiter rateLimiter, RequestBuilder delegate) {
        this.rateLimiter = rateLimiter;
        this.delegate = delegate;
    }

    @Override
    public RequestBuilder withBaseUrl(String baseUrl) {
        this.delegate.withBaseUrl(baseUrl);
        return this;
    }

    @Override
    public RequestBuilder withPath(String path) {
        this.delegate.withPath(path);
        return this;
    }

    @Override
    public RequestBuilder withHeaders(Consumer<Multimap<String, String>> contributor) {
        this.delegate.withHeaders(contributor);
        return this;
    }

    @Override
    public RequestBuilder withParams(Consumer<Multimap<String, String>> contributor) {
        this.delegate.withParams(contributor);
        return this;
    }

    @Override
    public RequestBuilder withBody(InputStream body) {
        this.delegate.withBody(body);
        return this;
    }

    @Override
    public Request build() {
        return new RateLimitingRequest(this.rateLimiter, this.delegate.build());
    }
}

