/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.api.common;

import com.google.common.util.concurrent.RateLimiter;
import io.induct.http.Response;
import io.induct.rest.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitingRequest
extends Request {
    private final Logger log = LoggerFactory.getLogger(RateLimitingRequest.class);
    private final RateLimiter rateLimiter;

    public RateLimitingRequest(RateLimiter rateLimiter, Request request) {
        super(request.getHttp(), request.getUrl(), request.getHeaders(), request.getParams(), request.getBody());
        this.rateLimiter = rateLimiter;
    }

    @Override
    protected Response call(Request.Method m) {
        double delayed = this.rateLimiter.acquire();
        if (delayed > 0.0) {
            this.log.debug("Rate limit exceeded, call delayed by {} seconds", (Object)delayed);
        }
        return super.call(m);
    }
}

