/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.api.common;

import com.google.common.util.concurrent.RateLimiter;
import io.induct.http.HttpClient;
import io.induct.rest.DefaultRequestBuilder;
import io.induct.rest.RequestBuilder;
import io.induct.yle.api.common.RateLimitingRequestBuilder;
import javax.inject.Inject;
import javax.inject.Named;

public class Infrastructure {
    private final HttpClient httpClient;
    private final String appId;
    private final String appKey;

    @Inject
    public Infrastructure(HttpClient httpClient, @Named(value="yle.api.appId") String appId, @Named(value="yle.api.appKey") String appKey) {
        this.httpClient = httpClient;
        this.appId = appId;
        this.appKey = appKey;
    }

    public RequestBuilder createRequestBuilder(String baseUrl, RateLimiter rateLimiter) {
        return new RateLimitingRequestBuilder(rateLimiter, new DefaultRequestBuilder(this.httpClient).withBaseUrl(baseUrl).withParams(params -> {
            params.put((Object)"app_id", (Object)this.appId);
            params.put((Object)"app_key", (Object)this.appKey);
        }));
    }
}

