/*
 * Decompiled with CFR 0.152.
 */
package io.induct.yle.api;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import io.induct.domain.Identifiable;
import java.io.Serializable;

public class YleId
implements Identifiable<String>,
Serializable,
Comparable<YleId> {
    public static final YleId UNIDENTIFIED = new YleId("");
    private static final ImmutableMap<String, Type> prefixLookup = YleId.buildPrefixLookup();
    private final Type type;
    private final String identity;

    @Override
    public int compareTo(YleId that) {
        return this.identity.compareTo(that.identity);
    }

    private static ImmutableMap<String, Type> buildPrefixLookup() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Type type : Type.values()) {
            builder.put((Object)type.prefix, (Object)type);
        }
        return builder.build();
    }

    public YleId(String id) {
        String prefix;
        this.type = !id.contains("-") ? Type.UNKNOWN : (prefixLookup.containsKey((Object)(prefix = id.substring(0, id.indexOf(45) + 1))) ? (Type)((Object)prefixLookup.get((Object)prefix)) : Type.UNKNOWN);
        this.identity = id;
    }

    public boolean is(Type type) {
        return type.equals((Object)type);
    }

    public Type getType() {
        return this.type;
    }

    @JsonGetter(value="id")
    public String identity() {
        return this.identity;
    }

    public boolean isIdentified() {
        return !this.identity.equals(UNIDENTIFIED);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.identity});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YleId other = (YleId)obj;
        return Objects.equal((Object)this.identity, (Object)other.identity);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("identity", (Object)this.identity).toString();
    }

    public static enum Type {
        ESCENIC("3-"),
        PROGRAM_OR_SERIES("1-"),
        MEDIA("6-"),
        SYNDI("7-"),
        RADIOMAN("12-"),
        IMAGE("13-"),
        CONCEPT("18-"),
        FYNDI("20-"),
        UNKNOWN("");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

