/*
 * Decompiled with CFR 0.152.
 */
package io.induct.http.builders;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.induct.http.HttpClient;
import io.induct.http.builders.Request;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.function.Consumer;

public class RequestBuilder {
    private static final InputStream EMPTY_BODY = new ByteArrayInputStream(new byte[0]);
    private final HttpClient httpClient;
    private final String url;
    private final Multimap<String, String> headers;
    private final Multimap<String, String> params;
    private final InputStream body;

    public RequestBuilder(HttpClient httpClient) {
        this(httpClient, null, (Multimap<String, String>)HashMultimap.create(), (Multimap<String, String>)HashMultimap.create(), EMPTY_BODY);
    }

    private RequestBuilder(HttpClient httpClient, String url, Multimap<String, String> headers, Multimap<String, String> params, InputStream body) {
        this.httpClient = httpClient;
        this.url = url;
        this.headers = headers;
        this.params = params;
        this.body = body;
    }

    public RequestBuilder withUrl(String url) {
        return new RequestBuilder(this.httpClient, url, (Multimap<String, String>)HashMultimap.create(this.headers), (Multimap<String, String>)HashMultimap.create(this.params), this.body);
    }

    public RequestBuilder withHeaders(Consumer<Multimap<String, String>> headerContributor) {
        HashMultimap newHeaders = HashMultimap.create(this.headers);
        headerContributor.accept((Multimap<String, String>)newHeaders);
        return new RequestBuilder(this.httpClient, this.url, (Multimap<String, String>)newHeaders, (Multimap<String, String>)HashMultimap.create(this.params), this.body);
    }

    public RequestBuilder withParams(Consumer<Multimap<String, String>> paramContributor) {
        HashMultimap newParams = HashMultimap.create(this.params);
        paramContributor.accept((Multimap<String, String>)newParams);
        return new RequestBuilder(this.httpClient, this.url, (Multimap<String, String>)HashMultimap.create(this.headers), (Multimap<String, String>)newParams, this.body);
    }

    public RequestBuilder withBody(InputStream newBody) {
        return new RequestBuilder(this.httpClient, this.url, (Multimap<String, String>)HashMultimap.create(this.headers), (Multimap<String, String>)HashMultimap.create(this.params), newBody);
    }

    public Request build() {
        return new Request(this.httpClient, this.url, (Multimap<String, String>)HashMultimap.create(this.headers), (Multimap<String, String>)HashMultimap.create(this.params), this.body);
    }
}

