/*
 * Decompiled with CFR 0.152.
 */
package io.igia.commons.hipaa;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import io.igia.commons.hipaa.HipaaAuditProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;

public class HipaaResponseAuditZuulFilter
extends ZuulFilter {
    public static final String AUDIT_APPLICATION_EVENT_TYPE = "HIPAA_AUDIT";
    private final Logger log = LoggerFactory.getLogger(HipaaResponseAuditZuulFilter.class);
    private HipaaAuditProperties applicationProperties;
    private ApplicationEventPublisher publisher;

    @Autowired
    public HipaaResponseAuditZuulFilter(ApplicationEventPublisher publisher, HipaaAuditProperties applicationProperties) {
        this.publisher = publisher;
        this.applicationProperties = applicationProperties;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 999;
    }

    public boolean shouldFilter() {
        String requestMethod = RequestContext.getCurrentContext().getRequest().getMethod();
        if (!requestMethod.equals(HttpMethod.GET.name()) && !requestMethod.equals(HttpMethod.POST.name())) {
            return false;
        }
        String requestUri = RequestContext.getCurrentContext().getRequest().getQueryString() != null ? String.join((CharSequence)"", RequestContext.getCurrentContext().getRequest().getRequestURI(), "?", RequestContext.getCurrentContext().getRequest().getQueryString()) : RequestContext.getCurrentContext().getRequest().getRequestURI();
        return !this.isRequestUriInBlacklistPatterns(requestUri) && this.isRequestUriInWhitelistPatterns(requestUri);
    }

    private boolean isRequestUriInBlacklistPatterns(String requestUri) {
        List<String> patterns = this.applicationProperties.getHipaaResponseBlacklistUriPatterns();
        boolean isAvailable = patterns.stream().anyMatch(s -> requestUri.matches((String)s));
        return isAvailable;
    }

    private boolean isRequestUriInWhitelistPatterns(String requestUri) {
        List<String> patterns = this.applicationProperties.getHipaaResponseWhitelistUriPatterns();
        boolean isAvailable = patterns.stream().anyMatch(s -> requestUri.matches((String)s));
        return isAvailable;
    }

    public Object run() {
        String principal = SecurityContextHolder.getContext().getAuthentication().getName();
        HashMap<String, String> data = new HashMap<String, String>();
        RequestContext ctx = RequestContext.getCurrentContext();
        try (InputStream responseDataStream = ctx.getResponseDataStream();){
            byte[] ba = IOUtils.toByteArray((InputStream)responseDataStream);
            InputStream is = new ByteArrayInputStream(ba);
            if (ctx.getResponseGZipped()) {
                is = new GZIPInputStream(is);
            }
            String responseBody = IOUtils.toString((InputStream)is, (String)ctx.getResponse().getCharacterEncoding());
            data.put("responseBody", responseBody);
            data.put("remoteAddress", ctx.getRequest().getRemoteAddr());
            data.put("message", String.join((CharSequence)"", "API ", ctx.getRequest().getRequestURI(), " accessed"));
            ctx.setResponseDataStream((InputStream)new ByteArrayInputStream(ba));
        }
        catch (IOException e) {
            this.log.error("Error reading response body", (Throwable)e);
            throw new ZuulRuntimeException(new ZuulException((Throwable)e, HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage()));
        }
        AuditApplicationEvent event = new AuditApplicationEvent(principal, AUDIT_APPLICATION_EVENT_TYPE, data);
        this.publisher.publishEvent((ApplicationEvent)event);
        return null;
    }
}

