/*
 * Decompiled with CFR 0.152.
 */
package io.igia.commons.hipaa;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import io.igia.commons.hipaa.HipaaAuditProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.context.SecurityContextHolder;

public class HipaaAuditZuulFilter
extends ZuulFilter {
    public static final String AUDIT_APPLICATION_EVENT_TYPE = "HIPAA_AUDIT";
    private final ApplicationEventPublisher publisher;
    private HipaaAuditProperties applicationProperties;

    @Autowired
    public HipaaAuditZuulFilter(ApplicationEventPublisher publisher, HipaaAuditProperties applicationProperties) {
        this.publisher = publisher;
        this.applicationProperties = applicationProperties;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 20;
    }

    public boolean shouldFilter() {
        String requestMethod = RequestContext.getCurrentContext().getRequest().getMethod();
        if (requestMethod.equals(HttpMethod.OPTIONS.name())) {
            return false;
        }
        String requestUri = RequestContext.getCurrentContext().getRequest().getRequestURI();
        return !this.isRequestUriInBlacklistPatterns(requestUri) && this.isRequestUriInWhitelistPatterns(requestUri);
    }

    private boolean isRequestUriInBlacklistPatterns(String requestUri) {
        List<String> patterns = this.applicationProperties.getHipaaBlacklistUriPatterns();
        boolean isAvailable = patterns.stream().anyMatch(s -> requestUri.matches((String)s));
        return isAvailable;
    }

    private boolean isRequestUriInWhitelistPatterns(String requestUri) {
        List<String> patterns = this.applicationProperties.getHipaaWhitelistUriPatterns();
        boolean isAvailable = patterns.stream().anyMatch(s -> requestUri.matches((String)s));
        return isAvailable;
    }

    public Object run() {
        String principal = SecurityContextHolder.getContext().getAuthentication().getName();
        HashMap<String, String> data = new HashMap<String, String>();
        HttpServletRequest req = RequestContext.getCurrentContext().getRequest();
        data.put("remoteAddress", req.getRemoteAddr());
        data.put("httpMethod", req.getMethod());
        data.put("requestUri", req.getRequestURI());
        data.put("requestParam", this.convert(req.getParameterMap()));
        data.put("message", String.join((CharSequence)"", "Attempt to access API ", req.getRequestURI()));
        AuditApplicationEvent event = new AuditApplicationEvent(principal, AUDIT_APPLICATION_EVENT_TYPE, data);
        this.publisher.publishEvent((ApplicationEvent)event);
        return null;
    }

    private String convert(Map<String, String[]> paraMap) {
        return paraMap.entrySet().stream().filter(s -> !"cacheBuster".equals(s.getKey())).map(s -> (String)s.getKey() + ":" + Arrays.toString((Object[])s.getValue())).collect(Collectors.joining(", "));
    }
}

