package io.idco.idcorp.tools;

import android.annotation.SuppressLint;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;

/**
 * Created by 1HE on 7/5/2016.
 */
@SuppressWarnings("ALL")
public class IDViewHelper {


    public static void addOnGlobalLayout(final View v, final IGlobalLayoutListener listener){
        ViewTreeObserver vto = v.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {

            @SuppressLint("ObsoleteSdkInt")
            @Override
            public void onGlobalLayout() {
                ViewTreeObserver obs = v.getViewTreeObserver();
                if(listener != null)
                    listener.onAdded();
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                    obs.removeOnGlobalLayoutListener(this);
                } else {
                    //noinspection deprecation
                    obs.removeGlobalOnLayoutListener(this);
                }
            }

        });
    }


    public interface IGlobalLayoutListener{
        void onAdded();
    }

}
