package io.idco.idcorp.tools;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * Created by 1HE on 7/5/2016.
 */
@SuppressWarnings("ALL")
public class IDSharedPreferencesHelper {

    public static final String SETTING = "MainSetting"; // not clear after update app

    public static boolean getBoolean(Context c, String settingName, String key,
            boolean def) {

        SharedPreferences s = c.getSharedPreferences(settingName, 0);
        return s.getBoolean(key, def);

    }

    public static void setBoolean(Context c, String settingName, String key,
            boolean value) {

        SharedPreferences s = c.getSharedPreferences(settingName, 0);
        SharedPreferences.Editor editor = s.edit();
        editor.putBoolean(key, value);
        editor.apply();

    }


    public static int getInt(Context c, String settingName, String key,
            int def) {

        SharedPreferences s = c.getSharedPreferences(settingName, 0);
        return s.getInt(key, def);

    }

    public static void setInt(Context c, String settingName, String key,
            int value) {

        SharedPreferences s = c.getSharedPreferences(settingName, 0);
        SharedPreferences.Editor editor = s.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    public static String getString(Context c, String settingName, String key,
            String def) {

        SharedPreferences s = c.getSharedPreferences(settingName, 0);
        return s.getString(key,def);

    }

    public static void setString(Context c, String settingName, String key,
            String value) {

        SharedPreferences s = c.getSharedPreferences(settingName, 0);
        SharedPreferences.Editor editor = s.edit();
        editor.putString(key, value);
        editor.apply();

    }

    public static long getLong(Context c, String settingName, String key,
            long def) {

        SharedPreferences s = c.getSharedPreferences(settingName, 0);
        return s.getLong(key,def);

    }

    public static void setLong(Context c, String settingName, String key,
            long value) {

        SharedPreferences s = c.getSharedPreferences(settingName, 0);
        SharedPreferences.Editor editor = s.edit();
        editor.putLong(key,value);
        editor.apply();

    }

}
