package io.idco.idcorp.tools;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import java.util.List;
import java.util.concurrent.TimeUnit;

import io.idco.idcorp.instances.IDResultWebService;
import io.idco.idcorp.instances.IDUrlParameter;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * Created by 1HE on 06/28/2016.
 */

@SuppressWarnings({"unused", "DefaultFileTemplate"})
public class IDInternetHelper {
    private static final String TAG = "fff" + IDInternetHelper.class.getSimpleName();

    private static final String ERROR = "error";
    private static final int TIMEOUT_CONNECT = 15000;
    private static final int TIMEOUT_READ = 30000;
    private static final int TIMEOUT_WRITE = 30000;

    public static boolean isOnline(Context c) {
        try {
            ConnectivityManager cm = (ConnectivityManager) c
                    .getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnectedOrConnecting();
        } catch (NullPointerException e) {
            return false;
        }
    }


    public static IDResultWebService getResultWithGet(String u, List<IDUrlParameter> parameters) {
        IDLogHelper.d(TAG, "start get : " + u);
        int code = IDResultWebService.CODE_FAIL;
        try {
            OkHttpClient client = getClient();
            Request.Builder requestBuilder = new Request.Builder().url(u).get();
            requestBuilder.addHeader("connection", "close");
            for (IDUrlParameter up : parameters) {
                IDLogHelper.d(TAG + "_header", up.getParameter() + " : " + up.getValue());
                requestBuilder.addHeader(up.getParameter(), up.getValue());
            }
            Request request = requestBuilder.build();

            Response response = client.newCall(request).execute();
            String body = response.body().string();
            IDLogHelper.d(TAG, "end get : " + body);
            return new IDResultWebService(response.code(), body);
        } catch (Exception e) {
            e.printStackTrace();
            IDLogHelper.d(TAG, "end get with error");
            return new IDResultWebService(code, ERROR);
        }
    }


    public static IDResultWebService getResultWithPost(String u, List<IDUrlParameter> parameters) {
        IDLogHelper.d(TAG, "start post : " + u);
        int code = IDResultWebService.CODE_FAIL;
        try {
            FormBody.Builder formBody = new FormBody.Builder();
            for (IDUrlParameter up : parameters) {
                IDLogHelper.d(TAG, up.getParameter() + " : " + up.getValue());
                if (up.getType() == IDUrlParameter.TYPE_BODY) {
                    formBody.add(up.getParameter(), up.getValue());
                }
            }

            RequestBody requestBody = formBody.build();

            OkHttpClient client = getClient();
            Request.Builder requestBuilder = new Request.Builder().url(u).post(requestBody);
            requestBuilder.addHeader("connection", "close");
            for (IDUrlParameter up : parameters) {
                if (up.getType() == IDUrlParameter.TYPE_HEADER)
                    requestBuilder.addHeader(up.getParameter(), up.getValue());
            }
            Request request = requestBuilder.build();

            Response response = client.newCall(request).execute();
            String body = response.body().string();
            IDLogHelper.d(TAG, "end post : " + body);
            return new IDResultWebService(response.code(), body);
        } catch (Exception e) {
            e.printStackTrace();
            IDLogHelper.d(TAG, "end post with error");
            return new IDResultWebService(code, ERROR);
        }
    }

    private static OkHttpClient getClient() {
//        try {
//            Thread.sleep(5000);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
        //noinspection UnnecessaryLocalVariable
        OkHttpClient client = new OkHttpClient.Builder()
                .connectTimeout(TIMEOUT_CONNECT, TimeUnit.MILLISECONDS)
                .writeTimeout(TIMEOUT_WRITE, TimeUnit.SECONDS)
                .readTimeout(TIMEOUT_READ, TimeUnit.SECONDS)
                .build();
        return client;
    }
}

