package io.idco.idcorp.tools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

/**
 * Created by 1HE on 7/5/2016.
 */
@SuppressWarnings("ALL")
public class IDIntentHelper {


    public static void goDownloadApp(Context c, String url) {
        Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
        c.startActivity(i);
    }

    public static void sendEmail(Context c, String email) {

        Intent emailIntent = new Intent(Intent.ACTION_SENDTO, Uri.fromParts(
                "mailto",email, null));

        try {
            c.startActivity(Intent.createChooser(emailIntent, ""));
        } catch (android.content.ActivityNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static void goFacebookPage(Context context,String pageName,String pageId) {

        try {
            context.getPackageManager().getPackageInfo("com.facebook.katana", 0);
            context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("fb://page/" + pageId)));
        } catch (Exception e) {
            context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://www.facebook.com/" + pageName)));
        }
    }

    public static void goInstagramPage(Context context,String pageName) {

        try {
            Uri uri = Uri.parse("http://instagram.com/_u/"+pageName);
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            intent.setPackage("com.instagram.android");
            context.startActivity(intent);
        } catch (Exception e) {
            context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://instagram.com/" + pageName)));
        }
    }

    public static void goTelegramPage(Context context,String pageName) {

        try {
            Uri uri = Uri.parse("https://telegram.me/"+pageName);
            Intent telegram = new Intent(Intent.ACTION_VIEW , uri);
            context.startActivity(telegram);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startStoreApp(Context c, String s1, String s2) {
        try {
            c.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(s1)));
        } catch (android.content.ActivityNotFoundException anfe) {
            c.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(s2)));
        }
    }

    public static void startDialer(Activity activity, String phone) {
        try {
            Intent intent = new Intent(Intent.ACTION_DIAL);
            intent.setData(Uri.parse("tel:"+phone));
            activity.startActivity(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
