package io.idco.idcorp.tools;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.bumptech.glide.DrawableRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestListener;

import io.idco.idcorp.R;


/**
 * Created by 1HE on 7/5/2016.
 */
@SuppressWarnings("ALL")
public class IDImageViewHelper {


    public static final PlaceHolder HOLDER_ABOUT = new PlaceHolder(1, R.drawable.icdorp_default_about);

    public static void load(Context context, ImageView iv, double width, double height, String data, PlaceHolder placeHolder) {

        DrawableRequestBuilder requestBuilder = createRequest(context, iv, width, height, data, placeHolder, true, null);
        if (requestBuilder == null)
            return;

        requestBuilder.into(iv);
    }

    public static void loadWithListener(Context context, ImageView iv, int width, int height, String data, PlaceHolder placeHolder, RequestListener listener) {

        DrawableRequestBuilder requestBuilder = createRequest(context, iv, width, height, data, placeHolder, true, listener);
        if (requestBuilder == null)
            return;

        requestBuilder.into(iv);
    }

    public static void loadNoTransform(Context context, ImageView iv, int width, int height, String data, PlaceHolder placeHolder, RequestListener listener) {

        DrawableRequestBuilder requestBuilder = createRequest(context, iv, width, height, data, placeHolder, false, listener);
        if (requestBuilder == null)
            return;

        requestBuilder.into(iv);
    }

    @SuppressWarnings("unchecked")
    private static DrawableRequestBuilder createRequest(Context context, ImageView iv, double width, double height, String data, PlaceHolder placeHolder, boolean transform, RequestListener listener) {
        if (IDStringHelper.isEmpty(data)) {
            return null;
        }

        if (width > 0 || height > 0) { //width = ratio
            ViewGroup.LayoutParams params = iv.getLayoutParams();
            params.width = IDDisplayHelper.getDisplaySize(context).x;
            params.height = (int) (params.width / width);
            iv.setLayoutParams(params);
        }
        DrawableRequestBuilder requestBuilder;
        requestBuilder = Glide.with(context).load(data);


        requestBuilder = requestBuilder.diskCacheStrategy(DiskCacheStrategy.ALL);
        requestBuilder = requestBuilder.placeholder(placeHolder.getResource());
        if (listener != null)
            requestBuilder = requestBuilder.listener(listener);
        if (!transform)
            requestBuilder = requestBuilder.dontTransform();

        return requestBuilder;
    }


    public static String createImageUrl(String type, String in) {
        return type + in;
    }

    public static class PlaceHolder {
        private int id;
        private int resource;

        public PlaceHolder(int id, int resource) {
            setId(id);
            setResource(resource);
        }

        public int getId() {
            return id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getResource() {
            return resource;
        }

        public void setResource(int resource) {
            this.resource = resource;
        }
    }

}
