package io.idco.idcorp;

/**
 * Created by 1HE on 7/5/2016.
 */

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import java.util.List;

import io.idco.idcorp.instances.AboutUsParentItem;
import io.idco.idcorp.tools.IDDisplayHelper;

class AboutUsDecoration extends RecyclerView.ItemDecoration {

    private List<AboutUsParentItem> list;

    AboutUsDecoration(List<AboutUsParentItem> list) {
        setList(list);
    }

    private void setList(List<AboutUsParentItem> list) {
        this.list = list;
    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent,
                               RecyclerView.State state) {

        int position = parent.getChildAdapterPosition(view);
        AboutUsParentItem item = list.get(position);
        if (position == 0)
            outRect.top = IDDisplayHelper.i(8);

        outRect.bottom = IDDisplayHelper.i(8);

        if(item.getType() == AboutUsParentItem.TYPE_DIVIDER){
            outRect.bottom = IDDisplayHelper.i(16);
            outRect.top = IDDisplayHelper.i(16);
            outRect.left = IDDisplayHelper.i(8);
            outRect.right = IDDisplayHelper.i(8);
        }
        if(item.getType() == AboutUsParentItem.TYPE_CONTACT){
            outRect.bottom = IDDisplayHelper.i(24);
        }
    }

}