package io.idco.idcorp;

/**
 * Created by 1HE on 7/5/2016.
 */

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import java.util.List;

import io.idco.idcorp.instances.AboutUsContactItem;
import io.idco.idcorp.instances.AboutUsDescriptionItem;
import io.idco.idcorp.instances.AboutUsHeaderItem;
import io.idco.idcorp.instances.AboutUsParentItem;
import io.idco.idcorp.instances.AboutUsServiceItem;
import io.idco.idcorp.tools.IDDisplayHelper;
import io.idco.idcorp.tools.IDImageViewHelper;
import io.idco.idcorp.tools.IDIntentHelper;
import io.idco.idcorp.tools.IDStringHelper;
import io.idco.idcorp.tools.IDViewHelper;
import io.idco.idcorp.views.IDMyButton;
import io.idco.idcorp.views.IDMyTextView;

class AboutUsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private final Activity activity;
    private final List<AboutUsParentItem> mDataset;
    private final LinearLayoutManager linearLayoutManager;
    private Boolean showAnimation = true;

    public AboutUsAdapter(Activity activity, List<AboutUsParentItem> myDataset, LinearLayoutManager linearLayoutManager) {
        this.activity = activity;
        mDataset = myDataset;
        this.linearLayoutManager = linearLayoutManager;
    }

    @Override
    public int getItemViewType(int position) {
        return mDataset.get(position).getType();
    }

    @Override
    public int getItemCount() {
        return mDataset.size();
    }


    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {

        View v;
        switch (viewType) {
            case AboutUsParentItem.TYPE_HEADER:
                v = LayoutInflater.from(parent.getContext())
                        .inflate(R.layout.list_aboutus_header, parent, false);
                return new ViewHolderAboutUsHeader(v);
            case AboutUsParentItem.TYPE_DESCRIPTION:
                v = LayoutInflater.from(parent.getContext())
                        .inflate(R.layout.list_aboutus_description, parent, false);
                return new ViewHolderAboutUsDescription(v);
            case AboutUsParentItem.TYPE_CONTACT:
                v = LayoutInflater.from(parent.getContext())
                        .inflate(R.layout.list_aboutus_contact, parent, false);
                return new ViewHolderAboutUsContact(v);
            case AboutUsParentItem.TYPE_SERVICE:
                v = LayoutInflater.from(parent.getContext())
                        .inflate(R.layout.list_aboutus_service, parent, false);
                return new ViewHolderAboutUsService(v);
            case AboutUsParentItem.TYPE_DIVIDER:
                v = LayoutInflater.from(parent.getContext())
                        .inflate(R.layout.list_aboutus_divider, parent, false);
                return new ViewHolderAboutUsDivider(v);
        }
        return null;
    }

    @Override
    public void onBindViewHolder(final RecyclerView.ViewHolder viewHolder, int i) {

        int viewType = mDataset.get(i).getType();
        final int j = i;

        switch (viewType) {
            case AboutUsParentItem.TYPE_HEADER:
                onBindHeader((ViewHolderAboutUsHeader) viewHolder, i);
                break;
            case AboutUsParentItem.TYPE_DESCRIPTION:
                onBindDescription((ViewHolderAboutUsDescription) viewHolder, i);
                break;
            case AboutUsParentItem.TYPE_CONTACT:
                onBindContact((ViewHolderAboutUsContact) viewHolder, i);
                break;
            case AboutUsParentItem.TYPE_SERVICE:
                onBindService((ViewHolderAboutUsService) viewHolder, i);
                break;
            case AboutUsParentItem.TYPE_DIVIDER:
                onBindDivider((ViewHolderAboutUsDivider) viewHolder, i);
                break;
        }

        if (showAnimation) {
            IDViewHelper.addOnGlobalLayout(viewHolder.itemView, new IDViewHelper.IGlobalLayoutListener() {
                @Override
                public void onAdded() {
                    showAnimation = startAnimation(j, viewHolder.itemView);
                }
            });

        }

    }

    private void onBindHeader(ViewHolderAboutUsHeader vh, int i) {
        AboutUsHeaderItem item = (AboutUsHeaderItem) mDataset.get(i);
        vh.tv.setText(item.getText());
    }

    private void onBindDescription(ViewHolderAboutUsDescription vh, int i) {
        AboutUsDescriptionItem item = (AboutUsDescriptionItem) mDataset.get(i);
        vh.tv.setText(item.getText());
    }

    private void onBindContact(ViewHolderAboutUsContact vh, int i) {
        final AboutUsContactItem item = (AboutUsContactItem) mDataset.get(i);

        vh.ll_call.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                IDIntentHelper.startDialer(activity,item.getCall());
            }
        });

        vh.ll_web.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                IDIntentHelper.goDownloadApp(activity,item.getWeb());
            }
        });

        vh.ll_email.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                IDIntentHelper.sendEmail(activity,item.getEmail());
            }
        });

        vh.ll_facebook.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                IDIntentHelper.goFacebookPage(activity,item.getFacebookPageName(),item.getFacebookPageId());
            }
        });

        vh.ll_instagram.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                IDIntentHelper.goInstagramPage(activity,item.getInstagram());
            }
        });

        vh.ll_telegram.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                IDIntentHelper.goTelegramPage(activity,item.getTelegram());
            }
        });

        vh.tv_web.setText(item.getWeb());
        vh.tv_call.setText(item.getCall());
        vh.tv_email.setText(item.getEmail());
        vh.tv_facebook.setText(item.getFacebookPageName());
        vh.tv_instagram.setText(item.getInstagram());
        vh.tv_telegram.setText(item.getTelegram());
    }

    private void onBindService(ViewHolderAboutUsService vh, int i) {
        final AboutUsServiceItem item = (AboutUsServiceItem) mDataset.get(i);
        IDImageViewHelper.load(activity,vh.iv_icon,0,0,item.getImageUrl(), IDImageViewHelper.HOLDER_ABOUT);
        vh.tv_title.setText(item.getTitle());
        vh.tv_description.setText(item.getDescription());
        if(IDStringHelper.isEmpty(item.getUrl()))
            vh.bt_view.setVisibility(View.GONE);
        else
            vh.bt_view.setVisibility(View.VISIBLE);
        vh.bt_view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                    IDIntentHelper.startStoreApp(activity,item.getUrl(),item.getUrl());
            }
        });
    }

    @SuppressWarnings({"UnusedParameters", "EmptyMethod"})
    private void onBindDivider(ViewHolderAboutUsDivider vh, int i) {
    }

    private boolean startAnimation(final int pos, final View v) {
        if (linearLayoutManager == null)
            return true;
        if (pos >= 0 && pos <= linearLayoutManager.findLastVisibleItemPosition()) {


            ViewCompat.setAlpha(v, 0);
            v.setTranslationY(IDDisplayHelper.i((pos + 1) * 200));
            ObjectAnimator alpha = ObjectAnimator.ofFloat(v, "alpha", 1);
            ObjectAnimator translationY = ObjectAnimator.ofFloat(v, "translationY", 0);
            AnimatorSet set = new AnimatorSet();
            set.playTogether(alpha,translationY);
            set.setInterpolator(new LinearOutSlowInInterpolator());
            set.setDuration(800);
            set.setStartDelay((pos + 1) * 30);
            set.start();
        }


        return pos != linearLayoutManager.findLastVisibleItemPosition();

    }

    public static class ViewHolderAboutUsHeader extends RecyclerView.ViewHolder {

        public final IDMyTextView tv;

        public ViewHolderAboutUsHeader(View v) {
            super(v);
            tv = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_header);
        }
    }

    public static class ViewHolderAboutUsDescription extends RecyclerView.ViewHolder {

        public final IDMyTextView tv;

        public ViewHolderAboutUsDescription(View v) {
            super(v);
            tv = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_description);
        }
    }

    public static class ViewHolderAboutUsContact extends RecyclerView.ViewHolder {

        final LinearLayout ll_web;
        final LinearLayout ll_call;
        final LinearLayout ll_email;
        final LinearLayout ll_facebook;
        final LinearLayout ll_instagram;
        final LinearLayout ll_telegram;

        final IDMyTextView tv_web;
        final IDMyTextView tv_call;
        final IDMyTextView tv_email;
        final IDMyTextView tv_facebook;
        final IDMyTextView tv_instagram;
        final IDMyTextView tv_telegram;

        public ViewHolderAboutUsContact(View v) {
            super(v);
            ll_web = (LinearLayout) v.findViewById(R.id.LinearLayout_list_aboutus_contact_web);
            ll_call = (LinearLayout) v.findViewById(R.id.LinearLayout_list_aboutus_contact_call);
            ll_email = (LinearLayout) v.findViewById(R.id.LinearLayout_list_aboutus_contact_email);
            ll_facebook = (LinearLayout) v.findViewById(R.id.LinearLayout_list_aboutus_contact_facebook);
            ll_instagram = (LinearLayout) v.findViewById(R.id.LinearLayout_list_aboutus_contact_instagram);
            ll_telegram = (LinearLayout) v.findViewById(R.id.LinearLayout_list_aboutus_contact_telegram);

            tv_web = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_contact_web);
            tv_call = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_contact_call);
            tv_email = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_contact_email);
            tv_facebook = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_contact_facebook);
            tv_instagram = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_contact_instagram);
            tv_telegram = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_contact_telegram);
        }
    }

    public static class ViewHolderAboutUsService extends RecyclerView.ViewHolder {

        public final ImageView iv_icon;
        public final IDMyTextView tv_title;
        public final IDMyTextView tv_description;
        public final IDMyButton bt_view;

        public ViewHolderAboutUsService(View v) {
            super(v);
            iv_icon = (ImageView) v.findViewById(R.id.ImageView_aboutus_service_icon);
            tv_title = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_service_title);
            tv_description = (IDMyTextView) v.findViewById(R.id.MyTextView_list_aboutus_service_desc);
            bt_view = (IDMyButton) v.findViewById(R.id.MyButton_list_aboutus_service);
        }
    }

    public static class ViewHolderAboutUsDivider extends RecyclerView.ViewHolder {

        public ViewHolderAboutUsDivider(View v) {
            super(v);
        }
    }
}