package io.idco.idcorp;

import android.app.Activity;
import android.os.AsyncTask;

import java.util.ArrayList;

import io.idco.idcorp.instances.AboutUsParentItem;
import io.idco.idcorp.instances.IDResultWebService;
import io.idco.idcorp.instances.IDUrlParameter;
import io.idco.idcorp.tools.IDInternetHelper;
import io.idco.idcorp.tools.IDSharedPreferencesHelper;


/**
 * Created by 1HE on 7/5/2016.
 */
@SuppressWarnings("ALL")
class AboutTask extends AsyncTask<Void, Void, IDResultWebService> {

    private final Activity activity;
    private final IAsyncTaskListener listener;

    public AboutTask(Activity activity, IAsyncTaskListener listener) {
        this.activity = activity;
        this.listener = listener;
    }

    @Override
    protected void onPreExecute() {
        if (listener != null)
            listener.onPreExecute();
    }

    @Override
    protected IDResultWebService doInBackground(Void... voids) {

        try {
            String url = "http://idco.io/about?id=" + IdCorp.id;
            IDResultWebService resultWebService = IDInternetHelper.getResultWithGet(url, new ArrayList<IDUrlParameter>());
            if (resultWebService.getCode() != IDResultWebService.CODE_SUCCESS)
                return resultWebService;
            String result = (String) resultWebService.getObject();

            IDResultWebService rw = AboutUsParentItem.getAboutList(activity, result);
            if (rw.getCode() == IDResultWebService.CODE_SUCCESS) {
                IDSharedPreferencesHelper.setString(activity, IDSharedPreferencesHelper.SETTING, AboutUsParentItem.SP_KEY, result);
            }

            return rw;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new IDResultWebService(IDResultWebService.CODE_FAIL, null);
    }

    @Override
    protected void onPostExecute(IDResultWebService i) {
        if (listener != null)
            listener.onPostExecute(i);
    }

}
