package io.idco.idcorp.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.GravityCompat;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.Gravity;

import io.idco.idcorp.R;
import io.idco.idcorp.tools.Font;
import io.idco.idcorp.tools.IDAttrHelper;
import io.idco.idcorp.tools.IDLanguageHelper;
import io.idco.idcorp.tools.IDStringHelper;


/**
 * Created by 1HE on 7/5/2016.
 */

@SuppressWarnings("ALL")
public class IDMyButton extends AppCompatButton {

    private String fontName = "";
    private boolean haveStar = false;
    private int textMode;

//	public MyTextView(Context context, AttributeSet attrs,int defStyleAttr,int defStyleRes) {
//		super(context, attrs, defStyleAttr, defStyleRes);
//        setAttributeFromXml(context, attrs);
//        initializeViews();
//	}

	public IDMyButton(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
        setAttributeFromXml(context, attrs);
        initializeViews();
	}

    public IDMyButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        setAttributeFromXml(context, attrs);
        initializeViews();
    }


    private void setAttributeFromXml(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs,
                R.styleable.IdCorp_TextView, 0, 0);

        try {
            fontName = a.getString(R.styleable.IdCorp_TextView_idcorp_font);
            haveStar = a.getBoolean(R.styleable.IdCorp_TextView_idcorp_haveStar, false);
            textMode = a.getInt(R.styleable.IdCorp_TextView_idcorp_textMode, IDAttrHelper.TEXTVIEW_TEXT_MODE_DEFAULT);
        } finally {
            a.recycle();
        }
    }

    private void initializeViews() {

        setTypeface(Font.getFont(getContext(), fontName));

        String result = IDStringHelper.getTextByMode(getText().toString(), textMode);
        if(haveStar)
            result = IDStringHelper.getStarredText(result);
        setText(result);
    }

    @SuppressLint("RtlHardcoded")
    @Override
    public void setGravity(int gravity) {
        if(!IDLanguageHelper.isRtl(getContext())){
            if(gravity / GravityCompat.START !=0) {
                int defG = gravity - GravityCompat.START;
                gravity = Gravity.LEFT | defG;
            }else  if(gravity / GravityCompat.END !=0){
                int defG = gravity - GravityCompat.END;
                gravity = Gravity.RIGHT | defG;
            }
        }

        super.setGravity(gravity);
    }
}
