package io.idco.idcorp.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;

import io.idco.idcorp.R;
import io.idco.idcorp.tools.IDDrawableHelper;


/**
 * Created by 1HE on 7/5/2016.
 */

@SuppressWarnings("ALL")
public class IDHEImageView extends AppCompatImageView {

    private int resVector;
    private int color;

//	public MyTextView(Context context, AttributeSet attrs,int defStyleAttr,int defStyleRes) {
//		super(context, attrs, defStyleAttr, defStyleRes);
//        setAttributeFromXml(context, attrs);
//        initializeViews();
//	}

	public IDHEImageView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
        setAttributeFromXml(context, attrs);
        initializeViews();
	}

    public IDHEImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        setAttributeFromXml(context, attrs);
        initializeViews();
    }


    private void setAttributeFromXml(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs,
                 R.styleable.IdCorp_HEImageView, 0, 0);

        try {
            resVector = a.getResourceId(R.styleable.IdCorp_HEImageView_idcorp_he_imageview_vector, 0);
            color = a.getColor(R.styleable.IdCorp_HEImageView_idcorp_he_imageview_color,0);
        } finally {
            a.recycle();
        }
    }

    private void initializeViews() {

        if(resVector == 0)
            return;

        setImageDrawable(IDDrawableHelper.changeColorDrawableVector(getContext(), resVector, color));
    }

    public void setVector(IDHEImageView.Item item){

        if(item == null) {
            setImageResource(android.R.color.transparent);
            return;
        }


        this.resVector = item.getResVector();
        this.color = item.getColor();

        setImageDrawable(IDDrawableHelper.changeColorDrawableVector(getContext(),resVector,color));
    }



    public static class Item{
        private int color;
        private int resVector;

        public Item(){

        }

        public int getColor() {
            return color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public int getResVector() {
            return resVector;
        }

        public void setResVector(int resVector) {
            this.resVector = resVector;
        }
    }
}
