package io.idco.idcorp.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.widget.ImageView;
import android.widget.LinearLayout;

import io.idco.idcorp.R;
import io.idco.idcorp.tools.Font;
import io.idco.idcorp.tools.IDAttrHelper;
import io.idco.idcorp.tools.IDDisplayHelper;
import io.idco.idcorp.tools.IDDrawableHelper;
import io.idco.idcorp.tools.IDLanguageHelper;


/**
 * Created by 1HE on 06/28/2016.
 */

@SuppressWarnings("ALL")
public class IDHEButton extends LinearLayout {

    private int image;
    private String text = "";
    private int textColor;
    private int mode;
    private boolean notVector;
    private String fontName = "";
    @SuppressWarnings("FieldCanBeLocal")
    private int textMode;

    private IDMyTextView tv;
    private ImageView iv;


//    public HEButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
//        super(context, attrs, defStyleAttr, defStyleRes);
//        setAttributeFromXml(context, attrs);
//        initializeViews();
//
//    }

    public IDHEButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        setAttributeFromXml(context, attrs);
        initializeViews();
    }

    public IDHEButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        setAttributeFromXml(context, attrs);
        initializeViews();
    }

    private void initializeViews() {

        setOrientation(HORIZONTAL);
        if(IDLanguageHelper.isRtl(getContext()))
            setLayoutDirection(LAYOUT_DIRECTION_LTR);

        LayoutInflater inflater = (LayoutInflater) getContext()
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        inflater.inflate(R.layout.icdorp_he_button, this);
    }


    private void setAttributeFromXml(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs,
                R.styleable.IdCorp_HEButton, 0, 0);

        try {
            image = a.getResourceId(R.styleable.IdCorp_HEButton_idcorp_he_button_image, 0);
            text = a.getString(R.styleable.IdCorp_HEButton_idcorp_he_button_text);
            textColor = a.getColor(R.styleable.IdCorp_HEButton_idcorp_he_button_textColor, 0);
            mode = a.getInt(R.styleable.IdCorp_HEButton_idcorp_he_button_mode, IDAttrHelper.HEBUTTON_MODE_NORMAL);
            notVector = a.getBoolean(R.styleable.IdCorp_HEButton_idcorp_he_button_notVector, false);
        } finally {
            a.recycle();
        }

        a = context.getTheme().obtainStyledAttributes(attrs,
                R.styleable.IdCorp_TextView, 0, 0);

        try {
            fontName = a.getString(R.styleable.IdCorp_TextView_idcorp_font);
            textMode = a.getInt(R.styleable.IdCorp_TextView_idcorp_textMode, IDAttrHelper.TEXTVIEW_TEXT_MODE_ALL);
        } finally {
            a.recycle();
        }
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();

        tv = (IDMyTextView) this.findViewById(R.id.MyTextView_he_button);
        iv = (ImageView) this.findViewById(R.id.ImageView_he_button);

        setAttrs();


    }

    private void setAttrs() {

        if (mode == IDAttrHelper.HEBUTTON_MODE_SMALL) {
            tv.setTextSize(TypedValue.COMPLEX_UNIT_SP, 13);
            LayoutParams params = (LayoutParams) iv.getLayoutParams();
//            params.width = IDDisplayHelper.i(12);
//            params.height = IDDisplayHelper.i(12);
            MarginLayoutParamsCompat.setMarginEnd(params, IDDisplayHelper.i(2));
            iv.invalidate();
        }else if(mode == IDAttrHelper.HEBUTTON_MODE_L_SMALL){
            tv.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 12);
        } else if (mode == IDAttrHelper.HEBUTTON_MODE_L_NORMAL) {
            tv.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
            LayoutParams params = (LayoutParams) iv.getLayoutParams();
            params.topMargin = IDDisplayHelper.i(4);
            params.gravity = Gravity.TOP;
            iv.invalidate();

            LayoutParams tvParams = (LayoutParams) tv.getLayoutParams();
            tvParams.topMargin = IDDisplayHelper.i(6);
            tv.invalidate();
        } else if (mode == IDAttrHelper.HEBUTTON_MODE_S_LARGE) {
            tv.setTextSize(TypedValue.COMPLEX_UNIT_SP, 16);
        }

        tv.setTypeface(Font.getFont(getContext(), fontName));
        tv.setTextColor(textColor);
        tv.setText(getConvertedText(text));

        setImage(image);

    }

    private String getConvertedText(String in) {

        return in;

    }

    public void setTextColor(int color) {
        this.textColor = color;
        tv.setTextColor(textColor);
    }

    public void setText(String text) {
        this.text = text;
        tv.setText(getConvertedText(text));
    }


    public void setImage(int image) {
        this.image = image;
        if (image == 0)
            return;

        if (notVector)
            iv.setImageDrawable(ContextCompat.getDrawable(getContext(),image));
        else
            iv.setImageDrawable(IDDrawableHelper.changeColorDrawableVector(getContext(), image, textColor));
    }

    public void setImage(Drawable image) {
        if (image == null)
            return;
        iv.setImageDrawable(image);
    }

    public void setItem(Item item) {
        setTextColor(item.getColor());
        setText(item.getText());
        setImage(item.getResVector());
        setImage(item.getImage());
        IDDrawableHelper.setBackgroundDrawable(this, ContextCompat.getDrawable(getContext(),item.getBackground()));
    }

    public String getText(){
        return text;
    }

    public boolean isNotVector() {
        return notVector;
    }

    public void setNotVector(boolean notVector) {
        this.notVector = notVector;
    }

    public static class Item {
        private int color;
        private int resVector;
        private String text;
        private Drawable image;
        private int background;

        public Item() {

        }

        public int getColor() {
            return color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public int getResVector() {
            return resVector;
        }

        public void setResVector(int resVector) {
            this.resVector = resVector;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Drawable getImage() {
            return image;
        }

        public void setImage(Drawable image) {
            this.image = image;
        }

        public int getBackground() {
            return background;
        }

        public void setBackground(int background) {
            this.background = background;
        }
    }

}
