package io.idco.idcorp.tools;


import java.net.URLEncoder;

/**
 * Created by 1HE on 7/5/2016.
 */
@SuppressWarnings("ALL")
public class IDStringHelper {

    public static String getTextByMode(String in, int mode) {
        switch (mode) {
            case IDAttrHelper.TEXTVIEW_TEXT_MODE_DEFAULT:
                return in;
            case IDAttrHelper.TEXTVIEW_TEXT_MODE_FIRST_ONLY:
                return getFirstMode(in);
            case IDAttrHelper.TEXTVIEW_TEXT_MODE_ALL:
                return getAllMode(in);
            case IDAttrHelper.TEXTVIEW_TEXT_MODE_FIRST_SPACE:
                return getFirstSpaceMode(in);

            default:
                return in;
        }
    }

    private static String getFirstMode(String in) {
        if (isEmpty(in))
            return in;

        char[] ch = in.toCharArray();
        ch[0] = Character.toUpperCase(ch[0]);
        return String.valueOf(ch);

    }

    private static String getAllMode(String in) {
        if (isEmpty(in))
            return in;

        char[] ch = in.toCharArray();
        for (int i = 0; i < ch.length; i++)
            ch[i] = Character.toUpperCase(ch[i]);
        return String.valueOf(ch);

    }

    private static String getFirstSpaceMode(String in) {
        if (isEmpty(in))
            return in;

        char[] ch = in.toCharArray();
        ch[0] = Character.toUpperCase(ch[0]);
        for (int i = 1; i < ch.length; i++) {
            if (i != ch.length - 1) {
                if (ch[i + 1] == ' ')
                    ch[i] = Character.toUpperCase(ch[i]);
            }
        }
        return String.valueOf(ch);

    }

    public static String getStarredText(String in){
        if(isEmpty(in))
            return in;

        return in+"*";
    }

    public static boolean isEmpty(String s) {
        //noinspection SimplifiableIfStatement
        if (s == null)
            return true;

        return s.equals("") || s.length() == 0 || s.equals("null");
    }

    public static String urlEncode(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        s = s.replace("&", "+");
        s = s.replace(" ", "%20");
        s = s.replace("=", "+");
        s = s.replace("@", "%40");

        try{
            return  URLEncoder.encode(s, "UTF-8");
        }catch (Exception e){
            return  s;
        }

    }

}
