package io.idco.idcorp.tools;

import android.util.Log;

import io.idco.idcorp.BuildConfig;


/**
 * Created by 1HE on 06/28/2016.
 */

@SuppressWarnings({"unused", "DefaultFileTemplate"})
public class IDLogHelper {

    private static final boolean allowLog = BuildConfig.DEBUG;

    private static final String MQTT = "he_mqtt";

    @SuppressWarnings("UnusedReturnValue")
    public static int d(String tag, String message) {
        if (allowLog)
            return Log.d(tag, message);
        return 0;
    }

    public static int d(String tag, String message, Throwable tr) {
        if (allowLog)
            return Log.d(tag, message, tr);
        return 0;
    }

    @SuppressWarnings({"UnusedReturnValue", "WeakerAccess"})
    public static int e(String tag, String message, Exception throwable) {
        if (allowLog)
            return Log.e(tag, message, throwable);
        return 0;
    }

    @SuppressWarnings({"WeakerAccess", "UnusedReturnValue"})
    public static int e(String tag, String message, Throwable throwable) {
        if (allowLog)
            return Log.e(tag, message, throwable);
        return 0;
    }

    @SuppressWarnings("UnusedReturnValue")
    public static int e(String tag, String message) {
        if (allowLog)
            return Log.e(tag, message);
        return 0;
    }

    public static int i(String tag, String message, Exception throwable) {
        if (allowLog)
            return Log.i(tag, message, throwable);
        return 0;
    }

    public static int i(String tag, String message, Throwable throwable) {
        if (allowLog)
            return Log.i(tag, message, throwable);
        return 0;
    }

    @SuppressWarnings("UnusedReturnValue")
    public static int i(String tag, String message) {
        if (allowLog)
            return Log.i(tag, message);
        return 0;
    }

    public static int w(String tag, String message) {
        if (allowLog)
            return Log.w(tag, message);
        return 0;
    }

    public static int w(String tag, String message, Throwable tr) {
        if (allowLog)
            return Log.w(tag, message, tr);
        return 0;
    }

    public static int v(String tag, String message) {
        if (allowLog)
            return Log.v(tag, message);
        return 0;
    }

    public static int v(String tag, String message, Throwable tr) {
        if (allowLog)
            return Log.v(tag, message, tr);
        return 0;
    }

    public static void mqtt(String tag, String message) {
        if (allowLog)
            d(MQTT + "_" + tag, message);
    }

    public static void mqtte(String tag, String message, Exception e) {
        if (allowLog)
            e(MQTT + "_" + tag, message, e);
    }

    public static void mqtte(String tag, String message, Throwable e) {
        if (allowLog)
            e(MQTT + "_" + tag, message, e);
    }
}
