package io.idco.idcorp.tools;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;

import java.lang.reflect.Method;

/**
 * Created by 1HE on 7/5/2016.
 */

@SuppressWarnings("ALL")
public class IDDisplayHelper {

    private static float dp;

    public static float f(float f){
        return f*dp;
    }
    public static float f(int i){
        return i*dp;
    }
    public static int i(int i){
        return (int)(i*dp);
    }
    public static int i(float f){
        return (int)(f*dp);
    }

    public static void create(Context context){
        dp = context.getResources().getDisplayMetrics().density;
    }

    public static int getStatusBarHeight(Context c) {
        int result = 0;
        int resourceId = c.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = c.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static  int getActionBarHeight(Context c){
        TypedValue tv = new TypedValue();
        if (c.getTheme().resolveAttribute(android.R.attr.actionBarSize, tv, true))
        {
            return TypedValue.complexToDimensionPixelSize(tv.data,c.getResources().getDisplayMetrics());
        }
        return 0;
    }

    @SuppressLint("ObsoleteSdkInt")
    @SuppressWarnings("deprecation")
    public static Point getDisplaySize(Context c) {
        WindowManager wm = (WindowManager) c.getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();
        Point p = new Point();

        if (Build.VERSION.SDK_INT >= 17) {
            //new pleasant way to get real metrics
            DisplayMetrics realMetrics = new DisplayMetrics();
            display.getRealMetrics(realMetrics);
            p.x = realMetrics.widthPixels;
            p.y = realMetrics.heightPixels;


        } else {
            //reflection for this weird in-between time
            if (Build.VERSION.SDK_INT >= 14) {
                try {
                    Method mGetRawH = Display.class.getMethod("getRawHeight");
                    Method mGetRawW = Display.class.getMethod("getRawWidth");
                    p.x = (Integer) mGetRawW.invoke(display);
                    p.y = (Integer) mGetRawH.invoke(display);
                } catch (Exception e) {
                    //this may not be 100% accurate, but it's all we've got
                    p.x = display.getWidth();
                    p.y = display.getHeight();
                    Log.e("Display Info",
                            "Couldn't use reflection to get the real display metrics.");
                }
            } else {
                //This should be close, as lower API devices should not have window navigation bars
                p.x = display.getWidth();
                p.y = display.getHeight();
            }
        }

        return p;
    }

}
