package io.idco.idcorp.instances;

import android.content.Context;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import io.idco.idcorp.R;
import io.idco.idcorp.tools.IDJsonHelper;

/**
 * Created by 1HE on 7/5/2016.
 */
@SuppressWarnings("ALL")
public class AboutUsParentItem {

    public static final String SP_KEY = "about_value";
    public static final String DEFAULT_VALUE = "{\n" +
            "  \"description\": \"شرکت طراحی بدون مرز با ادغام سه شرکت دیگر به نام\u200Cهای گروه برنامه\u200Cنویسی ریگار و شرکت آزمایشگاه\u200Cهای کد و شرکت داده گستر همراه که هر کدام بیش از سه سال سابقه\u200Cی فعالیت داشتند در بهمن ماه ۱۳۹۳ تاسیس گشت. فعالیت این شرکت شامل طیف وسیعی از خدمات از جمله برنامه\u200Cنویسی تحت وب، ارائه\u200Cی هاستینگ، طراحی سرور، مدیریت سرور و همچنین طراحی و اجرای نرم\u200Cافزارهای اندرویدی می\u200Cباشد.\",\n" +
            "  \"contact\": {\n" +
            "    \"web\": \"http://idco.io/\",\n" +
            "    \"call\": \"03132641428\",\n" +
            "    \"email\": \"info@idco.io\",\n" +
            "    \"fb_id\": \"400893250020006\",\n" +
            "    \"fb_name\": \"InfinityDesignLike\",\n" +
            "    \"instagram\": \"infisign\",\n" +
            "    \"telegram\": \"idco_io\"\n" +
            "  },\n" +
            "  \"services\": [\n" +
            "  ]\n" +
            "}";

    public static final int TYPE_HEADER = 1;
    public static final int TYPE_DESCRIPTION = 2;
    public static final int TYPE_SERVICE = 3;
    public static final int TYPE_CONTACT = 4;
    public static final int TYPE_DIVIDER = 5;

    private static final String OBJ_description = "description";
    private static final String OBJ_contact = "contact";
    private static final String OBJ_web = "web";
    private static final String OBJ_call = "call";
    private static final String OBJ_email = "email";
    private static final String OBJ_fb_id = "fb_id";
    private static final String OBJ_fb_name = "fb_name";
    private static final String OBJ_instagram = "instagram";
    private static final String OBJ_telegram = "telegram";
    private static final String OBJ_services = "services";
    private static final String OBJ_image = "image";
    private static final String OBJ_title = "title";
    private static final String OBJ_desc = "desc";
    private static final String OBJ_url = "url";

    private int type;

    public int getType() {
        return type;
    }

    void setType(int type) {
        this.type = type;
    }


    public static IDResultWebService getAboutList(Context context, String json) {
        try {
            List<AboutUsParentItem> list = new ArrayList<>();
            JSONObject root = new JSONObject(json);
            JSONObject contact = root.getJSONObject(OBJ_contact);
            JSONArray services = root.getJSONArray(OBJ_services);
//            list.add(new AboutUsHeaderItem(context.getString(R.string.idcorp_about_header)));
//
//            AboutUsDescriptionItem desc = new AboutUsDescriptionItem();
//            desc.setText(IDJsonHelper.getStringByObj(root, OBJ_description));
//            list.add(desc);

            AboutUsContactItem contactItem = new AboutUsContactItem();
            contactItem.setCall(IDJsonHelper.getStringByObj(contact, OBJ_call));
            contactItem.setWeb(IDJsonHelper.getStringByObj(contact, OBJ_web));
            contactItem.setEmail(IDJsonHelper.getStringByObj(contact, OBJ_email));
            contactItem.setFacebookPageId(IDJsonHelper.getStringByObj(contact, OBJ_fb_id));
            contactItem.setFacebookPageName(IDJsonHelper.getStringByObj(contact, OBJ_fb_name));
            contactItem.setInstagram(IDJsonHelper.getStringByObj(contact, OBJ_instagram));
            contactItem.setTelegram(IDJsonHelper.getStringByObj(contact, OBJ_telegram));
            list.add(contactItem);
            if (services.length() > 0) {
                list.add(new AboutUsHeaderItem(context.getString(R.string.idcorp_about_headerOtherService)));
                for (int i = 0; i < services.length(); i++) {
                    JSONObject object = services.getJSONObject(i);
                    AboutUsServiceItem serviceItem = new AboutUsServiceItem();
                    serviceItem.setImageUrl(IDJsonHelper.getStringByObj(object, OBJ_image));
                    serviceItem.setTitle(IDJsonHelper.getStringByObj(object, OBJ_title));
                    serviceItem.setDescription(IDJsonHelper.getStringByObj(object, OBJ_desc));
                    serviceItem.setUrl(IDJsonHelper.getStringByObj(object, OBJ_url));
                    list.add(serviceItem);
                    if (i != services.length() - 1)
                        list.add(new AboutUsDividerItem());
                }

            }

//            AboutUsServiceItem serviceItem = new AboutUsServiceItem();
//            serviceItem.setImageUrl("http://mesghal.online/backend/images/logo_user");
//            serviceItem.setTitle("مثقال");
//            serviceItem.setDescription("نرم افزار ارز و سکه و طلا");
//            serviceItem.setUrl("http://google.com");
//            list.add(serviceItem);

            return new IDResultWebService(IDResultWebService.CODE_SUCCESS,list);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return new IDResultWebService(IDResultWebService.CODE_FAIL,null);
    }

}
