package io.idco.idcorp;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import java.util.ArrayList;
import java.util.List;

import io.idco.idcorp.instances.AboutUsParentItem;
import io.idco.idcorp.instances.IDResultWebService;
import io.idco.idcorp.tools.IDDisplayHelper;
import io.idco.idcorp.tools.IDDrawableHelper;
import io.idco.idcorp.tools.IDInternetHelper;
import io.idco.idcorp.tools.IDLanguageHelper;
import io.idco.idcorp.tools.IDSharedPreferencesHelper;
import io.idco.idcorp.tools.IDViewHelper;
import io.idco.idcorp.views.IDMyTextView;

/**
 * Created by 1HE on 7/5/2016.
 */
@SuppressWarnings("ALL")
public class IdCorpActivity extends AppCompatActivity implements IAsyncTaskListener {

    private View v_color;
    private ImageView iv1;
    private ImageView iv2;
    private IDMyTextView tv_designedBy;
    private RelativeLayout rl_logo;
    private RecyclerView rv;
    private List<AboutUsParentItem> list;
    private AboutUsAdapter adapter;

    private static final int MARGIN_TOP = 16;
    private boolean isPlayingAnimation;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IDDisplayHelper.create(this);
        IDLanguageHelper.checkAndChangeUi(this);
        setContentView(R.layout.activity_icdorp);

        v_color = findViewById(R.id.View_aboutus_color);
        iv1  = (ImageView) findViewById(R.id.ImageView_aboutus_logo1);
        iv2  = (ImageView) findViewById(R.id.ImageView_aboutus_logo2);
        tv_designedBy = (IDMyTextView) findViewById(R.id.MyTextView_aboutus_designedBy);
        rl_logo = (RelativeLayout) findViewById(R.id.RelativeLayout_aboutus_logo);
        rv = (RecyclerView) findViewById(R.id.RecyclerView_aboutus);


        if(Build.VERSION.SDK_INT >= 21) {
            isPlayingAnimation = true;
            IDViewHelper.addOnGlobalLayout(iv1, new IDViewHelper.IGlobalLayoutListener() {
                @Override
                public void onAdded() {
                    startAnim();
                }
            });
        }else{
            IDViewHelper.addOnGlobalLayout(iv1, new IDViewHelper.IGlobalLayoutListener() {
                @Override
                public void onAdded() {
                    iv1.setImageDrawable(IDDrawableHelper.changeColorDrawableVector(IdCorpActivity.this,R.drawable.icdorp_ic_id_all,-2));
                    animateLogoParent();
                    iv1.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            animateInfiniteScaleLogo();
                        }
                    },800);
                    setupRecyclerViewAndFill();
                }
            });
        }


    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private void startAnim() {
//        final Point p = IDDisplayHelper.getDisplaySize(IdCorpActivity.this);
        tv_designedBy.setVisibility(View.INVISIBLE);
        Animator animator = ViewAnimationUtils.createCircularReveal(v_color, v_color.getWidth() / 2, v_color.getHeight() / 2, 0, Math.min(v_color.getWidth(), v_color.getHeight()));
        animator.setInterpolator(new FastOutSlowInInterpolator());
        animator.setDuration(1500);
        animator.start();

        iv1.postDelayed(new Runnable() {
            @Override
            public void run() {
                iv1.setImageDrawable(IDDrawableHelper.changeColorDrawableVector(IdCorpActivity.this,R.drawable.icdorp_ic_id_soft,-2));
                iv2.setImageDrawable(IDDrawableHelper.changeColorDrawableVector(IdCorpActivity.this,R.drawable.icdorp_ic_id_curve,-2));

                ObjectAnimator rotation = ObjectAnimator.ofFloat(iv1,"rotation",360);
                rotation.setDuration(500);
//        rotation.setStartDelay(1000);
                rotation.setInterpolator(new FastOutLinearInInterpolator());
                rotation.addListener(new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animator) {
                        iv2.setVisibility(View.INVISIBLE);
                    }

                    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
                    @Override
                    public void onAnimationEnd(Animator animator) {
                        iv1.setRotation(0f);
                        iv2.setVisibility(View.VISIBLE);
                        iv2.setPivotX(iv2.getWidth()/2);
                        iv2.setPivotY(iv2.getHeight()/2);
                        iv2.setScaleX(0f);
                        iv2.setScaleY(0f);
                        tv_designedBy.setVisibility(View.VISIBLE);
                        final ObjectAnimator xAnimator = ObjectAnimator.ofFloat(iv2,"scaleX",1f);
                        final ObjectAnimator yAnimator = ObjectAnimator.ofFloat(iv2,"scaleY",1f);
                        final AnimatorSet set = new AnimatorSet();
                        set.playTogether(xAnimator,yAnimator);
                        set.setDuration(getResources().getInteger(R.integer.idcorp_animationDuration));
                        set.setInterpolator(new FastOutSlowInInterpolator());
                        set.addListener(new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(Animator animator) {

                            }

                            @Override
                            public void onAnimationEnd(Animator animator) {
                                iv1.setImageResource(R.drawable.icdorp_ic_id_all);
                                animateInfiniteScaleLogo();

                            }

                            @Override
                            public void onAnimationCancel(Animator animator) {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animator) {

                            }
                        });
                        set.start();

                        AnimatedVectorDrawable a = (AnimatedVectorDrawable) getDrawable(R.drawable.icdorp_animated_vector);
                        iv1.setImageDrawable(a);
                        if(a != null)
                        a.start();

                        Animator textAnim = ViewAnimationUtils.createCircularReveal(tv_designedBy, tv_designedBy.getWidth() / 2, tv_designedBy.getHeight() / 2, 0, Math.max(tv_designedBy.getWidth(), tv_designedBy.getHeight()));
                        textAnim.setInterpolator(new FastOutSlowInInterpolator());
                        textAnim.setDuration(1500);
                        textAnim.addListener(new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(Animator animator) {

                            }

                            @Override
                            public void onAnimationEnd(Animator animator) {
                                isPlayingAnimation = false;
                            }

                            @Override
                            public void onAnimationCancel(Animator animator) {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animator) {

                            }
                        });
                        textAnim.start();

                        tv_designedBy.setAlpha(0.5f);
                        ObjectAnimator textAlphaAnimator = ObjectAnimator.ofFloat(tv_designedBy,"alpha",1f);
                        textAlphaAnimator.setDuration(1500);
                        textAlphaAnimator.setInterpolator(new FastOutLinearInInterpolator());
                        textAlphaAnimator.start();

                        animateLogoParent();

                        setupRecyclerViewAndFill();
                    }

                    @Override
                    public void onAnimationCancel(Animator animator) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animator) {

                    }
                });
                rotation.start();
            }
        },200);
    }

    private void animateLogoParent(){

        ObjectAnimator translate = ObjectAnimator.ofFloat(rl_logo,"y", IDDisplayHelper.i(MARGIN_TOP));
        translate.setDuration(350);
        translate.setInterpolator(new FastOutLinearInInterpolator());
        translate.start();
    }

    private void animateInfiniteScaleLogo(){
        iv2.setVisibility(View.INVISIBLE);
        iv1.setPivotX(iv1.getWidth()/2);
        iv1.setPivotY(iv1.getHeight()/2);
        ObjectAnimator scaleX = ObjectAnimator.ofFloat(iv1,"scaleX",1f,0.9f);
        scaleX.setRepeatCount(ValueAnimator.INFINITE);
        scaleX.setRepeatMode(ValueAnimator.REVERSE);
        ObjectAnimator scaleY = ObjectAnimator.ofFloat(iv1,"scaleY",1f,0.9f);
        scaleY.setRepeatCount(ValueAnimator.INFINITE);
        scaleY.setRepeatMode(ValueAnimator.REVERSE);
        AnimatorSet scaleSet = new AnimatorSet();
        scaleSet.setInterpolator(new FastOutLinearInInterpolator());
        scaleSet.setDuration(500);
        scaleSet.playTogether(scaleX,scaleY);
        scaleSet.start();
    }

    @SuppressWarnings("unchecked")
    private void setupRecyclerViewAndFill(){
        list = new ArrayList<>();
        FrameLayout.LayoutParams rvParams = (FrameLayout.LayoutParams) rv.getLayoutParams();
        int extraMargin = Build.VERSION.SDK_INT >= 21 ? 0 : IDDisplayHelper.getStatusBarHeight(this) + IDDisplayHelper.i(36);
        rvParams.topMargin = IDDisplayHelper.i(MARGIN_TOP) + rl_logo.getHeight() + IDDisplayHelper.i(16) + extraMargin;
        rv.invalidate();
        rv.setHasFixedSize(true);
        rv.setLayoutManager(new LinearLayoutManager(this));
        rv.addItemDecoration(new AboutUsDecoration(list));
        adapter = new AboutUsAdapter(this,list, (LinearLayoutManager) rv.getLayoutManager());
        rv.setAdapter(adapter);


        IDResultWebService local = AboutUsParentItem.getAboutList(this, IDSharedPreferencesHelper.getString(this, IDSharedPreferencesHelper.SETTING,AboutUsParentItem.SP_KEY,AboutUsParentItem.DEFAULT_VALUE));
        if(local.getCode() == IDResultWebService.CODE_SUCCESS)
            fillData((List<AboutUsParentItem>) local.getObject());

        if(IDInternetHelper.isOnline(this))
            new AboutTask(this,this).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private void fillData(List<AboutUsParentItem> items){
        list.clear();
        for(int i=0;i<items.size();i++)
            list.add(items.get(i));

        adapter.notifyDataSetChanged();
    }

    private void back() {
        if(isPlayingAnimation)
            return;
        finish();
    }

    @Override
    public void onBackPressed() {
        back();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();

        if (id == android.R.id.home) {
            back();
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onPostExecute(IDResultWebService result) {
        if(result.getCode() == IDResultWebService.CODE_SUCCESS){
            //noinspection unchecked
            fillData((List<AboutUsParentItem>) result.getObject());
        }
    }

    @Override
    public void onPreExecute() {

    }
}
