/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj.jsonrpc;

import io.iconator.testrpcj.jsonrpc.TypeConverter;
import org.ethereum.core.Block;
import org.ethereum.core.Transaction;

public class TransactionResultDTO {
    public String hash;
    public String nonce;
    public String blockHash;
    public String blockNumber;
    public String transactionIndex;
    public String from;
    public String to;
    public String gas;
    public String gasPrice;
    public String value;
    public String input;

    public TransactionResultDTO(Block b, int index, Transaction tx) {
        this.hash = TypeConverter.toJsonHex(tx.getHash());
        this.nonce = TypeConverter.toJsonHex(tx.getNonce());
        this.blockHash = TypeConverter.toJsonHex(b.getHash());
        this.blockNumber = TypeConverter.toJsonHex(b.getNumber());
        this.transactionIndex = TypeConverter.toJsonHex(index);
        this.from = TypeConverter.toJsonHexAddress(tx.getSender());
        this.to = TypeConverter.toJsonHexAddress(tx.getReceiveAddress());
        this.gas = TypeConverter.toJsonHex(tx.getGasLimit());
        this.gasPrice = TypeConverter.toJsonHex(tx.getGasPrice());
        this.value = TypeConverter.toJsonHexNumber(tx.getValue());
        this.input = tx.getData() != null ? TypeConverter.toJsonHex(tx.getData()) : null;
    }

    public String getHash() {
        return this.hash;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return this.gas;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public String getValue() {
        return this.value;
    }

    public String getInput() {
        return this.input;
    }
}

