/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj.jsonrpc;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.iconator.testrpcj.jsonrpc.JsonRpc;
import io.iconator.testrpcj.jsonrpc.LocalTransaction;
import io.iconator.testrpcj.jsonrpc.TransactionReceiptDTO;
import io.iconator.testrpcj.jsonrpc.TransactionReceiptDTOExt;
import io.iconator.testrpcj.jsonrpc.TransactionResultDTO;
import io.iconator.testrpcj.jsonrpc.TypeConverter;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.LRUMap;
import org.ethereum.config.CommonConfig;
import org.ethereum.core.Block;
import org.ethereum.core.BlockHeader;
import org.ethereum.core.BlockchainImpl;
import org.ethereum.core.Bloom;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.PendingState;
import org.ethereum.core.Repository;
import org.ethereum.core.Transaction;
import org.ethereum.core.TransactionExecutor;
import org.ethereum.core.TransactionInfo;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.crypto.ECKey;
import org.ethereum.crypto.HashUtil;
import org.ethereum.db.BlockStore;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.listener.EthereumListener;
import org.ethereum.listener.EthereumListenerAdapter;
import org.ethereum.listener.LogFilter;
import org.ethereum.mine.MinerIfc;
import org.ethereum.mine.MinerListener;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.BuildInfo;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.blockchain.StandaloneBlockchain;
import org.ethereum.vm.DataWord;
import org.ethereum.vm.LogInfo;
import org.ethereum.vm.program.invoke.ProgramInvokeFactory;
import org.ethereum.vm.program.invoke.ProgramInvokeFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.springframework.stereotype.Service;

@Service
public class EthJsonRpcImpl
implements JsonRpc {
    private static final Logger log = LoggerFactory.getLogger(EthJsonRpcImpl.class);
    private static final String BLOCK_LATEST = "latest";
    private volatile String hashrate;
    private final StandaloneBlockchain standaloneBlockchain;
    private final BlockchainImpl blockchain;
    private final PendingState pendingState;
    private final BlockStore blockStore;
    private final ProgramInvokeFactory programInvokeFactory = new ProgramInvokeFactoryImpl();
    private final CommonConfig commonConfig = CommonConfig.getDefault();
    protected volatile long initialBlockNumber;
    private final Map<String, ECKey> accounts = new ConcurrentHashMap<String, ECKey>();
    AtomicInteger filterCounter = new AtomicInteger(1);
    Map<Integer, Filter> installedFilters = new Hashtable<Integer, Filter>();
    Map<ByteArrayWrapper, TransactionReceipt> pendingReceipts = Collections.synchronizedMap(new LRUMap(1024));
    Map<ByteArrayWrapper, Block> miningBlocks = new ConcurrentHashMap<ByteArrayWrapper, Block>();
    volatile Block miningBlock;
    volatile SettableFuture<MinerIfc.MiningResult> miningTask;
    final MinerIfc externalMiner = new MinerIfc(){

        public ListenableFuture<MinerIfc.MiningResult> mine(Block block) {
            EthJsonRpcImpl.this.miningBlock = block;
            EthJsonRpcImpl.this.miningTask = SettableFuture.create();
            return EthJsonRpcImpl.this.miningTask;
        }

        public void setListeners(Collection<MinerListener> var1) {
        }

        public boolean validate(BlockHeader blockHeader) {
            return false;
        }
    };
    boolean minerInitialized = false;

    public void addAccount(String address, ECKey pair) {
        this.accounts.put(address, pair);
    }

    public EthJsonRpcImpl(StandaloneBlockchain standaloneBlockchain) {
        this.standaloneBlockchain = standaloneBlockchain;
        this.blockchain = standaloneBlockchain.getBlockchain();
        this.pendingState = standaloneBlockchain.getPendingState();
        this.blockStore = standaloneBlockchain.getBlockchain().getBlockStore();
        this.init();
    }

    private void init() {
        this.initialBlockNumber = this.blockchain.getBestBlock().getNumber();
        this.standaloneBlockchain.addEthereumListener((EthereumListener)new EthereumListenerAdapter(){

            public void onBlock(Block block, List<TransactionReceipt> receipts) {
                for (Filter filter : EthJsonRpcImpl.this.installedFilters.values()) {
                    filter.newBlockReceived(block);
                }
            }

            public void onPendingTransactionsReceived(List<Transaction> transactions) {
                for (Filter filter : EthJsonRpcImpl.this.installedFilters.values()) {
                    for (Transaction tx : transactions) {
                        filter.newPendingTx(tx);
                    }
                }
            }

            public void onPendingTransactionUpdate(TransactionReceipt txReceipt, EthereumListener.PendingTransactionState state, Block block) {
                ByteArrayWrapper txHashW = new ByteArrayWrapper(txReceipt.getTransaction().getHash());
                if (state.isPending() || state == EthereumListener.PendingTransactionState.DROPPED) {
                    EthJsonRpcImpl.this.pendingReceipts.put(txHashW, txReceipt);
                } else {
                    EthJsonRpcImpl.this.pendingReceipts.remove(txHashW);
                }
            }
        });
    }

    private long JSonHexToLong(String x) throws Exception {
        if (!x.startsWith("0x")) {
            throw new Exception("Incorrect hex syntax");
        }
        x = x.substring(2);
        return Long.parseLong(x, 16);
    }

    private int JSonHexToInt(String x) throws Exception {
        if (!x.startsWith("0x")) {
            throw new Exception("Incorrect hex syntax");
        }
        x = x.substring(2);
        return Integer.parseInt(x, 16);
    }

    private String JSonHexToHex(String x) {
        if (!x.startsWith("0x")) {
            throw new RuntimeException("Incorrect hex syntax");
        }
        x = x.substring(2);
        return x;
    }

    private Block getBlockByJSonHash(String blockHash) throws Exception {
        byte[] bhash = TypeConverter.StringHexToByteArray(blockHash);
        return this.blockchain.getBlockByHash(bhash);
    }

    private Block getByJsonBlockId(String id) {
        if ("earliest".equalsIgnoreCase(id)) {
            return this.blockchain.getBlockByNumber(0L);
        }
        if (BLOCK_LATEST.equalsIgnoreCase(id)) {
            return this.blockchain.getBestBlock();
        }
        if ("pending".equalsIgnoreCase(id)) {
            return null;
        }
        long blockNumber = TypeConverter.StringHexToBigInteger(id).longValue();
        return this.blockchain.getBlockByNumber(blockNumber);
    }

    private Repository getRepoByJsonBlockId(String id) {
        if ("pending".equalsIgnoreCase(id)) {
            return this.pendingState.getRepository();
        }
        Block block = this.getByJsonBlockId(id);
        return this.blockchain.getRepository().getSnapshotTo(block.getStateRoot());
    }

    private List<Transaction> getTransactionsByJsonBlockId(String id) {
        if ("pending".equalsIgnoreCase(id)) {
            return this.pendingState.getPendingTransactions();
        }
        Block block = this.getByJsonBlockId(id);
        return block != null ? block.getTransactionsList() : null;
    }

    @Override
    public String web3_clientVersion() {
        Pattern shortVersion = Pattern.compile("(\\d\\.\\d).*");
        Matcher matcher = shortVersion.matcher(System.getProperty("java.version"));
        matcher.matches();
        return Arrays.asList("TestRPC-J/Harmony", "v1", System.getProperty("os.name"), "Java" + matcher.group(1), "-" + BuildInfo.buildHash).stream().collect(Collectors.joining("/"));
    }

    @Override
    public String web3_sha3(String data) throws Exception {
        byte[] result = HashUtil.sha3((byte[])data.getBytes());
        return TypeConverter.toJsonHex(result);
    }

    @Override
    public String eth_protocolVersion() {
        return "not sure what to put here...";
    }

    @Override
    public Object eth_syncing() {
        JsonRpc.SyncingResult sr = new JsonRpc.SyncingResult();
        sr.startingBlock = TypeConverter.toJsonHex(this.initialBlockNumber);
        sr.currentBlock = TypeConverter.toJsonHex(this.blockchain.getBestBlock().getNumber());
        sr.highestBlock = TypeConverter.toJsonHex(this.blockchain.getBestBlock().getNumber());
        return sr;
    }

    @Override
    public String eth_coinbase() {
        return TypeConverter.toJsonHex(this.blockchain.getMinerCoinbase());
    }

    @Override
    public boolean eth_mining() {
        return false;
    }

    @Override
    public String eth_hashrate() {
        return this.hashrate;
    }

    @Override
    public String eth_gasPrice() {
        return TypeConverter.toJsonHex(50000000000L);
    }

    @Override
    public String[] eth_accounts() {
        return this.accounts.keySet().toArray(new String[10]);
    }

    @Override
    public String eth_blockNumber() {
        return TypeConverter.toJsonHex(this.blockchain.getBestBlock().getNumber());
    }

    @Override
    public String eth_getBalance(String address, String blockId) throws Exception {
        Objects.requireNonNull(address, "address is required");
        blockId = blockId == null ? BLOCK_LATEST : blockId;
        byte[] addressAsByteArray = TypeConverter.StringHexToByteArray(address);
        BigInteger balance = this.getRepoByJsonBlockId(blockId).getBalance(addressAsByteArray);
        return TypeConverter.toJsonHex(balance);
    }

    @Override
    public String eth_getLastBalance(String address) throws Exception {
        return this.eth_getBalance(address, BLOCK_LATEST);
    }

    @Override
    public String eth_getStorageAt(String address, String storageIdx, String blockId) throws Exception {
        byte[] addressAsByteArray = TypeConverter.StringHexToByteArray(address);
        DataWord storageValue = this.getRepoByJsonBlockId(blockId).getStorageValue(addressAsByteArray, new DataWord(TypeConverter.StringHexToByteArray(storageIdx)));
        return storageValue != null ? TypeConverter.toJsonHex(storageValue.getData()) : null;
    }

    @Override
    public String eth_getTransactionCount(String address, String blockId) throws Exception {
        byte[] addressAsByteArray = TypeConverter.StringHexToByteArray(address);
        BigInteger nonce = this.getRepoByJsonBlockId(blockId).getNonce(addressAsByteArray);
        return TypeConverter.toJsonHex(nonce);
    }

    @Override
    public String eth_getBlockTransactionCountByHash(String blockHash) throws Exception {
        Block b = this.getBlockByJSonHash(blockHash);
        if (b == null) {
            return null;
        }
        long n = b.getTransactionsList().size();
        return TypeConverter.toJsonHex(n);
    }

    @Override
    public String eth_getBlockTransactionCountByNumber(String bnOrId) throws Exception {
        List<Transaction> list = this.getTransactionsByJsonBlockId(bnOrId);
        if (list == null) {
            return null;
        }
        long n = list.size();
        return TypeConverter.toJsonHex(n);
    }

    @Override
    public String eth_getUncleCountByBlockHash(String blockHash) throws Exception {
        Block b = this.getBlockByJSonHash(blockHash);
        if (b == null) {
            return null;
        }
        long n = b.getUncleList().size();
        return TypeConverter.toJsonHex(n);
    }

    @Override
    public String eth_getUncleCountByBlockNumber(String bnOrId) throws Exception {
        Block b = this.getByJsonBlockId(bnOrId);
        if (b == null) {
            return null;
        }
        long n = b.getUncleList().size();
        return TypeConverter.toJsonHex(n);
    }

    @Override
    public String eth_getCode(String address, String blockId) throws Exception {
        byte[] addressAsByteArray = TypeConverter.StringHexToByteArray(address);
        byte[] code = this.getRepoByJsonBlockId(blockId).getCode(addressAsByteArray);
        return TypeConverter.toJsonHex(code);
    }

    @Override
    public String eth_sign(String address, String messageHash) throws Exception {
        String ha = this.JSonHexToHex(address);
        ECKey key = this.accounts.get(ha);
        ECKey.ECDSASignature signature = key.sign(Hex.decode((String)this.JSonHexToHex(messageHash)));
        byte[] signatureBytes = this.toByteArray(signature);
        return TypeConverter.toJsonHex(signatureBytes);
    }

    private byte[] toByteArray(ECKey.ECDSASignature signature) {
        byte fixedV = signature.v >= 27 ? (byte)(signature.v - 27) : signature.v;
        return ByteUtil.merge((byte[][])new byte[][]{ByteUtil.bigIntegerToBytes((BigInteger)signature.r), ByteUtil.bigIntegerToBytes((BigInteger)signature.s), {fixedV}});
    }

    @Override
    public String eth_sendTransaction(JsonRpc.CallArguments args) throws Exception {
        String ha = this.JSonHexToHex(args.from);
        ECKey key = this.accounts.get(ha);
        return this.sendTransaction(args, key);
    }

    private String sendTransaction(JsonRpc.CallArguments args, ECKey account) {
        if (args.data != null && args.data.startsWith("0x")) {
            args.data = args.data.substring(2);
        }
        BigInteger valueBigInt = args.value != null ? TypeConverter.StringHexToBigInteger(args.value) : BigInteger.ZERO;
        byte[] value = !valueBigInt.equals(BigInteger.ZERO) ? ByteUtil.bigIntegerToBytes((BigInteger)valueBigInt) : ByteUtil.EMPTY_BYTE_ARRAY;
        Transaction tx = new Transaction(args.nonce != null ? TypeConverter.StringHexToByteArray(args.nonce) : ByteUtil.bigIntegerToBytes((BigInteger)this.pendingState.getRepository().getNonce(account.getAddress())), args.gasPrice != null ? TypeConverter.StringHexToByteArray(args.gasPrice) : ByteUtil.longToBytesNoLeadZeroes((long)50000000000L), args.gas != null ? TypeConverter.StringHexToByteArray(args.gas) : ByteUtil.longToBytes((long)90000L), args.to != null ? TypeConverter.StringHexToByteArray(args.to) : ByteUtil.EMPTY_BYTE_ARRAY, value, args.data != null ? TypeConverter.StringHexToByteArray(args.data) : ByteUtil.EMPTY_BYTE_ARRAY);
        tx.sign(account);
        this.validateAndSubmit(tx);
        return TypeConverter.toJsonHex(tx.getHash());
    }

    @Override
    public String eth_sendTransactionArgs(String from, String to, String gas, String gasPrice, String value, String data, String nonce) throws Exception {
        String ha = this.JSonHexToHex(from);
        ECKey key = this.accounts.get(ha);
        JsonRpc.CallArguments ca = new JsonRpc.CallArguments();
        ca.from = from;
        ca.to = to;
        ca.gas = gas;
        ca.gasPrice = gasPrice;
        ca.value = value;
        ca.data = data;
        ca.nonce = nonce;
        return this.sendTransaction(ca, key);
    }

    @Override
    public String eth_sendRawTransaction(String rawData) throws Exception {
        Transaction tx = new Transaction(TypeConverter.StringHexToByteArray(rawData));
        tx.rlpParse();
        this.validateAndSubmit(tx);
        return TypeConverter.toJsonHex(tx.getHash());
    }

    protected void validateAndSubmit(Transaction tx) {
        if (tx.getValue().length > 0 && tx.getValue()[0] == 0) {
            byte[] txRaw = tx.getValue();
            log.warn("Transaction might use incorrect zero value: " + txRaw);
        }
        this.standaloneBlockchain.submitTransaction(tx);
    }

    protected TransactionReceipt createCallTxAndExecute(JsonRpc.CallArguments args, Block block) throws Exception {
        Repository repository = this.blockchain.getRepository().getSnapshotTo(block.getStateRoot()).startTracking();
        return this.createCallTxAndExecute(args, block, repository, this.blockchain.getBlockStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionReceipt createCallTxAndExecute(JsonRpc.CallArguments args, Block block, Repository repository, BlockStore blockStore) throws Exception {
        BinaryCallArguments bca = new BinaryCallArguments();
        bca.setArguments(args);
        Transaction rawTransaction = CallTransaction.createRawTransaction((long)0L, (long)bca.gasPrice, (long)bca.gasLimit, (String)bca.toAddress, (long)bca.value, (byte[])bca.data);
        LocalTransaction tx = new LocalTransaction(rawTransaction.getEncoded());
        if (args.from != null) {
            tx.setSender(ByteUtil.hexStringToBytes((String)args.from));
        } else {
            tx.sign(ECKey.fromPrivate((byte[])new byte[32]));
        }
        try {
            TransactionExecutor executor = new TransactionExecutor((Transaction)tx, block.getCoinbase(), repository, blockStore, this.programInvokeFactory, block, (EthereumListener)new EthereumListenerAdapter(), 0L).withCommonConfig(this.commonConfig).setLocalCall(true);
            executor.init();
            executor.execute();
            executor.go();
            executor.finalization();
            if (executor.getResult().getException() != null) {
                log.error("cannot execute constant call", (Throwable)executor.getResult().getException());
            }
            TransactionReceipt transactionReceipt = executor.getReceipt();
            return transactionReceipt;
        }
        finally {
            repository.rollback();
        }
    }

    @Override
    public String eth_call(JsonRpc.CallArguments args, String bnOrId) throws Exception {
        TransactionReceipt res;
        if ("pending".equals(bnOrId)) {
            Block pendingBlock = this.blockchain.createNewBlock(this.blockchain.getBestBlock(), this.pendingState.getPendingTransactions(), Collections.emptyList());
            res = this.createCallTxAndExecute(args, pendingBlock, this.pendingState.getRepository(), this.blockchain.getBlockStore());
        } else {
            res = this.createCallTxAndExecute(args, this.getByJsonBlockId(bnOrId));
        }
        return TypeConverter.toJsonHex(res.getExecutionResult());
    }

    @Override
    public String eth_estimateGas(JsonRpc.CallArguments args) throws Exception {
        TransactionReceipt res = this.createCallTxAndExecute(args, this.blockchain.getBestBlock());
        return TypeConverter.toJsonHex(res.getGasUsed());
    }

    protected JsonRpc.BlockResult getBlockResult(Block block, boolean fullTx) {
        if (block == null) {
            return null;
        }
        boolean isPending = ByteUtil.byteArrayToLong((byte[])block.getNonce()) == 0L;
        JsonRpc.BlockResult br = new JsonRpc.BlockResult();
        br.number = isPending ? null : TypeConverter.toJsonHex(block.getNumber());
        br.hash = isPending ? null : TypeConverter.toJsonHex(block.getHash());
        br.parentHash = TypeConverter.toJsonHex(block.getParentHash());
        br.nonce = isPending ? null : TypeConverter.toJsonHex(block.getNonce());
        br.sha3Uncles = TypeConverter.toJsonHex(block.getUnclesHash());
        br.logsBloom = isPending ? null : TypeConverter.toJsonHex(block.getLogBloom());
        br.transactionsRoot = TypeConverter.toJsonHex(block.getTxTrieRoot());
        br.stateRoot = TypeConverter.toJsonHex(block.getStateRoot());
        br.receiptRoot = TypeConverter.toJsonHex(block.getReceiptsRoot());
        br.miner = isPending ? null : TypeConverter.toJsonHex(block.getCoinbase());
        br.difficulty = TypeConverter.toJsonHex(block.getDifficultyBI());
        br.totalDifficulty = TypeConverter.toJsonHex(this.blockStore.getTotalDifficultyForHash(block.getHash()));
        if (block.getExtraData() != null) {
            br.extraData = TypeConverter.toJsonHex(block.getExtraData());
        }
        br.size = TypeConverter.toJsonHex(block.getEncoded().length);
        br.gasLimit = TypeConverter.toJsonHex(block.getGasLimit());
        br.gasUsed = TypeConverter.toJsonHex(block.getGasUsed());
        br.timestamp = TypeConverter.toJsonHex(block.getTimestamp());
        ArrayList<Object> txes = new ArrayList<Object>();
        if (fullTx) {
            for (int i = 0; i < block.getTransactionsList().size(); ++i) {
                txes.add(new TransactionResultDTO(block, i, (Transaction)block.getTransactionsList().get(i)));
            }
        } else {
            for (Transaction tx : block.getTransactionsList()) {
                txes.add(TypeConverter.toJsonHex(tx.getHash()));
            }
        }
        br.transactions = txes.toArray();
        ArrayList<String> ul = new ArrayList<String>();
        for (BlockHeader header : block.getUncleList()) {
            ul.add(TypeConverter.toJsonHex(header.getHash()));
        }
        br.uncles = ul.toArray(new String[ul.size()]);
        return br;
    }

    @Override
    public JsonRpc.BlockResult eth_getBlockByHash(String blockHash, Boolean fullTransactionObjects) throws Exception {
        Block b = this.getBlockByJSonHash(blockHash);
        return this.getBlockResult(b, fullTransactionObjects);
    }

    @Override
    public JsonRpc.BlockResult eth_getBlockByNumber(String bnOrId, Boolean fullTransactionObjects) throws Exception {
        Block b = "pending".equalsIgnoreCase(bnOrId) ? this.blockchain.createNewBlock(this.blockchain.getBestBlock(), this.pendingState.getPendingTransactions(), Collections.emptyList()) : this.getByJsonBlockId(bnOrId);
        return b == null ? null : this.getBlockResult(b, fullTransactionObjects);
    }

    @Override
    public TransactionResultDTO eth_getTransactionByHash(String transactionHash) throws Exception {
        byte[] txHash = TypeConverter.StringHexToByteArray(transactionHash);
        TransactionInfo txInfo = this.blockchain.getTransactionInfo(txHash);
        if (txInfo == null) {
            return null;
        }
        Block block = this.blockchain.getBlockByHash(txInfo.getBlockHash());
        Block mainBlock = this.blockchain.getBlockByNumber(block.getNumber());
        if (!Arrays.equals(block.getHash(), mainBlock.getHash())) {
            return null;
        }
        txInfo.setTransaction((Transaction)block.getTransactionsList().get(txInfo.getIndex()));
        return new TransactionResultDTO(block, txInfo.getIndex(), txInfo.getReceipt().getTransaction());
    }

    @Override
    public TransactionResultDTO eth_getTransactionByBlockHashAndIndex(String blockHash, String index) throws Exception {
        Block b = this.getBlockByJSonHash(blockHash);
        if (b == null) {
            return null;
        }
        int idx = this.JSonHexToInt(index);
        if (idx >= b.getTransactionsList().size()) {
            return null;
        }
        Transaction tx = (Transaction)b.getTransactionsList().get(idx);
        return new TransactionResultDTO(b, idx, tx);
    }

    @Override
    public TransactionResultDTO eth_getTransactionByBlockNumberAndIndex(String bnOrId, String index) throws Exception {
        Block b = this.getByJsonBlockId(bnOrId);
        List<Transaction> txs = this.getTransactionsByJsonBlockId(bnOrId);
        if (txs == null) {
            return null;
        }
        int idx = this.JSonHexToInt(index);
        if (idx >= txs.size()) {
            return null;
        }
        Transaction tx = txs.get(idx);
        return new TransactionResultDTO(b, idx, tx);
    }

    @Override
    public TransactionReceiptDTO eth_getTransactionReceipt(String transactionHash) throws Exception {
        byte[] hash = TypeConverter.StringHexToByteArray(transactionHash);
        TransactionInfo txInfo = this.blockchain.getTransactionInfo(hash);
        if (txInfo == null) {
            return null;
        }
        Block block = this.blockchain.getBlockByHash(txInfo.getBlockHash());
        Block mainBlock = this.blockchain.getBlockByNumber(block.getNumber());
        if (!Arrays.equals(block.getHash(), mainBlock.getHash())) {
            return null;
        }
        return new TransactionReceiptDTO(block, txInfo);
    }

    @Override
    public TransactionReceiptDTOExt ethj_getTransactionReceipt(String transactionHash) throws Exception {
        Block block;
        TransactionInfo txInfo;
        byte[] hash = TypeConverter.StringHexToByteArray(transactionHash);
        TransactionReceipt pendingReceipt = this.pendingReceipts.get(new ByteArrayWrapper(hash));
        if (pendingReceipt != null) {
            txInfo = new TransactionInfo(pendingReceipt);
            block = null;
        } else {
            txInfo = this.blockchain.getTransactionInfo(hash);
            if (txInfo == null) {
                return null;
            }
            block = this.blockchain.getBlockByHash(txInfo.getBlockHash());
            Block mainBlock = this.blockchain.getBlockByNumber(block.getNumber());
            if (!Arrays.equals(block.getHash(), mainBlock.getHash())) {
                return null;
            }
        }
        return new TransactionReceiptDTOExt(block, txInfo);
    }

    @Override
    public JsonRpc.BlockResult eth_getUncleByBlockHashAndIndex(String blockHash, String uncleIdx) throws Exception {
        Block block = this.blockchain.getBlockByHash(TypeConverter.StringHexToByteArray(blockHash));
        if (block == null) {
            return null;
        }
        int idx = this.JSonHexToInt(uncleIdx);
        if (idx >= block.getUncleList().size()) {
            return null;
        }
        BlockHeader uncleHeader = (BlockHeader)block.getUncleList().get(idx);
        Block uncle = this.blockchain.getBlockByHash(uncleHeader.getHash());
        if (uncle == null) {
            uncle = new Block(uncleHeader, Collections.emptyList(), Collections.emptyList());
        }
        return this.getBlockResult(uncle, false);
    }

    @Override
    public JsonRpc.BlockResult eth_getUncleByBlockNumberAndIndex(String blockId, String uncleIdx) throws Exception {
        Block block = this.getByJsonBlockId(blockId);
        return block == null ? null : this.eth_getUncleByBlockHashAndIndex(TypeConverter.toJsonHex(block.getHash()), uncleIdx);
    }

    @Override
    public String[] eth_getCompilers() {
        return new String[]{"solidity"};
    }

    @Override
    public JsonRpc.CompilationResult eth_compileSolidity(String contract) throws Exception {
        SolidityCompiler.Result res = SolidityCompiler.compile((byte[])contract.getBytes(), (boolean)true, (SolidityCompiler.Option[])new SolidityCompiler.Option[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE});
        if (res.isFailed()) {
            throw new RuntimeException("Compilation error: " + res.errors);
        }
        CompilationResult result = CompilationResult.parse((String)res.output);
        JsonRpc.CompilationResult ret = new JsonRpc.CompilationResult();
        CompilationResult.ContractMetadata contractMetadata = (CompilationResult.ContractMetadata)result.getContracts().iterator().next();
        ret.code = TypeConverter.toJsonHex(contractMetadata.bin);
        ret.info = new JsonRpc.CompilationInfo();
        ret.info.source = contract;
        ret.info.language = "Solidity";
        ret.info.languageVersion = "0";
        ret.info.compilerVersion = result.version;
        ret.info.abiDefinition = new CallTransaction.Contract((String)contractMetadata.abi).functions;
        return ret;
    }

    @Override
    public String eth_newFilter(JsonRpc.FilterRequest fr) throws Exception {
        Block blockTo;
        LogFilter logFilter = new LogFilter();
        if (fr.address instanceof String) {
            logFilter.withContractAddress((byte[][])new byte[][]{TypeConverter.StringHexToByteArray((String)fr.address)});
        } else if (fr.address instanceof String[]) {
            Object[] addr = new ArrayList();
            String[] stringArray = (String[])fr.address;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                addr.add(TypeConverter.StringHexToByteArray(s));
            }
            logFilter.withContractAddress((byte[][])addr.toArray((T[])new byte[0][]));
        }
        if (fr.topics != null) {
            for (Object topic : fr.topics) {
                if (topic == null) {
                    logFilter.withTopic((byte[][])null);
                    continue;
                }
                if (topic instanceof String) {
                    logFilter.withTopic((byte[][])new byte[][]{new DataWord(TypeConverter.StringHexToByteArray((String)topic)).getData()});
                    continue;
                }
                if (!(topic instanceof String[])) continue;
                ArrayList<byte[]> t = new ArrayList<byte[]>();
                for (String s : (String[])topic) {
                    t.add(new DataWord(TypeConverter.StringHexToByteArray(s)).getData());
                }
                logFilter.withTopic((byte[][])t.toArray((T[])new byte[0][]));
            }
        }
        JsonLogFilter filter = new JsonLogFilter(logFilter);
        int id = this.filterCounter.getAndIncrement();
        this.installedFilters.put(id, filter);
        Block blockFrom = fr.fromBlock == null ? null : this.getByJsonBlockId(fr.fromBlock);
        Block block = blockTo = fr.toBlock == null ? null : this.getByJsonBlockId(fr.toBlock);
        if (blockFrom != null) {
            blockTo = blockTo == null ? this.blockchain.getBestBlock() : blockTo;
            for (long blockNum = blockFrom.getNumber(); blockNum <= blockTo.getNumber(); ++blockNum) {
                filter.onBlock(this.blockchain.getBlockByNumber(blockNum));
            }
        }
        if ("pending".equalsIgnoreCase(fr.fromBlock) || "pending".equalsIgnoreCase(fr.toBlock)) {
            filter.onPendingTx = true;
        } else if (fr.toBlock == null || BLOCK_LATEST.equalsIgnoreCase(fr.fromBlock) || BLOCK_LATEST.equalsIgnoreCase(fr.toBlock)) {
            filter.onNewBlock = true;
        }
        return TypeConverter.toJsonHex(id);
    }

    @Override
    public String eth_newBlockFilter() {
        int id = this.filterCounter.getAndIncrement();
        this.installedFilters.put(id, new NewBlockFilter());
        return TypeConverter.toJsonHex(id);
    }

    @Override
    public String eth_newPendingTransactionFilter() {
        int id = this.filterCounter.getAndIncrement();
        this.installedFilters.put(id, new PendingTransactionFilter());
        return TypeConverter.toJsonHex(id);
    }

    @Override
    public boolean eth_uninstallFilter(String id) {
        if (id == null) {
            return false;
        }
        return this.installedFilters.remove(TypeConverter.StringHexToBigInteger(id).intValue()) != null;
    }

    @Override
    public Object[] eth_getFilterChanges(String id) {
        Filter filter = this.installedFilters.get(TypeConverter.StringHexToBigInteger(id).intValue());
        if (filter == null) {
            return null;
        }
        return filter.poll();
    }

    @Override
    public Object[] eth_getFilterLogs(String id) {
        Filter filter = this.installedFilters.get(TypeConverter.StringHexToBigInteger(id).intValue());
        if (filter == null) {
            return null;
        }
        return filter.getAll();
    }

    @Override
    public Object[] eth_getLogs(JsonRpc.FilterRequest filterRequest) throws Exception {
        log.debug("eth_getLogs ...");
        String id = this.eth_newFilter(filterRequest);
        Object[] ret = this.eth_getFilterChanges(id);
        this.eth_uninstallFilter(id);
        return ret;
    }

    @Override
    public boolean eth_submitWork(String nonceHex, String headerHex, String digestHex) throws Exception {
        try {
            long nonce = TypeConverter.HexToLong(nonceHex);
            byte[] digest = TypeConverter.StringHexToByteArray(digestHex);
            byte[] header = TypeConverter.StringHexToByteArray(headerHex);
            Block block = this.miningBlocks.remove(new ByteArrayWrapper(header));
            if (block != null && this.miningTask != null) {
                block.setNonce(ByteUtil.longToBytes((long)nonce));
                block.setMixHash(digest);
                this.miningTask.set((Object)new MinerIfc.MiningResult(nonce, digest, block));
                this.miningTask = null;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("eth_submitWork", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean eth_submitHashrate(String hashrate, String id) {
        this.hashrate = hashrate;
        return true;
    }

    @Override
    public String[] ethj_listAvailableMethods() {
        Set ignore = Arrays.asList(Object.class.getMethods()).stream().map(method -> method.getName()).collect(Collectors.toSet());
        return (String[])Arrays.asList(EthJsonRpcImpl.class.getMethods()).stream().filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> !ignore.contains(method.getName())).map(method -> {
            List params = Arrays.asList(method.getParameters()).stream().map(parameter -> parameter.isNamePresent() ? parameter.getName() : parameter.getType().getSimpleName()).collect(Collectors.toList());
            params.add(0, method.getName());
            return params.stream().collect(Collectors.joining(" "));
        }).sorted(String::compareTo).toArray(String[]::new);
    }

    @Override
    public String net_version() {
        return "1.0";
    }

    @Override
    public boolean net_listening() {
        return true;
    }

    class JsonLogFilter
    extends Filter {
        LogFilter logFilter;
        boolean onNewBlock;
        boolean onPendingTx;

        public JsonLogFilter(LogFilter logFilter) {
            this.logFilter = logFilter;
        }

        void onLogMatch(LogInfo logInfo, Block b, int txIndex, Transaction tx, int logIdx) {
            this.add(new LogFilterEvent(new JsonRpc.LogFilterElement(logInfo, b, txIndex, tx, logIdx)));
        }

        void onTransactionReceipt(TransactionReceipt receipt, Block b, int txIndex) {
            if (this.logFilter.matchBloom(receipt.getBloomFilter())) {
                int logIdx = 0;
                for (LogInfo logInfo : receipt.getLogInfoList()) {
                    if (this.logFilter.matchBloom(logInfo.getBloom()) && this.logFilter.matchesExactly(logInfo)) {
                        this.onLogMatch(logInfo, b, txIndex, receipt.getTransaction(), logIdx);
                    }
                    ++logIdx;
                }
            }
        }

        void onTransaction(Transaction tx, Block b, int txIndex) {
            if (this.logFilter.matchesContractAddress(tx.getReceiveAddress())) {
                TransactionInfo txInfo = EthJsonRpcImpl.this.blockchain.getTransactionInfo(tx.getHash());
                this.onTransactionReceipt(txInfo.getReceipt(), b, txIndex);
            }
        }

        void onBlock(Block b) {
            if (this.logFilter.matchBloom(new Bloom(b.getLogBloom()))) {
                int txIdx = 0;
                for (Transaction tx : b.getTransactionsList()) {
                    this.onTransaction(tx, b, txIdx);
                    ++txIdx;
                }
            }
        }

        @Override
        public void newBlockReceived(Block b) {
            if (this.onNewBlock) {
                this.onBlock(b);
            }
        }

        @Override
        public void newPendingTx(Transaction tx) {
        }

        class LogFilterEvent
        extends Filter.FilterEvent {
            private final JsonRpc.LogFilterElement el;

            LogFilterEvent(JsonRpc.LogFilterElement el) {
                this.el = el;
            }

            @Override
            public JsonRpc.LogFilterElement getJsonEventObject() {
                return this.el;
            }
        }
    }

    static class PendingTransactionFilter
    extends Filter {
        PendingTransactionFilter() {
        }

        @Override
        public void newPendingTx(Transaction tx) {
            this.add(new PendingTransactionFilterEvent(tx));
        }

        class PendingTransactionFilterEvent
        extends Filter.FilterEvent {
            private final Transaction tx;

            PendingTransactionFilterEvent(Transaction tx) {
                this.tx = tx;
            }

            @Override
            public String getJsonEventObject() {
                return TypeConverter.toJsonHex(this.tx.getHash());
            }
        }
    }

    static class NewBlockFilter
    extends Filter {
        NewBlockFilter() {
        }

        @Override
        public void newBlockReceived(Block b) {
            this.add(new NewBlockFilterEvent(b));
        }

        class NewBlockFilterEvent
        extends Filter.FilterEvent {
            public final Block b;

            NewBlockFilterEvent(Block b) {
                this.b = b;
            }

            @Override
            public String getJsonEventObject() {
                return TypeConverter.toJsonHex(this.b.getHash());
            }
        }
    }

    static class Filter {
        static final int MAX_EVENT_COUNT = 1024;
        private int pollStart = 0;
        List<FilterEvent> events = new LinkedList<FilterEvent>();

        Filter() {
        }

        public synchronized boolean hasNew() {
            return !this.events.isEmpty();
        }

        public synchronized Object[] poll() {
            Object[] ret = new Object[this.events.size() - this.pollStart];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.events.get(i + this.pollStart).getJsonEventObject();
            }
            this.pollStart += ret.length;
            return ret;
        }

        public synchronized Object[] getAll() {
            Object[] ret = new Object[this.events.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.events.get(i).getJsonEventObject();
            }
            return ret;
        }

        protected synchronized void add(FilterEvent evt) {
            this.events.add(evt);
            if (this.events.size() > 1024) {
                this.events.remove(0);
                if (this.pollStart > 0) {
                    --this.pollStart;
                }
            }
        }

        public void newBlockReceived(Block b) {
        }

        public void newPendingTx(Transaction tx) {
        }

        static abstract class FilterEvent {
            FilterEvent() {
            }

            public abstract Object getJsonEventObject();
        }
    }

    public class BinaryCallArguments {
        public long nonce;
        public long gasPrice;
        public long gasLimit;
        public String toAddress;
        public String fromAddress;
        public long value;
        public byte[] data;

        public void setArguments(JsonRpc.CallArguments args) throws Exception {
            this.nonce = 0L;
            if (args.nonce != null && args.nonce.length() != 0) {
                this.nonce = EthJsonRpcImpl.this.JSonHexToLong(args.nonce);
            }
            this.gasPrice = 0L;
            if (args.gasPrice != null && args.gasPrice.length() != 0) {
                this.gasPrice = EthJsonRpcImpl.this.JSonHexToLong(args.gasPrice);
            }
            this.gasLimit = 4000000L;
            if (args.gas != null && args.gas.length() != 0) {
                this.gasLimit = EthJsonRpcImpl.this.JSonHexToLong(args.gas);
            }
            this.toAddress = null;
            if (args.to != null && !args.to.isEmpty()) {
                this.toAddress = EthJsonRpcImpl.this.JSonHexToHex(args.to);
            }
            this.fromAddress = null;
            if (args.from != null && !args.from.isEmpty()) {
                this.fromAddress = EthJsonRpcImpl.this.JSonHexToHex(args.from);
            }
            this.value = 0L;
            if (args.value != null && args.value.length() != 0) {
                this.value = EthJsonRpcImpl.this.JSonHexToLong(args.value);
            }
            this.data = null;
            if (args.data != null && args.data.length() != 0) {
                this.data = TypeConverter.StringHexToByteArray(args.data);
            }
        }
    }
}

