/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj.jsonrpc;

import com.googlecode.jsonrpc4j.JsonRpcService;
import io.iconator.testrpcj.jsonrpc.TransactionReceiptDTO;
import io.iconator.testrpcj.jsonrpc.TransactionReceiptDTOExt;
import io.iconator.testrpcj.jsonrpc.TransactionResultDTO;
import io.iconator.testrpcj.jsonrpc.TypeConverter;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.ethereum.core.Block;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Transaction;
import org.ethereum.vm.DataWord;
import org.ethereum.vm.LogInfo;

@JsonRpcService(value="/rpc")
public interface JsonRpc {
    public String web3_clientVersion();

    public String web3_sha3(String var1) throws Exception;

    public String eth_protocolVersion();

    public Object eth_syncing();

    public String eth_coinbase();

    public boolean eth_mining();

    public String eth_hashrate();

    public String eth_gasPrice();

    public String[] eth_accounts();

    public String eth_blockNumber();

    public String eth_getBalance(String var1, String var2) throws Exception;

    public String eth_getLastBalance(String var1) throws Exception;

    public String eth_getStorageAt(String var1, String var2, String var3) throws Exception;

    public String eth_getTransactionCount(String var1, String var2) throws Exception;

    public String eth_getBlockTransactionCountByHash(String var1) throws Exception;

    public String eth_getBlockTransactionCountByNumber(String var1) throws Exception;

    public String eth_getUncleCountByBlockHash(String var1) throws Exception;

    public String eth_getUncleCountByBlockNumber(String var1) throws Exception;

    public String eth_getCode(String var1, String var2) throws Exception;

    public String eth_sign(String var1, String var2) throws Exception;

    public String eth_sendTransaction(CallArguments var1) throws Exception;

    public String eth_sendTransactionArgs(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws Exception;

    public String eth_sendRawTransaction(String var1) throws Exception;

    public String eth_call(CallArguments var1, String var2) throws Exception;

    public String eth_estimateGas(CallArguments var1) throws Exception;

    public BlockResult eth_getBlockByHash(String var1, Boolean var2) throws Exception;

    public BlockResult eth_getBlockByNumber(String var1, Boolean var2) throws Exception;

    public TransactionResultDTO eth_getTransactionByHash(String var1) throws Exception;

    public TransactionResultDTO eth_getTransactionByBlockHashAndIndex(String var1, String var2) throws Exception;

    public TransactionResultDTO eth_getTransactionByBlockNumberAndIndex(String var1, String var2) throws Exception;

    public TransactionReceiptDTO eth_getTransactionReceipt(String var1) throws Exception;

    public TransactionReceiptDTOExt ethj_getTransactionReceipt(String var1) throws Exception;

    public BlockResult eth_getUncleByBlockHashAndIndex(String var1, String var2) throws Exception;

    public BlockResult eth_getUncleByBlockNumberAndIndex(String var1, String var2) throws Exception;

    public String[] eth_getCompilers();

    public CompilationResult eth_compileSolidity(String var1) throws Exception;

    public String eth_newFilter(FilterRequest var1) throws Exception;

    public String eth_newBlockFilter();

    public String eth_newPendingTransactionFilter();

    public boolean eth_uninstallFilter(String var1);

    public Object[] eth_getFilterChanges(String var1);

    public Object[] eth_getFilterLogs(String var1);

    public Object[] eth_getLogs(FilterRequest var1) throws Exception;

    public boolean eth_submitWork(String var1, String var2, String var3) throws Exception;

    public boolean eth_submitHashrate(String var1, String var2);

    public String[] ethj_listAvailableMethods();

    public String net_version();

    public boolean net_listening();

    public static class LogFilterElement {
        public String logIndex;
        public String blockNumber;
        public String blockHash;
        public String transactionHash;
        public String transactionIndex;
        public String address;
        public String data;
        public String[] topics;

        public LogFilterElement(LogInfo logInfo, Block b, int txIndex, Transaction tx, int logIdx) {
            this.logIndex = TypeConverter.toJsonHex(logIdx);
            this.blockNumber = b == null ? null : TypeConverter.toJsonHex(b.getNumber());
            this.blockHash = b == null ? null : TypeConverter.toJsonHex(b.getHash());
            this.transactionIndex = b == null ? null : TypeConverter.toJsonHex(txIndex);
            this.transactionHash = TypeConverter.toJsonHex(tx.getHash());
            this.address = tx.getReceiveAddress() == null ? null : TypeConverter.toJsonHex(tx.getReceiveAddress());
            this.data = TypeConverter.toJsonHex(logInfo.getData());
            this.topics = new String[logInfo.getTopics().size()];
            for (int i = 0; i < this.topics.length; ++i) {
                this.topics[i] = TypeConverter.toJsonHex(((DataWord)logInfo.getTopics().get(i)).getData());
            }
        }

        public String toString() {
            return "LogFilterElement{logIndex='" + this.logIndex + '\'' + ", blockNumber='" + this.blockNumber + '\'' + ", blockHash='" + this.blockHash + '\'' + ", transactionHash='" + this.transactionHash + '\'' + ", transactionIndex='" + this.transactionIndex + '\'' + ", address='" + this.address + '\'' + ", data='" + this.data + '\'' + ", topics=" + Arrays.toString(this.topics) + '}';
        }
    }

    public static class FilterRequest {
        public String fromBlock;
        public String toBlock;
        public Object address;
        public Object[] topics;

        public String toString() {
            return "FilterRequest{fromBlock='" + this.fromBlock + '\'' + ", toBlock='" + this.toBlock + '\'' + ", address=" + this.address + ", topics=" + Arrays.toString(this.topics) + '}';
        }
    }

    public static class CompilationInfo {
        public String source;
        public String language;
        public String languageVersion;
        public String compilerVersion;
        public CallTransaction.Function[] abiDefinition;
        public String userDoc;
        public String developerDoc;

        public String toString() {
            return "CompilationInfo{source='" + this.source + '\'' + ", language='" + this.language + '\'' + ", languageVersion='" + this.languageVersion + '\'' + ", compilerVersion='" + this.compilerVersion + '\'' + ", abiDefinition=" + this.abiDefinition + ", userDoc='" + this.userDoc + '\'' + ", developerDoc='" + this.developerDoc + '\'' + '}';
        }
    }

    public static class CompilationResult {
        public String code;
        public CompilationInfo info;

        public String toString() {
            return "CompilationResult{code='" + this.code + '\'' + ", info=" + this.info + '}';
        }
    }

    public static class BlockResult {
        public String number;
        public String hash;
        public String parentHash;
        public String nonce;
        public String sha3Uncles;
        public String logsBloom;
        public String transactionsRoot;
        public String stateRoot;
        public String receiptRoot;
        public String miner;
        public String difficulty;
        public String totalDifficulty;
        public String extraData;
        public String size;
        public String gasLimit;
        public String gasUsed;
        public String timestamp;
        public Object[] transactions;
        public String[] uncles;

        public String toString() {
            return "BlockResult{number='" + this.number + '\'' + ", hash='" + this.hash + '\'' + ", parentHash='" + this.parentHash + '\'' + ", nonce='" + this.nonce + '\'' + ", sha3Uncles='" + this.sha3Uncles + '\'' + ", logsBloom='" + this.logsBloom + '\'' + ", transactionsRoot='" + this.transactionsRoot + '\'' + ", stateRoot='" + this.stateRoot + '\'' + ", receiptRoot='" + this.receiptRoot + '\'' + ", miner='" + this.miner + '\'' + ", difficulty='" + this.difficulty + '\'' + ", totalDifficulty='" + this.totalDifficulty + '\'' + ", extraData='" + this.extraData + '\'' + ", size='" + this.size + '\'' + ", gas='" + this.gasLimit + '\'' + ", gasUsed='" + this.gasUsed + '\'' + ", timestamp='" + this.timestamp + '\'' + ", transactions=" + Arrays.toString(this.transactions) + ", uncles=" + Arrays.toString(this.uncles) + '}';
        }
    }

    public static class CallArguments {
        public String from;
        public String to;
        public String gas;
        public String gasPrice;
        public String value;
        public String data;
        public String nonce;

        @ConstructorProperties(value={"from", "to", "gas", "gasPrice", "value", "data", "nonce"})
        public CallArguments(String from, String to, String gas, String gasPrice, String value, String data, String nonce) {
            this.from = from;
            this.to = to;
            this.gas = gas;
            this.gasPrice = gasPrice;
            this.value = value;
            this.data = data;
            this.nonce = nonce;
        }

        public CallArguments() {
        }

        public String toString() {
            return "CallArguments{from='" + this.from + '\'' + ", to='" + this.to + '\'' + ", gas='" + this.gas + '\'' + ", gasPrice='" + this.gasPrice + '\'' + ", value='" + this.value + '\'' + ", data='" + this.data + '\'' + ", nonce='" + this.nonce + '\'' + '}';
        }
    }

    public static class SyncingResult {
        public String startingBlock;
        public String currentBlock;
        public String highestBlock;

        @ConstructorProperties(value={"startingBlock", "currentBlock", "highestBlock"})
        public SyncingResult(String startingBlock, String currentBlock, String highestBlock) {
            this.startingBlock = startingBlock;
            this.currentBlock = currentBlock;
            this.highestBlock = highestBlock;
        }

        public SyncingResult() {
        }

        public String toString() {
            return "JsonRpc.SyncingResult(startingBlock=" + this.startingBlock + ", currentBlock=" + this.currentBlock + ", highestBlock=" + this.highestBlock + ")";
        }
    }
}

