/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import io.iconator.testrpcj.Contract;
import io.iconator.testrpcj.DeployedContract;
import io.iconator.testrpcj.Event;
import io.iconator.testrpcj.RPCServlet;
import io.iconator.testrpcj.jsonrpc.AddContentTypeFilter;
import io.iconator.testrpcj.jsonrpc.EthJsonRpcImpl;
import io.iconator.testrpcj.jsonrpc.JsonRpc;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.ethereum.config.BlockchainConfig;
import org.ethereum.config.BlockchainNetConfig;
import org.ethereum.config.SystemProperties;
import org.ethereum.config.blockchain.ByzantiumConfig;
import org.ethereum.config.blockchain.DaoHFConfig;
import org.ethereum.core.BlockHeader;
import org.ethereum.core.CallTransaction;
import org.ethereum.crypto.ECKey;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.blockchain.EtherUtil;
import org.ethereum.util.blockchain.StandaloneBlockchain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.AbiTypes;
import org.web3j.abi.datatypes.generated.Uint160;
import org.web3j.crypto.ContractUtils;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthCompileSolidity;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.http.HttpService;
import org.web3j.utils.Files;
import org.web3j.utils.Numeric;

public class TestBlockchain {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockchain.class);
    public static final ECKey ACCOUNT_0 = ECKey.fromPrivate((byte[])Hex.decode((String)"1b865950b17a065c79b11ecb39650c377b4963d6387b2fb97d71744b89a7295e"));
    public static final ECKey ACCOUNT_1 = ECKey.fromPrivate((byte[])Hex.decode((String)"c77ee832f3e5d7624ce9dab0eeb2958ad550e534952b79bb705e63b3989d4d1d"));
    public static final ECKey ACCOUNT_2 = ECKey.fromPrivate((byte[])Hex.decode((String)"ba7ffe9dee14b3626211b2d056eacc30e7a634f7e11eeb4dde6ee6d50d0c81ab"));
    public static final ECKey ACCOUNT_3 = ECKey.fromPrivate((byte[])Hex.decode((String)"64b1a16bb773bc2a6665967923cfd68f369e34f66ecd19c302995f8635598b1c"));
    public static final ECKey ACCOUNT_4 = ECKey.fromPrivate((byte[])Hex.decode((String)"399c34e860be1f2740297fcadd3546fdd4f5ba4c06d13882da1e48527df3acca"));
    public static final ECKey ACCOUNT_5 = ECKey.fromPrivate((byte[])Hex.decode((String)"a2a3abebd9160a2b2940970d848161008e3ea528aeaa927fb8b8370d3675f5f5"));
    public static final ECKey ACCOUNT_6 = ECKey.fromPrivate((byte[])Hex.decode((String)"e728d9667a27b7f6164309fc3809c00fd8d782d9343c0b73ea1f5a150ec3d05b"));
    public static final ECKey ACCOUNT_7 = ECKey.fromPrivate((byte[])Hex.decode((String)"d58fd771caefbdcca0c23fbc440fd03dacdee29cc4668cc9fc5acf29b4219f41"));
    public static final ECKey ACCOUNT_8 = ECKey.fromPrivate((byte[])Hex.decode((String)"649f638d220fd6319ca4af8f5e0e261d15a66172830077126fef21fdbdd95410"));
    public static final ECKey ACCOUNT_9 = ECKey.fromPrivate((byte[])Hex.decode((String)"ea8f71fc4690e0733f3478c3d8e53790988b9e51deabd10185364bc59c58fdba"));
    public static final Credentials CREDENTIAL_0 = TestBlockchain.create(ACCOUNT_0);
    public static final Credentials CREDENTIAL_1 = TestBlockchain.create(ACCOUNT_1);
    public static final Credentials CREDENTIAL_2 = TestBlockchain.create(ACCOUNT_2);
    public static final Credentials CREDENTIAL_3 = TestBlockchain.create(ACCOUNT_3);
    public static final Credentials CREDENTIAL_4 = TestBlockchain.create(ACCOUNT_4);
    public static final Credentials CREDENTIAL_5 = TestBlockchain.create(ACCOUNT_5);
    public static final Credentials CREDENTIAL_6 = TestBlockchain.create(ACCOUNT_6);
    public static final Credentials CREDENTIAL_7 = TestBlockchain.create(ACCOUNT_7);
    public static final Credentials CREDENTIAL_8 = TestBlockchain.create(ACCOUNT_8);
    public static final Credentials CREDENTIAL_9 = TestBlockchain.create(ACCOUNT_9);
    public static final Integer DEFAULT_PORT = 8545;
    public static final BigInteger GAS_PRICE = BigInteger.valueOf(10000000000L);
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(8300000L);
    private Server server = null;
    private StandaloneBlockchain standaloneBlockchain = null;
    private Web3j web3j;
    private ServletHolder holder;
    private Map<String, DeployedContract> cacheDeploy = new HashMap<String, DeployedContract>();

    public static void main(String[] args) throws Exception {
        Integer port = null;
        TestBlockchain t = new TestBlockchain();
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                LOG.info("The given parameter can't be parsed as a number: {}", (Object)args[0]);
                port = DEFAULT_PORT;
            }
        }
        LOG.info("Using port: {}", port);
        t.start(port);
    }

    public static TestBlockchain start() throws Exception {
        TestBlockchain t = new TestBlockchain();
        return t.start(DEFAULT_PORT);
    }

    public TestBlockchain start(int port) throws Exception {
        return this.start(port, Web3j.build((Web3jService)new HttpService("http://localhost:8545/rpc")));
    }

    public TestBlockchain start(int port, Web3j web3j) throws Exception {
        if (this.server != null) {
            this.stop();
        }
        this.web3j = web3j;
        this.server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        RPCServlet rpcServlet = this.createBlockchainServlet();
        this.holder = new ServletHolder((Servlet)rpcServlet);
        context.addServlet(this.holder, "/rpc");
        context.addFilter(AddContentTypeFilter.class, "/rpc", EnumSet.of(DispatcherType.REQUEST));
        this.server.start();
        return this;
    }

    private RPCServlet createBlockchainServlet() {
        this.standaloneBlockchain = new StandaloneBlockchain().withAccountBalance(ACCOUNT_0.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_1.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_2.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_3.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_4.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_5.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_6.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_7.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_8.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_9.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAutoblock(true).withNetConfig((BlockchainNetConfig)new ByzantiumConfig((BlockchainConfig)new DaoHFConfig()){

            public BigInteger calcDifficulty(BlockHeader curBlock, BlockHeader parent) {
                return BigInteger.ONE;
            }
        });
        this.standaloneBlockchain.createBlock();
        EthJsonRpcImpl ethJsonRpcImpl = new EthJsonRpcImpl(this.standaloneBlockchain);
        ethJsonRpcImpl.addAccount(CREDENTIAL_0.getAddress().substring(2), ACCOUNT_0);
        ethJsonRpcImpl.addAccount(CREDENTIAL_1.getAddress().substring(2), ACCOUNT_1);
        ethJsonRpcImpl.addAccount(CREDENTIAL_2.getAddress().substring(2), ACCOUNT_2);
        ethJsonRpcImpl.addAccount(CREDENTIAL_3.getAddress().substring(2), ACCOUNT_3);
        ethJsonRpcImpl.addAccount(CREDENTIAL_4.getAddress().substring(2), ACCOUNT_4);
        ethJsonRpcImpl.addAccount(CREDENTIAL_5.getAddress().substring(2), ACCOUNT_5);
        ethJsonRpcImpl.addAccount(CREDENTIAL_6.getAddress().substring(2), ACCOUNT_6);
        ethJsonRpcImpl.addAccount(CREDENTIAL_7.getAddress().substring(2), ACCOUNT_7);
        ethJsonRpcImpl.addAccount(CREDENTIAL_8.getAddress().substring(2), ACCOUNT_8);
        ethJsonRpcImpl.addAccount(CREDENTIAL_9.getAddress().substring(2), ACCOUNT_9);
        JsonRpcServer rpcServer = new JsonRpcServer(new ObjectMapper(), (Object)ethJsonRpcImpl, JsonRpc.class);
        return new RPCServlet(rpcServer);
    }

    public void reset() {
        if (this.holder != null) {
            RPCServlet rpcServlet = this.createBlockchainServlet();
            this.holder.setServlet((Servlet)rpcServlet);
        }
        this.cacheDeploy.clear();
    }

    public TestBlockchain stop() throws Exception {
        this.server.stop();
        this.server.destroy();
        this.server = null;
        this.standaloneBlockchain = null;
        this.cacheDeploy.clear();
        return this;
    }

    public Web3j web3j() {
        return this.web3j;
    }

    public BigInteger balance(Credentials credential) throws IOException, ExecutionException, InterruptedException {
        return ((EthGetBalance)this.web3j.ethGetBalance(credential.getAddress(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get()).getBalance();
    }

    public BigInteger balance(String address) throws IOException, ExecutionException, InterruptedException {
        return ((EthGetBalance)this.web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get()).getBalance();
    }

    public BigInteger nonce(Credentials credentials) throws IOException, ExecutionException, InterruptedException {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)this.web3j.ethGetTransactionCount(credentials.getAddress(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get();
        return ethGetTransactionCount.getTransactionCount();
    }

    public static Credentials create(ECKey ecKey) {
        BigInteger privKey = ecKey.getPrivKey();
        ECKeyPair pair = new ECKeyPair(privKey, Sign.publicKeyFromPrivate((BigInteger)privKey));
        return Credentials.create((ECKeyPair)pair);
    }

    public List<Type> callConstant(DeployedContract contract, String name, Object ... parameters) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ExecutionException, InterruptedException {
        Function function = TestBlockchain.createFunction(contract.contract(), name, parameters);
        if (function == null) {
            throw new RuntimeException("could not create/find function with name: " + name);
        }
        return this.callConstant(contract.credential(), contract.contractAddress(), function);
    }

    public List<Type> callConstant(Credentials credential, String contractAddress, Function function) throws IOException, ExecutionException, InterruptedException {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        EthCall ethCall = (EthCall)this.web3j.ethCall(Transaction.createEthCallTransaction((String)credential.getAddress(), (String)contractAddress, (String)encodedFunction), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get();
        if (ethCall.hasError()) {
            throw new IOException(ethCall.getError().toString());
        }
        String value = ethCall.getValue();
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    public List<Event> call(DeployedContract contract, String name, Object ... parameters) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, ExecutionException, InterruptedException {
        return this.call(contract.credential(), contract, BigInteger.ZERO, name, parameters);
    }

    public List<Event> call(Credentials credential, DeployedContract contract, BigInteger weiValue, String name, Object ... parameters) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, ExecutionException, InterruptedException {
        Function function = TestBlockchain.createFunction(contract.contract(), name, parameters);
        return this.call(credential, contract, weiValue, function);
    }

    public List<Event> call(Credentials credential, DeployedContract contract, BigInteger weiValue, Function function) throws IOException, ExecutionException, InterruptedException {
        BigInteger nonce = this.nonce(credential);
        String encodedFunction = FunctionEncoder.encode((Function)function);
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)GAS_PRICE, (BigInteger)GAS_LIMIT, (String)contract.contractAddress(), (BigInteger)weiValue, (String)encodedFunction);
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credential);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction ret = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        if (ret.hasError()) {
            throw new IOException(ret.getError().toString());
        }
        EthGetTransactionReceipt receipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(ret.getTransactionHash()).sendAsync().get();
        ArrayList<Event> events = new ArrayList<Event>();
        for (Log log : ((TransactionReceipt)receipt.getResult()).getLogs()) {
            for (String topic : log.getTopics()) {
                for (CallTransaction.Function f : contract.contract().functions()) {
                    if (!Hash.sha3String((String)f.formatSignature()).equals(topic)) continue;
                    StringBuilder sb = new StringBuilder("0x");
                    for (String topic2 : log.getTopics()) {
                        if (topic.equals(topic2)) continue;
                        sb.append(topic2.substring(2));
                    }
                    Map<Integer, TypeReference<Type>> outputIndexed = TestBlockchain.createEventIndexed(f, true);
                    ArrayList<TypeReference<Type>> tmp = new ArrayList<TypeReference<Type>>(outputIndexed.values());
                    List valuesIndexed = FunctionReturnDecoder.decode((String)sb.toString(), tmp);
                    Map<Integer, TypeReference<Type>> outputNonIndexed = TestBlockchain.createEventIndexed(f, false);
                    tmp = new ArrayList<TypeReference<Type>>(outputNonIndexed.values());
                    List valuesNonIndexed = FunctionReturnDecoder.decode((String)log.getData(), tmp);
                    ArrayList<Type> values = new ArrayList<Type>();
                    int len = valuesIndexed.size() + valuesNonIndexed.size();
                    for (int i = 0; i < len; ++i) {
                        if (outputIndexed.containsKey(i)) {
                            values.add((Type)valuesIndexed.remove(0));
                            continue;
                        }
                        if (outputNonIndexed.containsKey(i)) {
                            values.add((Type)valuesNonIndexed.remove(0));
                            continue;
                        }
                        throw new RuntimeException("cannot happen");
                    }
                    events.add(new Event(values, f.name, f.formatSignature(), topic));
                }
            }
        }
        return events;
    }

    public DeployedContract deploy(Credentials credential, Contract contract) throws IOException, ExecutionException, InterruptedException {
        return this.deploy(credential, contract, BigInteger.ZERO, Collections.emptyMap()).get(0);
    }

    public DeployedContract deploy(Credentials credential, String contractName, Map<String, Contract> contracts) throws InterruptedException, ExecutionException, IOException {
        return this.deploy(credential, contracts.get(contractName), contracts);
    }

    public DeployedContract deploy(Credentials credential, Contract contract, Map<String, Contract> dependencies) throws IOException, ExecutionException, InterruptedException {
        return this.deploy(credential, contract, BigInteger.ZERO, dependencies).get(0);
    }

    public List<DeployedContract> deploy(Credentials credential, Contract contract, BigInteger value, Map<String, Contract> dependencies) throws IOException, ExecutionException, InterruptedException {
        return this.deploy(credential, contract, value, dependencies, new ArrayList<DeployedContract>());
    }

    public List<DeployedContract> deploy(Credentials credential, Contract contract, BigInteger value, Map<String, Contract> dependencies, List<DeployedContract> retVal) throws IOException, ExecutionException, InterruptedException {
        if (contract.code().getCode().contains("__")) {
            Pattern p = Pattern.compile("__<stdin>:([^_]*)[_]+");
            Matcher m = p.matcher(contract.code().getCode());
            int prevStart = 0;
            StringBuilder sb = new StringBuilder();
            while (m.find(prevStart)) {
                String partOne = contract.code().getCode().substring(prevStart, m.start());
                sb.append(partOne);
                String depName = m.group(1);
                Contract dep = dependencies.get(depName);
                if (dep == null) {
                    throw new RuntimeException("cannot find dependency: " + depName);
                }
                DeployedContract otherContract = this.cacheDeploy.get(depName);
                if (otherContract == null) {
                    otherContract = this.deploy(credential, dep, BigInteger.ZERO, dependencies, retVal).get(retVal.size() - 1);
                    this.cacheDeploy.put(m.group(1), otherContract);
                }
                sb.append(otherContract.contractAddress().substring(2));
                prevStart = m.end();
            }
            sb.append(contract.code().getCode().substring(prevStart));
            contract.code().setCode(sb.toString());
            retVal.add(0, this.deploy(credential, contract, value));
        } else {
            retVal.add(0, this.deploy(credential, contract, value));
        }
        return retVal;
    }

    public DeployedContract deploy(Credentials credential, Contract contract, BigInteger value) throws IOException, ExecutionException, InterruptedException {
        BigInteger nonce = this.nonce(credential);
        RawTransaction rawTransaction = RawTransaction.createContractTransaction((BigInteger)nonce, (BigInteger)GAS_PRICE, (BigInteger)GAS_LIMIT, (BigInteger)value, (String)contract.code().getCode());
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credential);
        String hexValue = org.bouncycastle.util.encoders.Hex.toHexString((byte[])signedMessage);
        String contractAddress = ContractUtils.generateContractAddress((String)credential.getAddress(), (BigInteger)nonce);
        EthSendTransaction tx = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        EthGetTransactionReceipt receipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(tx.getTransactionHash()).sendAsync().get();
        LOG.info("Contract deployed at {}, {}", (Object)contractAddress, (Object)contract.code().getCode());
        return new DeployedContract(tx, contractAddress, credential, receipt, contract);
    }

    public static Map<String, Contract> compile(File source) throws IOException {
        SolidityCompiler.Result result = new SolidityCompiler(SystemProperties.getDefault()).compileSrc(source, true, true, new SolidityCompiler.Option[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE, SolidityCompiler.Options.METADATA});
        if (result.isFailed()) {
            throw new IOException(result.errors);
        }
        CompilationResult parsed = CompilationResult.parse((String)result.output);
        return TestBlockchain.compile(parsed);
    }

    public static Map<String, Contract> compileInline(File ... contracts) throws IOException {
        if (contracts.length == 0) {
            throw new RuntimeException("need files as input");
        }
        String contractSrc = Files.readString((File)contracts[0]);
        HashMap<String, String> dependencies = new HashMap<String, String>();
        for (int i = 1; i < contracts.length; ++i) {
            dependencies.put("./" + contracts[i].getName(), Files.readString((File)contracts[i]));
        }
        return TestBlockchain.compileInline(contractSrc, dependencies);
    }

    public static Map<String, Contract> compileInline(String contractSrc, Map<String, String> dependencies) throws IOException {
        Pattern p = Pattern.compile("\\s*import\\s*\"([^\"]*)\"\\s*;");
        Matcher m = p.matcher(contractSrc);
        StringBuilder sb = new StringBuilder();
        int prevStart = 0;
        while (m.find(prevStart)) {
            sb.append(contractSrc.substring(prevStart, m.start()));
            sb.append(TestBlockchain.stripPragma(dependencies.get(m.group(1))));
            prevStart = m.end();
        }
        sb.append(contractSrc.substring(prevStart));
        return TestBlockchain.compile(sb.toString());
    }

    private static String stripPragma(String contractSrc) {
        return contractSrc.replaceAll("\\s*pragma\\s*solidity.*;", "");
    }

    public static Map<String, Contract> compile(String contractSrc) throws IOException {
        new SolidityCompiler(SystemProperties.getDefault());
        SolidityCompiler.Result result = SolidityCompiler.compile((byte[])contractSrc.getBytes(), (boolean)true, (SolidityCompiler.Option[])new SolidityCompiler.Option[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE, SolidityCompiler.Options.METADATA});
        if (result.isFailed()) {
            throw new IOException(result.errors);
        }
        CompilationResult parsed = CompilationResult.parse((String)result.output);
        return TestBlockchain.compile(parsed);
    }

    private static Map<String, Contract> compile(CompilationResult parsed) throws IOException {
        HashMap<String, Contract> retVal = new HashMap<String, Contract>();
        for (String key : parsed.getContractKeys()) {
            String name = key.substring(key.lastIndexOf(58) + 1);
            CompilationResult.ContractMetadata meta = parsed.getContract(name);
            CallTransaction.Contract details = new CallTransaction.Contract(meta.abi);
            Contract contract = new Contract(new EthCompileSolidity.Code(meta.bin));
            for (CallTransaction.Function f : details.functions) {
                contract.addFunction(f);
            }
            retVal.put(name, contract);
        }
        return retVal;
    }

    private static Function createFunction(Contract contract, String name, Object ... input) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        for (CallTransaction.Function f : contract.functions()) {
            if (f == null || !f.name.equals(name)) continue;
            if (f.inputs.length != input.length) {
                throw new RuntimeException("contract input argument length: " + f.inputs.length + " does not match user input length: " + input.length + ". Function: " + f);
            }
            ArrayList inputParameters = new ArrayList();
            int len = f.inputs.length;
            for (int i = 0; i < len; ++i) {
                CallTransaction.Param p = f.inputs[i];
                Type<?> t = TestBlockchain.convertTypes(p.getType(), input[i]);
                inputParameters.add(t);
            }
            ArrayList<TypeReference> outputParameters = new ArrayList<TypeReference>();
            for (CallTransaction.Param p : f.outputs) {
                TypeReference t = TypeReference.create((Class)AbiTypes.getType((String)p.getType()));
                outputParameters.add(t);
            }
            return new Function(name, inputParameters, outputParameters);
        }
        return null;
    }

    private static Map<Integer, TypeReference<Type>> createEventIndexed(CallTransaction.Function f, boolean indexed) {
        LinkedHashMap<Integer, TypeReference<Type>> outputParameters = new LinkedHashMap<Integer, TypeReference<Type>>();
        int len = f.inputs.length;
        for (int i = 0; i < len; ++i) {
            CallTransaction.Param p = f.inputs[i];
            if (p.indexed ^ indexed) continue;
            TypeReference t = TypeReference.create((Class)AbiTypes.getType((String)p.getType()));
            outputParameters.put(i, (TypeReference<Type>)t);
        }
        return outputParameters;
    }

    private static List<TypeReference<Type>> createEvent(CallTransaction.Function f) {
        ArrayList<TypeReference<Type>> outputParameters = new ArrayList<TypeReference<Type>>();
        for (CallTransaction.Param p : f.inputs) {
            TypeReference t = TypeReference.create((Class)AbiTypes.getType((String)p.getType()));
            outputParameters.add((TypeReference<Type>)t);
        }
        return outputParameters;
    }

    private static Type<?> convertTypes(String type, Object param) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (type.contains("[]")) {
            if (!(param instanceof List)) {
                throw new RuntimeException("expected List for an array type got " + param.getClass());
            }
            ArrayList retVal = new ArrayList();
            for (Object o : (List)param) {
                Type<?> value = TestBlockchain.convertTypes(type.replace("[]", ""), o);
                retVal.add(value);
            }
            return new DynamicArray(retVal);
        }
        Class c = AbiTypes.getType((String)type);
        if (type.startsWith("uint") || type.startsWith("int")) {
            if (!(param instanceof Long) && !(param instanceof BigInteger)) {
                throw new RuntimeException("expected Long or BigInteger for uint, but got " + param.getClass());
            }
        } else if (type.startsWith("bytes")) {
            if (!(param instanceof byte[])) {
                throw new RuntimeException("expected byte[] for bytes*, but got " + param.getClass());
            }
        } else if (type.startsWith("address")) {
            if (!(param instanceof Uint160 || param instanceof BigInteger || param instanceof String)) {
                throw new RuntimeException("expected Uint160, BigInteger, or String for address, but got " + param.getClass());
            }
        } else if (type.startsWith("bool")) {
            if (!(param instanceof Boolean)) {
                throw new RuntimeException("expected Boolean for bool, but got " + param.getClass());
            }
        } else if (type.startsWith("string")) {
            if (!(param instanceof String)) {
                throw new RuntimeException("expected String for string, but got " + param.getClass());
            }
        } else {
            throw new RuntimeException("expected something known, this is unkown " + type);
        }
        if (param instanceof Long) {
            return (Type)c.getDeclaredConstructor(Long.TYPE).newInstance((long)((Long)param));
        }
        if (param instanceof Boolean) {
            return (Type)c.getDeclaredConstructor(Boolean.TYPE).newInstance((boolean)((Boolean)param));
        }
        return (Type)c.getDeclaredConstructor(param.getClass()).newInstance(param);
    }
}

