/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import io.iconator.testrpcj.Contract;
import io.iconator.testrpcj.DeployedContract;
import io.iconator.testrpcj.Event;
import io.iconator.testrpcj.RPCServlet;
import io.iconator.testrpcj.jsonrpc.AddContentTypeFilter;
import io.iconator.testrpcj.jsonrpc.EthJsonRpcImpl;
import io.iconator.testrpcj.jsonrpc.JsonRpc;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.ethereum.config.SystemProperties;
import org.ethereum.core.CallTransaction;
import org.ethereum.crypto.ECKey;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.blockchain.EtherUtil;
import org.ethereum.util.blockchain.StandaloneBlockchain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.AbiTypes;
import org.web3j.abi.datatypes.generated.Uint160;
import org.web3j.crypto.ContractUtils;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthCompileSolidity;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.http.HttpService;
import org.web3j.utils.Numeric;

public class TestBlockchain {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockchain.class);
    public static final ECKey ACCOUNT_0 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"1b865950b17a065c79b11ecb39650c377b4963d6387b2fb97d71744b89a7295e"));
    public static final ECKey ACCOUNT_1 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"c77ee832f3e5d7624ce9dab0eeb2958ad550e534952b79bb705e63b3989d4d1d"));
    public static final ECKey ACCOUNT_2 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"ba7ffe9dee14b3626211b2d056eacc30e7a634f7e11eeb4dde6ee6d50d0c81ab"));
    public static final ECKey ACCOUNT_3 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"64b1a16bb773bc2a6665967923cfd68f369e34f66ecd19c302995f8635598b1c"));
    public static final ECKey ACCOUNT_4 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"399c34e860be1f2740297fcadd3546fdd4f5ba4c06d13882da1e48527df3acca"));
    public static final ECKey ACCOUNT_5 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"a2a3abebd9160a2b2940970d848161008e3ea528aeaa927fb8b8370d3675f5f5"));
    public static final ECKey ACCOUNT_6 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"e728d9667a27b7f6164309fc3809c00fd8d782d9343c0b73ea1f5a150ec3d05b"));
    public static final ECKey ACCOUNT_7 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"d58fd771caefbdcca0c23fbc440fd03dacdee29cc4668cc9fc5acf29b4219f41"));
    public static final ECKey ACCOUNT_8 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"649f638d220fd6319ca4af8f5e0e261d15a66172830077126fef21fdbdd95410"));
    public static final ECKey ACCOUNT_9 = ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)"ea8f71fc4690e0733f3478c3d8e53790988b9e51deabd10185364bc59c58fdba"));
    public static final Integer DEFAULT_PORT = 8545;
    public static final BigInteger GAS_PRICE = BigInteger.valueOf(10000000000L);
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(8300000L);
    private Server server = null;
    private StandaloneBlockchain standaloneBlockchain = null;
    private Web3j web3j;

    public static void main(String[] args) throws Exception {
        Integer port = null;
        TestBlockchain t = new TestBlockchain();
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                LOG.info("The given parameter can't be parsed as a number: {}", (Object)args[0]);
                port = DEFAULT_PORT;
            }
        }
        LOG.info("Using port: {}", port);
        t.start(port);
    }

    public static TestBlockchain start() throws Exception {
        TestBlockchain t = new TestBlockchain();
        return t.start(DEFAULT_PORT);
    }

    public TestBlockchain start(int port) throws Exception {
        return this.start(port, Web3j.build((Web3jService)new HttpService("http://localhost:8545/rpc")));
    }

    public TestBlockchain start(int port, Web3j web3j) throws Exception {
        if (this.server != null) {
            this.stop();
        }
        this.web3j = web3j;
        this.server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        this.standaloneBlockchain = new StandaloneBlockchain().withAccountBalance(ACCOUNT_0.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_1.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_2.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_3.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_4.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_5.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_6.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_7.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_8.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_9.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAutoblock(true);
        this.standaloneBlockchain.createBlock();
        EthJsonRpcImpl ethJsonRpcImpl = new EthJsonRpcImpl(this.standaloneBlockchain);
        JsonRpcServer rpcServer = new JsonRpcServer(new ObjectMapper(), (Object)ethJsonRpcImpl, JsonRpc.class);
        RPCServlet rpcServlet = new RPCServlet(rpcServer);
        ServletHolder holder = new ServletHolder((Servlet)rpcServlet);
        context.addServlet(holder, "/rpc");
        context.addFilter(AddContentTypeFilter.class, "/rpc", EnumSet.of(DispatcherType.REQUEST));
        this.server.start();
        return this;
    }

    public TestBlockchain stop() throws Exception {
        this.server.stop();
        this.server.destroy();
        this.server = null;
        this.standaloneBlockchain = null;
        return this;
    }

    public Web3j web3j() {
        return this.web3j;
    }

    public BigInteger balance(ECKey address) throws IOException {
        return ((EthGetBalance)this.web3j.ethGetBalance(TestBlockchain.create(address).getAddress(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
    }

    public BigInteger balance(String address) throws IOException {
        return ((EthGetBalance)this.web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
    }

    public BigInteger nonce(Credentials credentials) throws IOException {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)this.web3j.ethGetTransactionCount(credentials.getAddress(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        return ethGetTransactionCount.getTransactionCount();
    }

    public static Credentials create(ECKey ecKey) {
        ECKeyPair pair = ECKeyPair.create((BigInteger)ecKey.getPrivKey());
        return Credentials.create((ECKeyPair)pair);
    }

    public List<Type> callConstant(DeployedContract contract, String name, Object ... parameters) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Function function = TestBlockchain.createFunction(contract.contract(), name, parameters);
        return this.callConstant(contract.owner(), contract.contractAddress(), function);
    }

    public List<Type> callConstant(ECKey account, String contractAddress, Function function) throws IOException {
        Credentials credentials = TestBlockchain.create(account);
        String encodedFunction = FunctionEncoder.encode((Function)function);
        EthCall ethCall = (EthCall)this.web3j.ethCall(Transaction.createEthCallTransaction((String)credentials.getAddress(), (String)contractAddress, (String)encodedFunction), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        if (ethCall.hasError()) {
            throw new IOException(ethCall.getError().toString());
        }
        String value = ethCall.getValue();
        System.out.println(value);
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    public List<Event> call(DeployedContract contract, String name, Object ... parameters) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException {
        return this.call(contract.owner(), contract, BigInteger.ZERO, name, parameters);
    }

    public List<Event> call(ECKey account, DeployedContract contract, BigInteger weiValue, String name, Object ... parameters) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException {
        Function function = TestBlockchain.createFunction(contract.contract(), name, parameters);
        return this.call(account, contract, weiValue, function);
    }

    public List<Event> call(ECKey account, DeployedContract contract, BigInteger weiValue, Function function) throws IOException {
        Credentials credentials = TestBlockchain.create(account);
        BigInteger nonce = this.nonce(credentials);
        String encodedFunction = FunctionEncoder.encode((Function)function);
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)GAS_PRICE, (BigInteger)GAS_LIMIT, (String)contract.contractAddress(), (BigInteger)weiValue, (String)encodedFunction);
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction ret = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).send();
        if (ret.hasError()) {
            throw new IOException(ret.getError().toString());
        }
        EthGetTransactionReceipt receipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(ret.getTransactionHash()).send();
        ArrayList<Event> events = new ArrayList<Event>();
        for (Log log : ((TransactionReceipt)receipt.getResult()).getLogs()) {
            for (String topic : log.getTopics()) {
                for (CallTransaction.Function f : contract.contract().functions()) {
                    if (!Hash.sha3String((String)f.formatSignature()).equals(topic)) continue;
                    List<TypeReference<Type>> output = TestBlockchain.createEvent(f);
                    List values = FunctionReturnDecoder.decode((String)log.getData(), output);
                    events.add(new Event(values, f.name, f.formatSignature(), topic));
                }
            }
        }
        return events;
    }

    public DeployedContract deploy(ECKey account, Contract contract) throws IOException {
        return this.deploy(account, contract, BigInteger.ZERO);
    }

    public DeployedContract deploy(ECKey account, Contract contract, BigInteger value) throws IOException {
        Credentials credentials = TestBlockchain.create(account);
        BigInteger nonce = this.nonce(credentials);
        RawTransaction rawTransaction = RawTransaction.createContractTransaction((BigInteger)nonce, (BigInteger)GAS_PRICE, (BigInteger)GAS_LIMIT, (BigInteger)value, (String)contract.code().getCode());
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credentials);
        String hexValue = Hex.toHexString((byte[])signedMessage);
        String contractAddress = ContractUtils.generateContractAddress((String)credentials.getAddress(), (BigInteger)nonce);
        EthSendTransaction tx = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).send();
        EthGetTransactionReceipt receipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(tx.getTransactionHash()).send();
        return new DeployedContract(tx, contractAddress, account, receipt, contract);
    }

    public static Map<String, Contract> compile(String contractSrc) throws IOException {
        new SolidityCompiler(SystemProperties.getDefault());
        SolidityCompiler.Result result = SolidityCompiler.compile((byte[])contractSrc.getBytes(), (boolean)true, (SolidityCompiler.Option[])new SolidityCompiler.Option[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE, SolidityCompiler.Options.METADATA});
        if (result.isFailed()) {
            throw new IOException(result.errors);
        }
        CompilationResult parsed = CompilationResult.parse((String)result.output);
        HashMap<String, Contract> retVal = new HashMap<String, Contract>();
        for (String key : parsed.getContractKeys()) {
            String name = key.substring(key.lastIndexOf(58) + 1);
            CompilationResult.ContractMetadata meta = parsed.getContract(name);
            CallTransaction.Contract details = new CallTransaction.Contract(meta.abi);
            Contract contract = new Contract(new EthCompileSolidity.Code(meta.bin));
            for (CallTransaction.Function f : details.functions) {
                contract.addFunction(f);
            }
            retVal.put(name, contract);
        }
        return retVal;
    }

    private static Function createFunction(Contract contract, String name, Object ... input) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        for (CallTransaction.Function f : contract.functions()) {
            if (f == null || !f.name.equals(name)) continue;
            if (f.inputs.length != input.length) {
                throw new RuntimeException("contract input argument length: " + f.inputs.length + " does not match user input length: " + input.length);
            }
            ArrayList inputParameters = new ArrayList();
            int len = f.inputs.length;
            for (int i = 0; i < len; ++i) {
                CallTransaction.Param p = f.inputs[i];
                Type<?> t = TestBlockchain.convertTypes(p, input[i]);
                inputParameters.add(t);
            }
            ArrayList<TypeReference> outputParameters = new ArrayList<TypeReference>();
            for (CallTransaction.Param p : f.outputs) {
                TypeReference t = TypeReference.create((Class)AbiTypes.getType((String)p.getType()));
                outputParameters.add(t);
            }
            return new Function(name, inputParameters, outputParameters);
        }
        return null;
    }

    private static List<TypeReference<Type>> createEvent(CallTransaction.Function f) {
        ArrayList<TypeReference<Type>> outputParameters = new ArrayList<TypeReference<Type>>();
        for (CallTransaction.Param p : f.inputs) {
            TypeReference t = TypeReference.create((Class)AbiTypes.getType((String)p.getType()));
            outputParameters.add((TypeReference<Type>)t);
        }
        return outputParameters;
    }

    private static Type<?> convertTypes(CallTransaction.Param p, Object param) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class c = AbiTypes.getType((String)p.getType());
        if (p.getType().startsWith("uint") || p.getType().startsWith("int")) {
            if (!(param instanceof Long) && !(param instanceof BigInteger)) {
                throw new RuntimeException("expected Long or BigInteger for uint, but got " + param.getClass());
            }
        } else if (p.getType().startsWith("bytes")) {
            if (!(param instanceof byte[])) {
                throw new RuntimeException("expected byte[] for bytes*, but got " + param.getClass());
            }
        } else if (p.getType().startsWith("address")) {
            if (!(param instanceof Uint160) || param instanceof BigInteger || param instanceof String) {
                throw new RuntimeException("expected Uint160, BigInteger, or String for address, but got " + param.getClass());
            }
        } else if (p.getType().startsWith("bool")) {
            if (!(param instanceof Boolean)) {
                throw new RuntimeException("expected Boolean for bool, but got " + param.getClass());
            }
        } else if (p.getType().startsWith("string")) {
            if (!(param instanceof String)) {
                throw new RuntimeException("expected String for string, but got " + param.getClass());
            }
        } else {
            throw new RuntimeException("expected something known, this is unkown " + p.getType());
        }
        if (param instanceof Long) {
            return (Type)c.getDeclaredConstructor(Long.TYPE).newInstance((long)((Long)param));
        }
        if (param instanceof Boolean) {
            return (Type)c.getDeclaredConstructor(Boolean.TYPE).newInstance((boolean)((Boolean)param));
        }
        return (Type)c.getDeclaredConstructor(param.getClass()).newInstance(param);
    }
}

