/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj;

import io.iconator.testrpcj.Contract;
import io.iconator.testrpcj.DeployedContract;
import io.iconator.testrpcj.Event;
import io.iconator.testrpcj.TestBlockchain;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ethereum.config.SystemProperties;
import org.ethereum.core.CallTransaction;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.methods.response.EthCompileSolidity;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.http.HttpService;

public class TestDeploy {
    private static TestBlockchain testBlockchain;
    private static Web3j web3j;

    @BeforeClass
    public static void setup() throws Exception {
        testBlockchain = TestBlockchain.start();
        web3j = Web3j.build((Web3jService)new HttpService("http://localhost:8545/rpc"));
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (testBlockchain != null) {
            testBlockchain.stop();
        }
    }

    @Test
    public void testConnect() throws IOException {
        Web3ClientVersion web3ClientVersion = (Web3ClientVersion)web3j.web3ClientVersion().send();
        String clientVersion = web3ClientVersion.getWeb3ClientVersion();
        Assert.assertTrue((boolean)clientVersion.startsWith("TestRPC-J"));
        System.out.println("Version: " + clientVersion);
    }

    @Test
    public void testManualCompile() throws IOException {
        String contractSrc = "pragma solidity ^0.4.24;\n\n//a comment\ncontract Example1 {\n\tuint counter;\n}";
        new SolidityCompiler(SystemProperties.getDefault());
        SolidityCompiler.Result r = SolidityCompiler.compile((byte[])contractSrc.getBytes(), (boolean)true, (SolidityCompiler.Option[])new SolidityCompiler.Option[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE, SolidityCompiler.Options.METADATA});
        Assert.assertTrue((!r.isFailed() ? 1 : 0) != 0);
        CompilationResult result = CompilationResult.parse((String)r.output);
        CompilationResult.ContractMetadata a = result.getContract("Example1");
        CallTransaction.Contract contract = new CallTransaction.Contract(a.abi);
        Assert.assertTrue((contract.functions.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompile() throws IOException {
        String contractSrc = "pragma solidity ^0.4.24;\n\n//a comment\ncontract Example1 {\n\tuint counter;\n}";
        EthCompileSolidity request = (EthCompileSolidity)web3j.ethCompileSolidity(contractSrc).send();
        EthCompileSolidity.Code c = (EthCompileSolidity.Code)request.getCompiledSolidity().get("code");
        Assert.assertTrue((boolean)c.getCode().startsWith("0x60806040"));
    }

    @Test
    public void testCompileGas() throws IOException {
        String contractSrc = "pragma solidity ^0.4.24;\n\ncontract Example2 {\n\tuint256 public counter;\n\tfunction set(uint256 _counter) public returns (uint256) {\n\t    uint256 tmp = counter;\n\t    counter = _counter;\n\t    return tmp;\n\t}\n\tfunction get() public view returns (uint256) {\n\t    return counter;\n\t}\n}\ncontract Example3 {\n    uint32 test;\n}";
        Map ret = TestBlockchain.compile((String)contractSrc);
        Assert.assertEquals((long)2L, (long)ret.size());
    }

    @Test
    public void testDeploy() throws IOException {
        String contractSrc = "pragma solidity ^0.4.24;\n\ncontract Exampl2 {\n\tuint256 public counter = 12;\n\tfunction set(uint256 _counter) public returns (uint256) {\n\t    uint256 tmp = counter;\n\t    counter = _counter;\n\t    return tmp;\n\t}\n\tfunction get() public view returns (uint256) {\n\t    return counter;\n\t}\n}";
        Map ret = TestBlockchain.compile((String)contractSrc);
        EthCompileSolidity.Code c = ((Contract)ret.get("Exampl2")).code();
        DeployedContract deployed = testBlockchain.deploy(TestBlockchain.ACCOUNT_0, (Contract)ret.get("Exampl2"));
        Function function = new Function("counter", Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        Type t = (Type)testBlockchain.callConstant(TestBlockchain.ACCOUNT_0, deployed.contractAddress(), function).get(0);
        Assert.assertEquals((Object)"12", (Object)t.getValue().toString());
        Function function2 = new Function("set", Arrays.asList(new Uint256(13L)), Arrays.asList(new TypeReference<Uint256>(){}));
        List events = testBlockchain.call(TestBlockchain.ACCOUNT_0, deployed, BigInteger.ZERO, function2);
        System.out.println(events);
        String value = ((Type)testBlockchain.callConstant(TestBlockchain.ACCOUNT_0, deployed.contractAddress(), function).get(0)).getValue().toString();
        Assert.assertEquals((Object)value, (Object)"13");
    }

    @Test
    public void testCall() throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String contractSrc = "pragma solidity ^0.4.24;\n\ncontract Exampl2 {\n\tuint256 public counter = 15;\n\tfunction set(uint256 _counter) public returns (uint256) {\n\t    uint256 tmp = counter;\n\t    counter = _counter;\n\t    return tmp;\n\t}\n\tfunction get() public view returns (uint256) {\n\t    return counter;\n\t}\n}";
        Map ret = TestBlockchain.compile((String)contractSrc);
        BigInteger balance = testBlockchain.balance(TestBlockchain.ACCOUNT_0);
        System.out.println("balance1: " + balance);
        DeployedContract deployed = testBlockchain.deploy(TestBlockchain.ACCOUNT_0, (Contract)ret.get("Exampl2"));
        testBlockchain.call(deployed, "set", new Object[]{5L});
        BigInteger balance2 = testBlockchain.balance(TestBlockchain.ACCOUNT_0);
        Assert.assertNotEquals((Object)balance, (Object)balance2);
        System.out.println("balance2: " + balance2);
        String value = ((Type)testBlockchain.callConstant(deployed, "get", new Object[0]).get(0)).getValue().toString();
        Assert.assertEquals((Object)value, (Object)"5");
        Assert.assertEquals((Object)balance2, (Object)testBlockchain.balance(TestBlockchain.ACCOUNT_0));
    }

    @Test
    public void testEvents() throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String contractSrc = "pragma solidity ^0.4.24;\n\ncontract ExampleEvent {\n\tuint256 public counter=3;\n\tevent Message(string, uint256);\n\tfunction set(uint256 _counter) public returns (uint256) {\n\t    uint256 tmp = counter;\n\t    counter = _counter;\n\t    emit Message(\"hey there1\", _counter);\n\t    emit Message(\"hey there2\", tmp);\n\t    return tmp;\n\t}\n\tfunction get() public view returns (uint256) {\n\t    return counter;\n\t}\n}\n";
        Map ret = TestBlockchain.compile((String)contractSrc);
        Contract contract = (Contract)ret.get("ExampleEvent");
        DeployedContract deployed = testBlockchain.deploy(TestBlockchain.ACCOUNT_0, contract);
        List events = testBlockchain.call(deployed, "set", new Object[]{5L});
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertEquals((Object)((Type)((Event)events.get(0)).values().get(0)).getValue().toString(), (Object)"hey there1");
        Assert.assertEquals((Object)((Type)((Event)events.get(0)).values().get(1)).getValue().toString(), (Object)"5");
        Assert.assertEquals((Object)((Type)((Event)events.get(1)).values().get(1)).getValue().toString(), (Object)"3");
    }
}

