/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj.jsonrpc;

import io.iconator.testrpcj.jsonrpc.JsonRpc;
import io.iconator.testrpcj.jsonrpc.TypeConverter;
import java.util.Arrays;
import org.ethereum.core.Block;
import org.ethereum.core.TransactionInfo;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.vm.LogInfo;

public class TransactionReceiptDTO {
    public String transactionHash;
    public String transactionIndex;
    public String blockHash;
    public String blockNumber;
    public String cumulativeGasUsed;
    public String gasUsed;
    public String contractAddress;
    public JsonRpc.LogFilterElement[] logs;

    public TransactionReceiptDTO(Block block, TransactionInfo txInfo) {
        TransactionReceipt receipt = txInfo.getReceipt();
        this.transactionHash = TypeConverter.toJsonHex(receipt.getTransaction().getHash());
        this.transactionIndex = TypeConverter.toJsonHex(new Integer(txInfo.getIndex()).longValue());
        this.cumulativeGasUsed = TypeConverter.toJsonHex(receipt.getCumulativeGas());
        this.gasUsed = TypeConverter.toJsonHex(receipt.getGasUsed());
        this.contractAddress = receipt.getTransaction().getContractAddress() != null ? TypeConverter.toJsonHex(receipt.getTransaction().getContractAddress()) : null;
        this.logs = new JsonRpc.LogFilterElement[receipt.getLogInfoList().size()];
        if (block != null) {
            this.blockNumber = TypeConverter.toJsonHex(block.getNumber());
            this.blockHash = TypeConverter.toJsonHex(txInfo.getBlockHash());
        } else {
            this.blockNumber = null;
            this.blockHash = null;
        }
        for (int i = 0; i < this.logs.length; ++i) {
            LogInfo logInfo = (LogInfo)receipt.getLogInfoList().get(i);
            this.logs[i] = new JsonRpc.LogFilterElement(logInfo, block, txInfo.getIndex(), txInfo.getReceipt().getTransaction(), i);
        }
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public String getCumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    public String getGasUsed() {
        return this.gasUsed;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public JsonRpc.LogFilterElement[] getLogs() {
        return this.logs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionReceiptDTO)) {
            return false;
        }
        TransactionReceiptDTO other = (TransactionReceiptDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$transactionHash = this.getTransactionHash();
        String other$transactionHash = other.getTransactionHash();
        if (this$transactionHash == null ? other$transactionHash != null : !this$transactionHash.equals(other$transactionHash)) {
            return false;
        }
        String this$transactionIndex = this.getTransactionIndex();
        String other$transactionIndex = other.getTransactionIndex();
        if (this$transactionIndex == null ? other$transactionIndex != null : !this$transactionIndex.equals(other$transactionIndex)) {
            return false;
        }
        String this$blockHash = this.getBlockHash();
        String other$blockHash = other.getBlockHash();
        if (this$blockHash == null ? other$blockHash != null : !this$blockHash.equals(other$blockHash)) {
            return false;
        }
        String this$blockNumber = this.getBlockNumber();
        String other$blockNumber = other.getBlockNumber();
        if (this$blockNumber == null ? other$blockNumber != null : !this$blockNumber.equals(other$blockNumber)) {
            return false;
        }
        String this$cumulativeGasUsed = this.getCumulativeGasUsed();
        String other$cumulativeGasUsed = other.getCumulativeGasUsed();
        if (this$cumulativeGasUsed == null ? other$cumulativeGasUsed != null : !this$cumulativeGasUsed.equals(other$cumulativeGasUsed)) {
            return false;
        }
        String this$gasUsed = this.getGasUsed();
        String other$gasUsed = other.getGasUsed();
        if (this$gasUsed == null ? other$gasUsed != null : !this$gasUsed.equals(other$gasUsed)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        return Arrays.deepEquals(this.getLogs(), other.getLogs());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $transactionHash = this.getTransactionHash();
        result = result * 59 + ($transactionHash == null ? 43 : $transactionHash.hashCode());
        String $transactionIndex = this.getTransactionIndex();
        result = result * 59 + ($transactionIndex == null ? 43 : $transactionIndex.hashCode());
        String $blockHash = this.getBlockHash();
        result = result * 59 + ($blockHash == null ? 43 : $blockHash.hashCode());
        String $blockNumber = this.getBlockNumber();
        result = result * 59 + ($blockNumber == null ? 43 : $blockNumber.hashCode());
        String $cumulativeGasUsed = this.getCumulativeGasUsed();
        result = result * 59 + ($cumulativeGasUsed == null ? 43 : $cumulativeGasUsed.hashCode());
        String $gasUsed = this.getGasUsed();
        result = result * 59 + ($gasUsed == null ? 43 : $gasUsed.hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLogs());
        return result;
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionReceiptDTO;
    }

    public String toString() {
        return "TransactionReceiptDTO(transactionHash=" + this.getTransactionHash() + ", transactionIndex=" + this.getTransactionIndex() + ", blockHash=" + this.getBlockHash() + ", blockNumber=" + this.getBlockNumber() + ", cumulativeGasUsed=" + this.getCumulativeGasUsed() + ", gasUsed=" + this.getGasUsed() + ", contractAddress=" + this.getContractAddress() + ", logs=" + Arrays.deepToString(this.getLogs()) + ")";
    }
}

