/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import io.iconator.testrpcj.RPCServlet;
import io.iconator.testrpcj.jsonrpc.AddContentTypeFilter;
import io.iconator.testrpcj.jsonrpc.EthJsonRpcImpl;
import io.iconator.testrpcj.jsonrpc.JsonRpc;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.ethereum.config.SystemProperties;
import org.ethereum.crypto.ECKey;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.blockchain.EtherUtil;
import org.ethereum.util.blockchain.StandaloneBlockchain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;

public class TestBlockchain {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockchain.class);
    public static final ECKey ACCOUNT_0 = ECKey.fromPrivate((byte[])Hex.decode((String)"1b865950b17a065c79b11ecb39650c377b4963d6387b2fb97d71744b89a7295e"));
    public static final ECKey ACCOUNT_1 = ECKey.fromPrivate((byte[])Hex.decode((String)"c77ee832f3e5d7624ce9dab0eeb2958ad550e534952b79bb705e63b3989d4d1d"));
    public static final ECKey ACCOUNT_2 = ECKey.fromPrivate((byte[])Hex.decode((String)"ba7ffe9dee14b3626211b2d056eacc30e7a634f7e11eeb4dde6ee6d50d0c81ab"));
    public static final ECKey ACCOUNT_3 = ECKey.fromPrivate((byte[])Hex.decode((String)"64b1a16bb773bc2a6665967923cfd68f369e34f66ecd19c302995f8635598b1c"));
    public static final ECKey ACCOUNT_4 = ECKey.fromPrivate((byte[])Hex.decode((String)"399c34e860be1f2740297fcadd3546fdd4f5ba4c06d13882da1e48527df3acca"));
    public static final ECKey ACCOUNT_5 = ECKey.fromPrivate((byte[])Hex.decode((String)"a2a3abebd9160a2b2940970d848161008e3ea528aeaa927fb8b8370d3675f5f5"));
    public static final ECKey ACCOUNT_6 = ECKey.fromPrivate((byte[])Hex.decode((String)"e728d9667a27b7f6164309fc3809c00fd8d782d9343c0b73ea1f5a150ec3d05b"));
    public static final ECKey ACCOUNT_7 = ECKey.fromPrivate((byte[])Hex.decode((String)"d58fd771caefbdcca0c23fbc440fd03dacdee29cc4668cc9fc5acf29b4219f41"));
    public static final ECKey ACCOUNT_8 = ECKey.fromPrivate((byte[])Hex.decode((String)"649f638d220fd6319ca4af8f5e0e261d15a66172830077126fef21fdbdd95410"));
    public static final ECKey ACCOUNT_9 = ECKey.fromPrivate((byte[])Hex.decode((String)"ea8f71fc4690e0733f3478c3d8e53790988b9e51deabd10185364bc59c58fdba"));
    private static final Integer DEFAULT_PORT = 8585;
    private Server server = null;
    private StandaloneBlockchain standaloneBlockchain = null;

    public static void main(String[] args) throws Exception {
        Integer port = null;
        TestBlockchain t = new TestBlockchain();
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                LOG.info("The given parameter is not a number: {}", (Object)args[0]);
                port = DEFAULT_PORT;
            }
        }
        LOG.info("Using port: {}", port);
        t.start(port);
    }

    public static SolidityCompiler compiler() {
        return new SolidityCompiler(SystemProperties.getDefault());
    }

    public TestBlockchain start() throws Exception {
        return this.start(DEFAULT_PORT);
    }

    public TestBlockchain start(int port) throws Exception {
        if (this.server != null) {
            this.stop();
        }
        this.server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        this.standaloneBlockchain = new StandaloneBlockchain().withAccountBalance(ACCOUNT_0.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_1.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_2.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_3.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_4.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_5.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_6.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_7.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_8.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_9.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAutoblock(true);
        this.standaloneBlockchain.createBlock();
        EthJsonRpcImpl ethJsonRpcImpl = new EthJsonRpcImpl(this.standaloneBlockchain);
        JsonRpcServer rpcServer = new JsonRpcServer(new ObjectMapper(), (Object)ethJsonRpcImpl, JsonRpc.class);
        RPCServlet rpcServlet = new RPCServlet(rpcServer);
        ServletHolder holder = new ServletHolder((Servlet)rpcServlet);
        context.addServlet(holder, "/rpc");
        context.addFilter(AddContentTypeFilter.class, "/rpc", EnumSet.of(DispatcherType.REQUEST));
        this.server.start();
        return this;
    }

    private TestBlockchain stop() throws Exception {
        this.server.stop();
        this.server.destroy();
        this.server = null;
        this.standaloneBlockchain = null;
        return this;
    }
}

