/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj.jsonrpc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(urlPatterns={"/rpc"})
public class JsonRpcUsageFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcUsageFilter.class);
    private static final List<String> EXCLUDE_LOGS = Arrays.asList("eth_getLogs", "eth_getFilterLogs", "personal_newAccount", "personal_importRawKey", "personal_unlockAccount", "personal_signAndSendTransaction");
    final ObjectMapper mapper = new ObjectMapper();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest || !(response instanceof HttpServletResponse)) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            boolean isJsonRpcUrl = "/rpc".equals(httpRequest.getRequestURI());
            if (isJsonRpcUrl && httpRequest.getMethod().equalsIgnoreCase("POST")) {
                try {
                    ResettableStreamHttpServletRequest wrappedRequest = new ResettableStreamHttpServletRequest(httpRequest);
                    String body = IOUtils.toString((Reader)wrappedRequest.getReader());
                    wrappedRequest.resetInputStream();
                    if (response.getCharacterEncoding() == null) {
                        response.setCharacterEncoding("UTF-8");
                    }
                    HttpServletResponseCopier responseCopier = new HttpServletResponseCopier(httpResponse);
                    try {
                        chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)responseCopier);
                        responseCopier.flushBuffer();
                    }
                    finally {
                        byte[] copy = responseCopier.getCopy();
                        String responseText = new String(copy, response.getCharacterEncoding());
                        JsonNode json = this.mapper.readTree(body);
                        JsonNode responseJson = this.mapper.readTree(responseText);
                        if (json.isArray()) {
                            for (int i = 0; i < json.size(); ++i) {
                                this.notifyInvocation(json.get(i), responseJson.get(i));
                            }
                        } else {
                            this.notifyInvocation(json, responseJson);
                        }
                        if (httpResponse.getStatus() == 500) {
                            httpResponse.setStatus(200);
                        }
                    }
                }
                catch (IOException e) {
                    log.error("Error parsing JSON-RPC request", (Throwable)e);
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            throw new RuntimeException("JsonRpcUsageFilter supports only HTTP requests.");
        }
    }

    private void notifyInvocation(JsonNode requestJson, JsonNode responseJson) throws IOException {
        if (responseJson.has("error")) {
            String errorMessage = responseJson.get("error").toString();
            log.warn("Problem when invoking JSON-RPC " + requestJson.toString() + " response:" + errorMessage);
        } else {
            String methodName = requestJson.get("method").asText();
            ArrayList params = new ArrayList();
            if (requestJson.has("params")) {
                requestJson.get("params").forEach(n -> params.add(n));
            }
            String responseText = this.mapper.writeValueAsString((Object)responseJson);
            if (log.isInfoEnabled() && !EXCLUDE_LOGS.contains(methodName)) {
                log.info(methodName + "(" + params.stream().map(n -> n.asText()).collect(Collectors.joining(", ")) + "): " + responseText);
            }
        }
    }

    private String dumpToString(JsonNode n) {
        if (n.isTextual()) {
            return n.asText();
        }
        try {
            return this.mapper.writeValueAsString((Object)n);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void destroy() {
    }

    public static class HttpServletResponseCopier
    extends HttpServletResponseWrapper {
        private ServletOutputStream outputStream;
        private PrintWriter writer;
        private ServletOutputStreamCopier copier;

        public HttpServletResponseCopier(HttpServletResponse response) throws IOException {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("getWriter() has already been called on this response.");
            }
            if (this.outputStream == null) {
                this.outputStream = this.getResponse().getOutputStream();
                this.copier = new ServletOutputStreamCopier((OutputStream)this.outputStream);
            }
            return this.copier;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.outputStream != null) {
                throw new IllegalStateException("getOutputStream() has already been called on this response.");
            }
            if (this.writer == null) {
                this.copier = new ServletOutputStreamCopier((OutputStream)this.getResponse().getOutputStream());
                this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.copier), this.getResponse().getCharacterEncoding()), true);
            }
            return this.writer;
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            } else if (this.outputStream != null) {
                this.copier.flush();
            }
        }

        public byte[] getCopy() {
            if (this.copier != null) {
                return this.copier.getCopy();
            }
            return new byte[0];
        }
    }

    public static class ServletOutputStreamCopier
    extends ServletOutputStream {
        private OutputStream outputStream;
        private ByteArrayOutputStream copy;

        public ServletOutputStreamCopier(OutputStream outputStream) {
            this.outputStream = outputStream;
            this.copy = new ByteArrayOutputStream(1024);
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
            this.copy.write(b);
        }

        public byte[] getCopy() {
            return this.copy.toByteArray();
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener listener) {
        }
    }

    private static class ResettableStreamHttpServletRequest
    extends HttpServletRequestWrapper {
        private byte[] rawData;
        private HttpServletRequest request;
        private ResettableServletInputStream servletStream;

        public ResettableStreamHttpServletRequest(HttpServletRequest request) {
            super(request);
            this.request = request;
            this.servletStream = new ResettableServletInputStream();
        }

        public void resetInputStream() {
            this.servletStream.stream = new ByteArrayInputStream(this.rawData);
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.rawData == null) {
                this.rawData = IOUtils.toByteArray((Reader)this.request.getReader());
                this.servletStream.stream = new ByteArrayInputStream(this.rawData);
            }
            return this.servletStream;
        }

        public BufferedReader getReader() throws IOException {
            if (this.rawData == null) {
                this.rawData = IOUtils.toByteArray((Reader)this.request.getReader());
            }
            this.servletStream = new ResettableServletInputStream();
            this.servletStream.stream = new ByteArrayInputStream(this.rawData);
            return new BufferedReader(new InputStreamReader((InputStream)((Object)this.servletStream)));
        }

        private static class ResettableServletInputStream
        extends ServletInputStream {
            private InputStream stream;

            private ResettableServletInputStream() {
            }

            public int read() throws IOException {
                return this.stream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener listener) {
            }
        }
    }
}

