/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj.jsonrpc;

import io.iconator.testrpcj.jsonrpc.TypeConverter;
import org.ethereum.core.Block;
import org.ethereum.core.Transaction;

public final class TransactionResultDTO {
    public final String hash;
    public final String nonce;
    public final String blockHash;
    public final String blockNumber;
    public final String transactionIndex;
    public final String from;
    public final String to;
    public final String gas;
    public final String gasPrice;
    public final String value;
    public final String input;

    public TransactionResultDTO(Block b, int index, Transaction tx) {
        this.hash = TypeConverter.toJsonHex(tx.getHash());
        this.nonce = TypeConverter.toJsonHex(tx.getNonce());
        this.blockHash = TypeConverter.toJsonHex(b.getHash());
        this.blockNumber = TypeConverter.toJsonHex(b.getNumber());
        this.transactionIndex = TypeConverter.toJsonHex(index);
        this.from = TypeConverter.toJsonHex(tx.getSender());
        this.to = tx.getReceiveAddress() == null ? null : TypeConverter.toJsonHex(tx.getReceiveAddress());
        this.gas = TypeConverter.toJsonHex(tx.getGasLimit());
        this.gasPrice = TypeConverter.toJsonHex(tx.getGasPrice());
        this.value = TypeConverter.toJsonHex(tx.getValue());
        this.input = tx.getData() != null ? TypeConverter.toJsonHex(tx.getData()) : null;
    }

    public String toString() {
        return "TransactionResultDTO{hash='" + this.hash + '\'' + ", nonce='" + this.nonce + '\'' + ", blockHash='" + this.blockHash + '\'' + ", blockNumber='" + this.blockNumber + '\'' + ", transactionIndex='" + this.transactionIndex + '\'' + ", from='" + this.from + '\'' + ", to='" + this.to + '\'' + ", gas='" + this.gas + '\'' + ", gasPrice='" + this.gasPrice + '\'' + ", value='" + this.value + '\'' + ", input='" + this.input + '\'' + '}';
    }

    public String getHash() {
        return this.hash;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return this.gas;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public String getValue() {
        return this.value;
    }

    public String getInput() {
        return this.input;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionResultDTO)) {
            return false;
        }
        TransactionResultDTO other = (TransactionResultDTO)o;
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
            return false;
        }
        String this$blockHash = this.getBlockHash();
        String other$blockHash = other.getBlockHash();
        if (this$blockHash == null ? other$blockHash != null : !this$blockHash.equals(other$blockHash)) {
            return false;
        }
        String this$blockNumber = this.getBlockNumber();
        String other$blockNumber = other.getBlockNumber();
        if (this$blockNumber == null ? other$blockNumber != null : !this$blockNumber.equals(other$blockNumber)) {
            return false;
        }
        String this$transactionIndex = this.getTransactionIndex();
        String other$transactionIndex = other.getTransactionIndex();
        if (this$transactionIndex == null ? other$transactionIndex != null : !this$transactionIndex.equals(other$transactionIndex)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$gas = this.getGas();
        String other$gas = other.getGas();
        if (this$gas == null ? other$gas != null : !this$gas.equals(other$gas)) {
            return false;
        }
        String this$gasPrice = this.getGasPrice();
        String other$gasPrice = other.getGasPrice();
        if (this$gasPrice == null ? other$gasPrice != null : !this$gasPrice.equals(other$gasPrice)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        return !(this$input == null ? other$input != null : !this$input.equals(other$input));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        String $blockHash = this.getBlockHash();
        result = result * 59 + ($blockHash == null ? 43 : $blockHash.hashCode());
        String $blockNumber = this.getBlockNumber();
        result = result * 59 + ($blockNumber == null ? 43 : $blockNumber.hashCode());
        String $transactionIndex = this.getTransactionIndex();
        result = result * 59 + ($transactionIndex == null ? 43 : $transactionIndex.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $gas = this.getGas();
        result = result * 59 + ($gas == null ? 43 : $gas.hashCode());
        String $gasPrice = this.getGasPrice();
        result = result * 59 + ($gasPrice == null ? 43 : $gasPrice.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        return result;
    }
}

