/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testrpcj;

import com.googlecode.jsonrpc4j.spring.JsonServiceExporter;
import io.iconator.testrpcj.jsonrpc.EthJsonRpcImpl;
import io.iconator.testrpcj.jsonrpc.JsonRpc;
import org.ethereum.config.SystemProperties;
import org.ethereum.crypto.ECKey;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.blockchain.EtherUtil;
import org.ethereum.util.blockchain.StandaloneBlockchain;
import org.spongycastle.util.encoders.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class TestBlockchain {
    @Autowired
    private StandaloneBlockchain standaloneBlockchain;
    public static final ECKey ACCOUNT_0;
    public static final ECKey ACCOUNT_1;
    public static final ECKey ACCOUNT_2;
    public static final ECKey ACCOUNT_3;
    public static final ECKey ACCOUNT_4;
    public static final ECKey ACCOUNT_5;
    public static final ECKey ACCOUNT_6;
    public static final ECKey ACCOUNT_7;
    public static final ECKey ACCOUNT_8;
    public static final ECKey ACCOUNT_9;

    public static void main(String[] args) {
        new TestBlockchain().start(args);
    }

    public void start(String[] args) {
        try {
            SpringApplication.run(TestBlockchain.class, (String[])args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void start() {
        this.start(new String[0]);
    }

    public static SolidityCompiler compiler() {
        return new SolidityCompiler(SystemProperties.getDefault());
    }

    @Bean
    public StandaloneBlockchain createStandaloneBlockchain() {
        return new StandaloneBlockchain().withAccountBalance(ACCOUNT_0.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_1.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_2.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_3.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_4.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_5.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_6.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_7.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_8.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAccountBalance(ACCOUNT_9.getAddress(), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER)).withAutoblock(true);
    }

    @Bean(name={"/rpc"})
    public JsonServiceExporter jsonServiceExporter() {
        JsonServiceExporter exporter = new JsonServiceExporter();
        exporter.setService((Object)new EthJsonRpcImpl(this.standaloneBlockchain));
        exporter.setServiceInterface(JsonRpc.class);
        return exporter;
    }

    static {
        System.setProperty("spring.config.name", "testrpcj.application");
        ACCOUNT_0 = ECKey.fromPrivate((byte[])Hex.decode((String)"1b865950b17a065c79b11ecb39650c377b4963d6387b2fb97d71744b89a7295e"));
        ACCOUNT_1 = ECKey.fromPrivate((byte[])Hex.decode((String)"c77ee832f3e5d7624ce9dab0eeb2958ad550e534952b79bb705e63b3989d4d1d"));
        ACCOUNT_2 = ECKey.fromPrivate((byte[])Hex.decode((String)"ba7ffe9dee14b3626211b2d056eacc30e7a634f7e11eeb4dde6ee6d50d0c81ab"));
        ACCOUNT_3 = ECKey.fromPrivate((byte[])Hex.decode((String)"64b1a16bb773bc2a6665967923cfd68f369e34f66ecd19c302995f8635598b1c"));
        ACCOUNT_4 = ECKey.fromPrivate((byte[])Hex.decode((String)"399c34e860be1f2740297fcadd3546fdd4f5ba4c06d13882da1e48527df3acca"));
        ACCOUNT_5 = ECKey.fromPrivate((byte[])Hex.decode((String)"a2a3abebd9160a2b2940970d848161008e3ea528aeaa927fb8b8370d3675f5f5"));
        ACCOUNT_6 = ECKey.fromPrivate((byte[])Hex.decode((String)"e728d9667a27b7f6164309fc3809c00fd8d782d9343c0b73ea1f5a150ec3d05b"));
        ACCOUNT_7 = ECKey.fromPrivate((byte[])Hex.decode((String)"d58fd771caefbdcca0c23fbc440fd03dacdee29cc4668cc9fc5acf29b4219f41"));
        ACCOUNT_8 = ECKey.fromPrivate((byte[])Hex.decode((String)"649f638d220fd6319ca4af8f5e0e261d15a66172830077126fef21fdbdd95410"));
        ACCOUNT_9 = ECKey.fromPrivate((byte[])Hex.decode((String)"ea8f71fc4690e0733f3478c3d8e53790988b9e51deabd10185364bc59c58fdba"));
    }
}

