/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator;

import io.iconator.testonator.Contract;
import io.iconator.testonator.ConvertException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ethereum.core.CallTransaction;
import org.ethereum.crypto.cryptohash.Keccak256;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.generated.AbiTypes;
import org.web3j.abi.datatypes.generated.Uint160;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.utils.Numeric;

public class Utils {
    public static Function createFunction(Contract contract, String name, Object ... input) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ConvertException {
        for (CallTransaction.Function f : contract.functions()) {
            if (f == null || !f.name.equals(name) || f.inputs.length != input.length) continue;
            ArrayList inputParameters = new ArrayList();
            int len = f.inputs.length;
            for (int i = 0; i < len; ++i) {
                CallTransaction.Param p = f.inputs[i];
                org.web3j.abi.datatypes.Type<?> t = Utils.convertTypes(p.getType(), input[i]);
                inputParameters.add(t);
            }
            ArrayList<TypeReference<org.web3j.abi.datatypes.Type>> outputParameters = new ArrayList<TypeReference<org.web3j.abi.datatypes.Type>>();
            for (CallTransaction.Param p : f.outputs) {
                TypeReference<org.web3j.abi.datatypes.Type> t = Utils.getType(p.getType());
                outputParameters.add(t);
            }
            return new Function(name, inputParameters, outputParameters);
        }
        return null;
    }

    public static Map<Integer, TypeReference<org.web3j.abi.datatypes.Type>> createEventIndexed(CallTransaction.Function f, boolean indexed) {
        LinkedHashMap<Integer, TypeReference<org.web3j.abi.datatypes.Type>> outputParameters = new LinkedHashMap<Integer, TypeReference<org.web3j.abi.datatypes.Type>>();
        int len = f.inputs.length;
        for (int i = 0; i < len; ++i) {
            CallTransaction.Param p = f.inputs[i];
            if (p.indexed ^ indexed) continue;
            TypeReference<org.web3j.abi.datatypes.Type> t = Utils.getType(p.getType());
            outputParameters.put(i, t);
        }
        return outputParameters;
    }

    public static org.web3j.abi.datatypes.Type<?> convertTypes(String type, Object param) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ConvertException {
        if (type.contains("[]")) {
            if (!(param instanceof List)) {
                throw new ConvertException("expected List for an array type got " + param.getClass());
            }
            ArrayList retVal = new ArrayList();
            Class<?> c = null;
            for (Object o : (List)param) {
                org.web3j.abi.datatypes.Type<?> value = Utils.convertTypes(type.replace("[]", ""), o);
                retVal.add(value);
                if (c == null) {
                    c = value.getClass();
                    continue;
                }
                if (c == value.getClass()) continue;
                throw new RuntimeException("needs to be the same type, initial type was: " + c + ". Now we have: " + type.getClass());
            }
            return new DynamicArray(c, retVal);
        }
        Class c = AbiTypes.getType((String)type);
        if (type.startsWith("uint") || type.startsWith("int")) {
            if (!(param instanceof Integer || param instanceof Long || param instanceof BigInteger)) {
                throw new ConvertException("expected Long or BigInteger for uint, but got " + param.getClass());
            }
        } else if (type.startsWith("bytes")) {
            if (!(param instanceof byte[]) && !(param instanceof String)) {
                throw new ConvertException("expected byte[] for bytes*, but got " + param.getClass());
            }
        } else if (type.startsWith("address")) {
            if (!(param instanceof Uint160 || param instanceof BigInteger || param instanceof String || param instanceof Address)) {
                throw new ConvertException("expected Uint160, BigInteger, String, or Address for address, but got " + param.getClass());
            }
        } else if (type.startsWith("bool")) {
            if (!(param instanceof Boolean)) {
                throw new ConvertException("expected Boolean for bool, but got " + param.getClass());
            }
        } else if (type.startsWith("string")) {
            if (!(param instanceof String)) {
                throw new ConvertException("expected String for string, but got " + param.getClass());
            }
        } else {
            throw new ConvertException("expected something known, this is unkown " + type);
        }
        if (param instanceof Integer) {
            return (org.web3j.abi.datatypes.Type)c.getDeclaredConstructor(Long.TYPE).newInstance(((Integer)param).longValue());
        }
        if (param instanceof Long) {
            return (org.web3j.abi.datatypes.Type)c.getDeclaredConstructor(Long.TYPE).newInstance((long)((Long)param));
        }
        if (param instanceof Boolean) {
            return (org.web3j.abi.datatypes.Type)c.getDeclaredConstructor(Boolean.TYPE).newInstance((boolean)((Boolean)param));
        }
        if (param instanceof String && type.startsWith("bytes")) {
            return (org.web3j.abi.datatypes.Type)c.getDeclaredConstructor(byte[].class).newInstance(new Object[]{Numeric.hexStringToByteArray((String)((String)param))});
        }
        return (org.web3j.abi.datatypes.Type)c.getDeclaredConstructor(param.getClass()).newInstance(param);
    }

    public static TypeReference<org.web3j.abi.datatypes.Type> getType(final String type) {
        if (type.endsWith("[]")) {
            return new TypeReference<org.web3j.abi.datatypes.Type>(){

                public Type getType() {
                    return new ParameterizedType(){

                        @Override
                        public Type getRawType() {
                            return DynamicArray.class;
                        }

                        @Override
                        public Type getOwnerType() {
                            return null;
                        }

                        @Override
                        public Type[] getActualTypeArguments() {
                            return new Type[]{AbiTypes.getType((String)type.replace("[]", ""))};
                        }
                    };
                }
            };
        }
        return TypeReference.create((Class)AbiTypes.getType((String)type));
    }

    public static String encodeParameters(int offsetUint256, org.web3j.abi.datatypes.Type ... objects) {
        ArrayList<Object> params = new ArrayList<Object>(objects.length + offsetUint256);
        for (int i = 0; i < offsetUint256; ++i) {
            params.add(new Uint256(0L));
        }
        for (org.web3j.abi.datatypes.Type t : objects) {
            params.add(t);
        }
        String encoded = FunctionEncoder.encodeConstructor(params);
        return encoded.substring(offsetUint256 * 64);
    }

    public static org.web3j.abi.datatypes.Type createArray(org.web3j.abi.datatypes.Type ... types) {
        ArrayList<org.web3j.abi.datatypes.Type> tmp = new ArrayList<org.web3j.abi.datatypes.Type>(types.length);
        Class<?> c = null;
        for (org.web3j.abi.datatypes.Type type : types) {
            tmp.add(type);
            if (c == null) {
                c = type.getClass();
                continue;
            }
            if (c == type.getClass()) continue;
            throw new RuntimeException("needs to be the same type, initial type was: " + c + ". Now we have: " + type.getClass());
        }
        return new DynamicArray(c, tmp);
    }

    public static String functionHash(String abiSig) {
        byte[] hash = new Keccak256().digest(abiSig.getBytes());
        byte[] name = new byte[4];
        System.arraycopy(hash, 0, name, 0, 4);
        return Numeric.toHexString((byte[])name);
    }
}

