/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator;

import io.iconator.testonator.Cb;
import io.iconator.testonator.Contract;
import io.iconator.testonator.ConvertException;
import io.iconator.testonator.DeployedContract;
import io.iconator.testonator.TestBlockchain;
import io.iconator.testonator.TestUtils;
import io.iconator.testonator.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes4;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class TestTransferAndCallPreSigned {
    private static TestBlockchain blockchain;
    private static Map<String, Contract> contracts;
    private static final char[] hexArray;

    @BeforeClass
    public static void setup() throws Exception {
        blockchain = TestBlockchain.runLocal();
        contracts = TestUtils.setup();
        File contractFile1 = Paths.get(ClassLoader.getSystemResource("Inventory.sol").toURI()).toFile();
        Map testContracts1 = TestBlockchain.compile((File)contractFile1);
        contracts.putAll(testContracts1);
        File contractFile2 = Paths.get(ClassLoader.getSystemResource("HashTest.sol").toURI()).toFile();
        Map testContracts2 = TestBlockchain.compile((File)contractFile2);
        contracts.putAll(testContracts2);
        File contractFile3 = Paths.get(ClassLoader.getSystemResource("RecoverTests.sol").toURI()).toFile();
        Map testContracts3 = TestBlockchain.compile((File)contractFile3);
        contracts.putAll(testContracts3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        blockchain.shutdown();
    }

    @After
    public void afterTests() {
        blockchain.reset();
    }

    @Test
    public void testBytesConversion() {
        byte[] s = Numeric.toBytesPadded((BigInteger)BigInteger.ONE, (int)32);
        BigInteger result = Numeric.toBigInt((byte[])s);
        Assert.assertEquals((Object)result, (Object)BigInteger.ONE);
        Random r = new Random(42L);
        for (int i = 0; i < 1000; ++i) {
            BigInteger input = new BigInteger(r.nextInt(256), r);
            s = Numeric.toBytesPadded((BigInteger)input, (int)32);
            result = Numeric.toBigInt((byte[])s);
            Assert.assertEquals((Object)result, (Object)input);
        }
    }

    @Test
    public void testNumberConversion() {
        for (int i = 0; i < 1000; ++i) {
            Sign.SignatureData sigData = Sign.signMessage((byte[])("yes" + i).getBytes(), (ECKeyPair)TestBlockchain.CREDENTIAL_0.getEcKeyPair(), (boolean)true);
            BigInteger HALF_CURVE_ORDER = Sign.CURVE_PARAMS.getN().shiftRight(1);
            if (Numeric.toBigInt((byte[])sigData.getS()).compareTo(HALF_CURVE_ORDER) != 1) continue;
            Assert.fail((String)"high S");
        }
    }

    @Test
    public void testMalleability() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployedHash = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("RecoverTests"));
        String hash = Hash.sha3((String)"0x123");
        Sign.SignatureData sigData = Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)hash), (ECKeyPair)TestBlockchain.CREDENTIAL_0.getEcKeyPair(), (boolean)false);
        byte[] sig = new byte[65];
        System.arraycopy(sigData.getR(), 0, sig, 0, 32);
        System.arraycopy(sigData.getS(), 0, sig, 32, 32);
        sig[64] = sigData.getV();
        List ret = blockchain.callConstant(deployedHash, "recoverMalleable", new Object[]{Numeric.hexStringToByteArray((String)hash), sig});
        Assert.assertEquals((Object)"0x3572f8c373c15df4042d38c1b3b67d70429ca65a", (Object)((Type)ret.get(0)).getValue());
        sig[64] = 0;
        ret = blockchain.callConstant(deployedHash, "recoverMalleable", new Object[]{Numeric.hexStringToByteArray((String)hash), sig});
        Assert.assertEquals((Object)"0x3572f8c373c15df4042d38c1b3b67d70429ca65a", (Object)((Type)ret.get(0)).getValue());
        sig[64] = 0;
        ret = blockchain.callConstant(deployedHash, "recover", new Object[]{Numeric.hexStringToByteArray((String)hash), sig});
        Assert.assertEquals((Object)"0x0000000000000000000000000000000000000000", (Object)((Type)ret.get(0)).getValue());
        BigInteger upper = Numeric.toBigInt((String)"0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141");
        BigInteger s = Numeric.toBigInt((byte[])sigData.getS());
        BigInteger s2 = upper.subtract(s);
        System.arraycopy(sigData.getR(), 0, sig, 0, 32);
        System.arraycopy(Numeric.toBytesPadded((BigInteger)s2, (int)32), 0, sig, 32, 32);
        sig[64] = 1;
        ret = blockchain.callConstant(deployedHash, "recoverMalleable", new Object[]{Numeric.hexStringToByteArray((String)hash), sig});
        Assert.assertEquals((Object)"0x3572f8c373c15df4042d38c1b3b67d70429ca65a", (Object)((Type)ret.get(0)).getValue());
        ret = blockchain.callConstant(deployedHash, "recover", new Object[]{Numeric.hexStringToByteArray((String)hash), sig});
        Assert.assertEquals((Object)"0x0000000000000000000000000000000000000000", (Object)((Type)ret.get(0)).getValue());
    }

    @Test
    public void testTransferPreSignedHash() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployedHash = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("HashTest"));
        String s1 = TestTransferAndCallPreSigned.padRight("15420b71") + TestTransferAndCallPreSigned.pad32(Numeric.toBigInt((String)TestBlockchain.CREDENTIAL_0.getAddress())) + TestTransferAndCallPreSigned.pad32(Numeric.toBigInt((String)TestBlockchain.CREDENTIAL_1.getAddress())) + TestTransferAndCallPreSigned.pad32(new BigInteger("500")) + TestTransferAndCallPreSigned.pad32(new BigInteger("1")) + TestTransferAndCallPreSigned.pad32(new BigInteger("2"));
        String keccak1 = Hash.sha3((String)s1);
        String encoded = Utils.encodeParameters((int)0, (Type[])new Type[]{new Bytes4(Numeric.hexStringToByteArray((String)"0x15420b71")), new Address(TestBlockchain.CREDENTIAL_0.getAddress()), new Address(TestBlockchain.CREDENTIAL_1.getAddress()), new Uint256(new BigInteger("500")), new Uint256(new BigInteger("1")), new Uint256(new BigInteger("2"))});
        String keccak2 = Hash.sha3((String)encoded);
        List ret = blockchain.callConstant(deployedHash, "transferPreSignedHashing", new Object[]{TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), 500, 1, 2});
        Assert.assertEquals((Object)keccak2, (Object)keccak1);
        Assert.assertEquals((Object)keccak1, (Object)Numeric.toHexString((byte[])((byte[])((Type)ret.get(0)).getValue())));
    }

    @Test
    public void testTransferAndCallPreSignedHashing() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployedHash = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("HashTest"));
        Bytes4 b4 = new Bytes4(Numeric.hexStringToByteArray((String)"0x12345667"));
        Random r = new Random(42L);
        byte[] bb = new byte[1000];
        r.nextBytes(bb);
        String encoded = Utils.encodeParameters((int)0, (Type[])new Type[]{new Bytes4(Numeric.hexStringToByteArray((String)"0x38980f82")), new Address(TestBlockchain.CREDENTIAL_0.getAddress()), new Address(TestBlockchain.CREDENTIAL_1.getAddress()), new Uint256(new BigInteger("500")), new Uint256(new BigInteger("1")), new Uint256(new BigInteger("2")), b4, new DynamicBytes(bb)});
        String keccak2 = Hash.sha3((String)encoded);
        List ret = blockchain.callConstant(deployedHash, "transferAndCallPreSignedHashing", new Object[]{TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), 500, 1, 2, b4.getValue(), bb});
        Assert.assertEquals((Object)keccak2, (Object)Numeric.toHexString((byte[])((byte[])((Type)ret.get(0)).getValue())));
    }

    @Test
    public void testTransferPreSigned() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 1000, 10);
        String encoded = Utils.encodeParameters((int)0, (Type[])new Type[]{new Bytes4(Numeric.hexStringToByteArray((String)"0x15420b71")), new Address(deployed.contractAddress()), new Address(TestBlockchain.CREDENTIAL_1.getAddress()), new Uint256(new BigInteger("9999")), new Uint256(new BigInteger("1")), new Uint256(new BigInteger("2"))});
        String keccak = Hash.sha3((String)encoded);
        System.out.println("hash:" + keccak);
        Sign.SignatureData sigData = Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)keccak), (ECKeyPair)TestBlockchain.CREDENTIAL_0.getEcKeyPair(), (boolean)false);
        byte[] sig = new byte[65];
        System.arraycopy(sigData.getR(), 0, sig, 0, 32);
        System.arraycopy(sigData.getS(), 0, sig, 32, 32);
        sig[64] = sigData.getV();
        List event = blockchain.call(TestBlockchain.CREDENTIAL_3, deployed, "transferPreSigned", new Object[]{sig, TestBlockchain.CREDENTIAL_1.getAddress(), new BigInteger("9999"), new BigInteger("1"), new BigInteger("2")});
        List ret = blockchain.callConstant(deployed, "balanceOf", new Object[]{TestBlockchain.CREDENTIAL_3.getAddress()});
        Assert.assertEquals((Object)new BigInteger("1"), (Object)((Type)ret.get(0)).getValue());
        ret = blockchain.callConstant(deployed, "balanceOf", new Object[]{TestBlockchain.CREDENTIAL_0.getAddress()});
        Assert.assertEquals((Object)new BigInteger("0"), (Object)((Type)ret.get(0)).getValue());
        ret = blockchain.callConstant(deployed, "balanceOf", new Object[]{TestBlockchain.CREDENTIAL_1.getAddress()});
        Assert.assertEquals((Object)new BigInteger("10999"), (Object)((Type)ret.get(0)).getValue());
    }

    @Test
    public void testTransferAndCallPreSigned() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        DeployedContract deployedInventory = blockchain.deploy(TestBlockchain.CREDENTIAL_5, contracts.get("Inventory").constructor(Cb.constructor((String)"address", (Object)deployed.contractAddress())));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 1000, 10, deployedInventory.contractAddress());
        String invParam = Utils.encodeParameters((int)2, (Type[])new Type[]{new Utf8String("serial"), new Utf8String("description")});
        byte[] b4 = Numeric.hexStringToByteArray((String)"0x5c28b451");
        byte[] args = Numeric.hexStringToByteArray((String)invParam);
        String encoded = Utils.encodeParameters((int)0, (Type[])new Type[]{new Bytes4(Numeric.hexStringToByteArray((String)"0x38980f82")), new Address(deployed.contractAddress()), new Address(deployedInventory.contractAddress()), new Uint256(new BigInteger("1")), new Uint256(new BigInteger("1")), new Uint256(new BigInteger("2")), new Bytes4(b4), new DynamicBytes(args)});
        String keccak = Hash.sha3((String)encoded);
        System.out.println("hash:" + keccak);
        Sign.SignatureData sigData = Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)keccak), (ECKeyPair)TestBlockchain.CREDENTIAL_1.getEcKeyPair(), (boolean)false);
        byte[] sig = new byte[65];
        System.arraycopy(sigData.getR(), 0, sig, 0, 32);
        System.arraycopy(sigData.getS(), 0, sig, 32, 32);
        sig[64] = sigData.getV();
        List event = blockchain.call(TestBlockchain.CREDENTIAL_3, deployed, "transferAndCallPreSigned", new Object[]{sig, deployedInventory.contractAddress(), new BigInteger("1"), new BigInteger("1"), new BigInteger("2"), b4, args});
        List ret = blockchain.callConstant(deployed, "balanceOf", new Object[]{TestBlockchain.CREDENTIAL_3.getAddress()});
        Assert.assertEquals((Object)new BigInteger("1"), (Object)((Type)ret.get(0)).getValue());
        ret = blockchain.callConstant(deployed, "balanceOf", new Object[]{TestBlockchain.CREDENTIAL_0.getAddress()});
        Assert.assertEquals((Object)new BigInteger("10000"), (Object)((Type)ret.get(0)).getValue());
        ret = blockchain.callConstant(deployed, "balanceOf", new Object[]{TestBlockchain.CREDENTIAL_1.getAddress()});
        Assert.assertEquals((Object)new BigInteger("998"), (Object)((Type)ret.get(0)).getValue());
        ret = blockchain.callConstant(deployed, "balanceOf", new Object[]{deployedInventory.contractAddress()});
        Assert.assertEquals((Object)new BigInteger("1"), (Object)((Type)ret.get(0)).getValue());
        ret = blockchain.callConstant(deployedInventory, "itemSerialAt", new Object[]{TestBlockchain.CREDENTIAL_1.getAddress(), 0});
        Assert.assertEquals((Object)"serial", (Object)((Type)ret.get(0)).getValue());
        blockchain.call(TestBlockchain.CREDENTIAL_5, deployedInventory, "payout", new Object[]{TestBlockchain.CREDENTIAL_6.getAddress()});
        ret = blockchain.callConstant(deployed, "balanceOf", new Object[]{TestBlockchain.CREDENTIAL_6.getAddress()});
        Assert.assertEquals((Object)new BigInteger("1"), (Object)((Type)ret.get(0)).getValue());
    }

    private static String padRight(String big) {
        return big + "0000000000000000000000000000000000000000000000000000000000000000".substring(0, 64 - big.length());
    }

    private static String pad32(BigInteger big) {
        return Numeric.toHexStringNoPrefixZeroPadded((BigInteger)big, (int)64);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        hexArray = "0123456789ABCDEF".toCharArray();
    }
}

