/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator;

import io.iconator.testonator.Builder;
import io.iconator.testonator.Contract;
import io.iconator.testonator.ConvertException;
import io.iconator.testonator.DeployedContract;
import io.iconator.testonator.Event;
import io.iconator.testonator.Fb;
import io.iconator.testonator.TestBlockchain;
import io.iconator.testonator.TestUtils;
import io.iconator.testonator.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.utils.Numeric;

public class TestTransferAndCall {
    private static TestBlockchain blockchain;
    private static Map<String, Contract> contracts;

    @BeforeClass
    public static void setup() throws Exception {
        blockchain = TestBlockchain.runLocal();
        contracts = TestUtils.setup();
        File contractFile = Paths.get(ClassLoader.getSystemResource("TestSomeContract.sol").toURI()).toFile();
        Map testContracts = TestBlockchain.compile((File)contractFile);
        contracts.putAll(testContracts);
        contractFile = Paths.get(ClassLoader.getSystemResource("EncodingTest.sol").toURI()).toFile();
        testContracts = TestBlockchain.compile((File)contractFile);
        contracts.putAll(testContracts);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        blockchain.shutdown();
    }

    @After
    public void afterTests() {
        blockchain.reset();
    }

    @Test
    public void testEncoding() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract dcEncoding = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("EncodingTest"));
        byte[] methodName = Numeric.hexStringToByteArray((String)"0x75b7e9f9");
        String encoded = Utils.encodeParameters((int)2, (Type[])new Type[]{new DynamicBytes(Numeric.hexStringToByteArray((String)"0x30783235"))});
        byte[] arg = Numeric.hexStringToByteArray((String)encoded);
        List result = blockchain.call(dcEncoding, "encode", new Object[]{methodName, arg, TestBlockchain.CREDENTIAL_0.getAddress(), BigInteger.valueOf(99L)});
        System.out.println("FunctionSelector: " + Numeric.toHexString((byte[])methodName));
        System.out.println("FROM: " + TestBlockchain.CREDENTIAL_0.getAddress());
        System.out.println("VALUE: " + BigInteger.valueOf(99L));
        System.out.println("ARGS: " + encoded);
        Assert.assertEquals((long)2L, (long)result.size());
        DynamicBytes chain = (DynamicBytes)((Event)result.get(0)).values().get(0);
        DynamicBytes dezos = (DynamicBytes)((Event)result.get(1)).values().get(0);
        System.out.println("ChainSolution: " + Numeric.toHexString((byte[])chain.getValue()));
        System.out.println("DezosSolution: " + Numeric.toHexString((byte[])dezos.getValue()));
        byte[] expected = Numeric.hexStringToByteArray((String)"0x75b7e9f90000000000000000000000003572f8c373c15df4042d38c1b3b67d70429ca65a0000000000000000000000000000000000000000000000000000000000000063000000000000000000000000000000000000000000000000000000000000006000000000000000000000000000000000000000000000000000000000000000043078323500000000000000000000000000000000000000000000000000000000");
        Assert.assertArrayEquals((byte[])expected, (byte[])dezos.getValue());
    }

    @Test
    public void testCallNoArgs() throws InterruptedException, ExecutionException, IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException {
        DeployedContract dcDOS = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        DeployedContract dcTest = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("TestSomeContract"));
        dcDOS.addReferencedContract(dcTest.contract());
        this.mint(dcDOS, dcTest.contractAddress());
        String methodName = Utils.functionHash((String)"someName(address,uint256)");
        System.out.println("method name: " + methodName);
        List result = blockchain.call(TestBlockchain.CREDENTIAL_1, dcDOS, "transferAndCall", new Object[]{dcTest.contractAddress(), new BigInteger("100"), Numeric.hexStringToByteArray((String)methodName), new byte[0]});
        Assert.assertEquals((long)3L, (long)result.size());
        System.out.println(result.size());
        blockchain.call(dcDOS, "removeWhitelist", new Object[]{dcTest.contractAddress()});
        result = blockchain.call(TestBlockchain.CREDENTIAL_1, dcDOS, "transferAndCall", new Object[]{dcTest.contractAddress(), new BigInteger("100"), Numeric.hexStringToByteArray((String)methodName), new byte[0]});
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testCallSimpleArgs() throws InterruptedException, ExecutionException, IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException {
        DeployedContract dcDOS = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        DeployedContract dcTest = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("TestSomeContract"));
        dcDOS.addReferencedContract(dcTest.contract());
        this.mint(dcDOS, dcTest.contractAddress());
        String methodName = Utils.functionHash((String)"someName(address,uint256,uint256)");
        System.out.println("method name: " + methodName);
        String encoded = Utils.encodeParameters((int)2, (Type[])new Type[]{new Uint256(new BigInteger("12345"))});
        System.out.println("parameters: " + encoded);
        List result = blockchain.call(TestBlockchain.CREDENTIAL_1, dcDOS, "transferAndCall", new Object[]{dcTest.contractAddress(), new BigInteger("100"), Numeric.hexStringToByteArray((String)methodName), Numeric.hexStringToByteArray((String)encoded)});
        Assert.assertEquals((long)3L, (long)result.size());
        Uint256 u1 = (Uint256)((Event)result.get(2)).values().get(2);
        Uint256 u2 = (Uint256)((Event)result.get(2)).values().get(3);
        Assert.assertEquals((Object)new Uint256(new BigInteger("100")).getValue(), (Object)u1.getValue());
        Assert.assertEquals((Object)new Uint256(new BigInteger("12345")).getValue(), (Object)u2.getValue());
        System.out.println(result.size());
    }

    @Test
    public void testCallComplexArgs() throws InterruptedException, ExecutionException, IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException {
        DeployedContract dcDOS = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        DeployedContract dcTest = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("TestSomeContract"));
        dcDOS.addReferencedContract(dcTest.contract());
        this.mint(dcDOS, dcTest.contractAddress());
        String methodName = Utils.functionHash((String)"someName(address,uint256,bool,string,address[])");
        System.out.println("method name: " + methodName);
        ArrayList params = new ArrayList();
        String encoded = Utils.encodeParameters((int)2, (Type[])new Type[]{new Bool(true), new Utf8String("testme"), Utils.createArray((Type[])new Type[]{new Address(TestBlockchain.CREDENTIAL_2.getAddress()), new Address(TestBlockchain.CREDENTIAL_3.getAddress())})});
        System.out.println("parameters: " + encoded);
        List result = blockchain.call(TestBlockchain.CREDENTIAL_1, dcDOS, "transferAndCall", new Object[]{dcTest.contractAddress(), new BigInteger("100"), Numeric.hexStringToByteArray((String)methodName), Numeric.hexStringToByteArray((String)encoded)});
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"testme", (Object)((Type)((Event)result.get(2)).values().get(3)).toString().trim());
        System.out.println(result.size());
    }

    private void mint(DeployedContract dc, String whitelist) throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException, ConvertException {
        ArrayList<String> addresses = new ArrayList<String>();
        ArrayList<BigInteger> values = new ArrayList<BigInteger>();
        addresses.add(TestBlockchain.CREDENTIAL_1.getAddress());
        addresses.add(TestBlockchain.CREDENTIAL_2.getAddress());
        values.add(new BigInteger("20000"));
        values.add(new BigInteger("20000"));
        System.out.println(dc.contractAddress());
        List result1 = blockchain.call(dc, "mint", new Object[]{addresses, values});
        Assert.assertEquals((long)2L, (long)result1.size());
        Assert.assertEquals((Object)new BigInteger("20000"), (Object)((Type)((Event)result1.get(1)).values().get(2)).getValue());
        result1 = blockchain.call(dc, "setAdmin", new Object[]{TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress()});
        Assert.assertEquals((long)0L, (long)result1.size());
        if (whitelist != null) {
            result1 = blockchain.call(dc, "addWhitelist", new Object[]{whitelist});
            Assert.assertEquals((long)0L, (long)result1.size());
        }
        List result2 = blockchain.call(dc, "finishMinting", new Object[0]);
        Assert.assertEquals((long)0L, (long)result2.size());
        List result = blockchain.callConstant(dc, (Builder)Fb.name((String)"mintingDone").output(new String[]{"bool"}));
        Assert.assertEquals((Object)"true", (Object)((Type)result.get(0)).getValue().toString());
    }
}

