/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator;

import io.iconator.testonator.Builder;
import io.iconator.testonator.Cb;
import io.iconator.testonator.Contract;
import io.iconator.testonator.ConvertException;
import io.iconator.testonator.DeployedContract;
import io.iconator.testonator.Fb;
import io.iconator.testonator.TestBlockchain;
import io.iconator.testonator.TestUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.web3j.abi.datatypes.Type;

public class TestTransfer {
    private static TestBlockchain blockchain;
    private static Map<String, Contract> contracts;

    @BeforeClass
    public static void setup() throws Exception {
        blockchain = TestBlockchain.runLocal();
        contracts = TestUtils.setupSnapshot();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        blockchain.shutdown();
    }

    @After
    public void afterTests() {
        blockchain.reset();
    }

    @Test
    public void testTransfer() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("ERC20Snapshot"));
        DeployedContract deployedVoting = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("Voting").constructor(Cb.constructor((String)"address", (Object)deployed.contractAddress())));
        TestTransfer.mint(blockchain, deployed, deployedVoting);
        List retGetAddress = blockchain.callConstant(deployedVoting, (Builder)Fb.name((String)"getAddress").output(new String[]{"address"}));
        blockchain.call(deployedVoting, (Builder)Fb.name((String)"vote").input("bool", (Object)true));
        List ret = blockchain.callConstant(deployedVoting, (Builder)Fb.name((String)"yay").output(new String[]{"uint256"}));
        Assert.assertEquals((Object)"10000", (Object)((Type)ret.get(0)).getValue().toString());
        blockchain.call(deployed, (Builder)Fb.name((String)"transfer").input("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).input("uint256", (Object)new BigInteger("9999")).output(new String[]{"bool"}));
        blockchain.call(deployedVoting, (Builder)Fb.name((String)"vote").input("bool", (Object)true));
        ret = blockchain.callConstant(deployedVoting, (Builder)Fb.name((String)"yay").output(new String[]{"uint256"}));
        Assert.assertEquals((Object)"10001", (Object)((Type)ret.get(0)).getValue().toString());
        blockchain.call(deployed, (Builder)Fb.name((String)"transfer").input("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).input("uint256", (Object)new BigInteger("1")).output(new String[]{"bool"}));
        blockchain.call(deployedVoting, (Builder)Fb.name((String)"vote").input("bool", (Object)true));
        ret = blockchain.callConstant(deployedVoting, (Builder)Fb.name((String)"yay").output(new String[]{"uint256"}));
        Assert.assertEquals((Object)"10002", (Object)((Type)ret.get(0)).getValue().toString());
    }

    private static void mint(TestBlockchain blockchain, DeployedContract deployed, DeployedContract deployedVoting) throws NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException, InterruptedException, ExecutionException, IOException {
        blockchain.call(deployed, (Builder)Fb.name((String)"mint").input("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()));
    }
}

