/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator.jsonrpc;

import io.iconator.testonator.jsonrpc.JsonRpc;
import io.iconator.testonator.jsonrpc.TypeConverter;
import org.ethereum.core.Block;
import org.ethereum.core.TransactionInfo;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.vm.LogInfo;

public class TransactionReceiptDTO {
    public String transactionHash;
    public String transactionIndex;
    public String blockHash;
    public String blockNumber;
    public String from;
    public String to;
    public String cumulativeGasUsed;
    public String gasUsed;
    public String contractAddress;
    public JsonRpc.LogFilterElement[] logs;
    public String logsBloom;
    public String status;

    public TransactionReceiptDTO(Block block, TransactionInfo txInfo) {
        TransactionReceipt receipt = txInfo.getReceipt();
        this.transactionHash = TypeConverter.toJsonHex(receipt.getTransaction().getHash());
        this.transactionIndex = TypeConverter.toJsonHex(new Integer(txInfo.getIndex()).longValue());
        this.cumulativeGasUsed = TypeConverter.toJsonHex(receipt.getCumulativeGas());
        this.gasUsed = TypeConverter.toJsonHex(receipt.getGasUsed());
        this.contractAddress = TypeConverter.toJsonHexAddress(receipt.getTransaction().getContractAddress());
        this.from = TypeConverter.toJsonHexAddress(receipt.getTransaction().getSender());
        this.to = TypeConverter.toJsonHexAddress(receipt.getTransaction().getReceiveAddress());
        this.logs = new JsonRpc.LogFilterElement[receipt.getLogInfoList().size()];
        if (block != null) {
            this.blockNumber = TypeConverter.toJsonHex(block.getNumber());
            this.blockHash = TypeConverter.toJsonHex(txInfo.getBlockHash());
        } else {
            this.blockNumber = null;
            this.blockHash = null;
        }
        for (int i = 0; i < this.logs.length; ++i) {
            LogInfo logInfo = (LogInfo)receipt.getLogInfoList().get(i);
            this.logs[i] = new JsonRpc.LogFilterElement(logInfo, block, txInfo.getIndex(), txInfo.getReceipt().getTransaction(), i);
        }
        this.logsBloom = TypeConverter.toJsonHex(receipt.getBloomFilter().getData());
        this.status = receipt.isTxStatusOK() ? "0x1" : "0x0";
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getCumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    public String getGasUsed() {
        return this.gasUsed;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public JsonRpc.LogFilterElement[] getLogs() {
        return this.logs;
    }

    public String getLogsBloom() {
        return this.status;
    }

    public String getStatus() {
        return this.status;
    }
}

