/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import io.iconator.testonator.Contract;
import io.iconator.testonator.ConvertException;
import io.iconator.testonator.DeployedContract;
import io.iconator.testonator.Event;
import io.iconator.testonator.FunctionBuilder;
import io.iconator.testonator.RPCServlet;
import io.iconator.testonator.Utils;
import io.iconator.testonator.jsonrpc.AddContentTypeFilter;
import io.iconator.testonator.jsonrpc.EthJsonRpcImpl;
import io.iconator.testonator.jsonrpc.JsonRpc;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.ethereum.config.BlockchainConfig;
import org.ethereum.config.BlockchainNetConfig;
import org.ethereum.config.SystemProperties;
import org.ethereum.config.blockchain.ConstantinopleConfig;
import org.ethereum.config.blockchain.DaoHFConfig;
import org.ethereum.core.BlockHeader;
import org.ethereum.core.CallTransaction;
import org.ethereum.crypto.ECKey;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.blockchain.EtherUtil;
import org.ethereum.util.blockchain.StandaloneBlockchain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.ContractUtils;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthCompileSolidity;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.http.HttpService;
import org.web3j.utils.Files;
import org.web3j.utils.Numeric;

public class TestBlockchain {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockchain.class);
    private static final List<Credentials> credentials = new ArrayList<Credentials>(10);
    public static final Credentials CREDENTIAL_0 = TestBlockchain.fromECPrivateKey("1b865950b17a065c79b11ecb39650c377b4963d6387b2fb97d71744b89a7295e");
    public static final Credentials CREDENTIAL_1 = TestBlockchain.fromECPrivateKey("c77ee832f3e5d7624ce9dab0eeb2958ad550e534952b79bb705e63b3989d4d1d");
    public static final Credentials CREDENTIAL_2 = TestBlockchain.fromECPrivateKey("ba7ffe9dee14b3626211b2d056eacc30e7a634f7e11eeb4dde6ee6d50d0c81ab");
    public static final Credentials CREDENTIAL_3 = TestBlockchain.fromECPrivateKey("64b1a16bb773bc2a6665967923cfd68f369e34f66ecd19c302995f8635598b1c");
    public static final Credentials CREDENTIAL_4 = TestBlockchain.fromECPrivateKey("399c34e860be1f2740297fcadd3546fdd4f5ba4c06d13882da1e48527df3acca");
    public static final Credentials CREDENTIAL_5 = TestBlockchain.fromECPrivateKey("a2a3abebd9160a2b2940970d848161008e3ea528aeaa927fb8b8370d3675f5f5");
    public static final Credentials CREDENTIAL_6 = TestBlockchain.fromECPrivateKey("e728d9667a27b7f6164309fc3809c00fd8d782d9343c0b73ea1f5a150ec3d05b");
    public static final Credentials CREDENTIAL_7 = TestBlockchain.fromECPrivateKey("d58fd771caefbdcca0c23fbc440fd03dacdee29cc4668cc9fc5acf29b4219f41");
    public static final Credentials CREDENTIAL_8 = TestBlockchain.fromECPrivateKey("649f638d220fd6319ca4af8f5e0e261d15a66172830077126fef21fdbdd95410");
    public static final Credentials CREDENTIAL_9 = TestBlockchain.fromECPrivateKey("ea8f71fc4690e0733f3478c3d8e53790988b9e51deabd10185364bc59c58fdba");
    public static final Integer DEFAULT_PORT;
    public static final String DEFAULT_PATH = "/";
    private Server server = null;
    private StandaloneBlockchain standaloneBlockchain = null;
    private Web3j web3j;
    private ServletHolder holder;
    private Map<String, DeployedContract> cacheDeploy = new HashMap<String, DeployedContract>();
    private BigInteger gasPrice = BigInteger.valueOf(10000000000L);
    private BigInteger gasLimit = BigInteger.valueOf(5000000L);
    private int blockWaitTimeoutSeconds = 60;

    public static List<Credentials> credentials() {
        return credentials;
    }

    public static void clearCredentials() {
        credentials.clear();
    }

    public static void addCredentials(List<Credentials> credentials2) {
        credentials.addAll(credentials2);
    }

    public static void main(String[] args) throws Exception {
        TestBlockchain t = new TestBlockchain();
        t.startLocal();
        LOG.info("Server running.");
    }

    public TestBlockchain gasPrice(BigInteger gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    public BigInteger gasPrice() {
        return this.gasPrice;
    }

    public TestBlockchain gasLimit(BigInteger gasLimit) {
        this.gasLimit = gasLimit;
        return this;
    }

    public BigInteger gasLimit() {
        return this.gasLimit;
    }

    public TestBlockchain blockWaitTimeoutSeconds(int blockWaitTimeoutSeconds) {
        this.blockWaitTimeoutSeconds = blockWaitTimeoutSeconds;
        return this;
    }

    public int blockWaitTimeoutSeconds() {
        return this.blockWaitTimeoutSeconds;
    }

    @Deprecated
    public static TestBlockchain run() throws Exception {
        return TestBlockchain.runLocal();
    }

    @Deprecated
    public static TestBlockchain run(int port, String path) throws Exception {
        return TestBlockchain.runLocal(port, path);
    }

    public static TestBlockchain runLocal() throws Exception {
        return TestBlockchain.runLocal(DEFAULT_PORT, DEFAULT_PATH);
    }

    public static TestBlockchain runLocal(int port, String path) throws Exception {
        TestBlockchain t = new TestBlockchain();
        return t.startLocal(port, path);
    }

    public static TestBlockchain runRemote(String url) throws Exception {
        TestBlockchain t = new TestBlockchain();
        return t.startRemote(url);
    }

    @Deprecated
    public TestBlockchain start() throws Exception {
        return this.startLocal();
    }

    @Deprecated
    public TestBlockchain start(int port) throws Exception {
        return this.startLocal(port);
    }

    @Deprecated
    public TestBlockchain start(int port, String path) throws Exception {
        return this.startLocal(port, path);
    }

    @Deprecated
    public TestBlockchain start(int port, Web3j web3j, String path) throws Exception {
        return this.startLocal(port, web3j, path);
    }

    public TestBlockchain startLocal() throws Exception {
        return this.startLocal(DEFAULT_PORT, DEFAULT_PATH);
    }

    public TestBlockchain startLocal(int port) throws Exception {
        return this.startLocal(port, DEFAULT_PATH);
    }

    public TestBlockchain startLocal(int port, String path) throws Exception {
        return this.startLocal(port, Web3j.build((Web3jService)new HttpService("http://localhost:" + port + path)), path);
    }

    public TestBlockchain startRemote(String url) throws Exception {
        this.web3j = Web3j.build((Web3jService)new HttpService(url));
        return this;
    }

    public TestBlockchain startLocal(int port, Web3j web3j, String path) throws Exception {
        if (this.server != null) {
            this.stop();
        }
        this.web3j = web3j;
        this.server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(DEFAULT_PATH);
        this.server.setHandler((Handler)context);
        RPCServlet rpcServlet = this.createBlockchainServlet();
        this.holder = new ServletHolder((Servlet)rpcServlet);
        context.addServlet(this.holder, path);
        context.addFilter(AddContentTypeFilter.class, path, EnumSet.of(DispatcherType.REQUEST));
        this.server.start();
        return this;
    }

    public void shutdown() throws Exception {
        if (this.server != null) {
            this.stop();
        }
        if (this.web3j != null) {
            this.web3j.shutdown();
        }
    }

    private RPCServlet createBlockchainServlet() {
        this.standaloneBlockchain = new StandaloneBlockchain().withAutoblock(true).withNetConfig((BlockchainNetConfig)new ConstantinopleConfig((BlockchainConfig)new DaoHFConfig()){

            public BigInteger calcDifficulty(BlockHeader curBlock, BlockHeader parent) {
                return BigInteger.ONE;
            }
        });
        for (Credentials credentials : TestBlockchain.credentials) {
            this.standaloneBlockchain.withAccountBalance(Numeric.hexStringToByteArray((String)credentials.getAddress()), EtherUtil.convert((long)10L, (EtherUtil.Unit)EtherUtil.Unit.ETHER));
        }
        this.standaloneBlockchain.createBlock();
        EthJsonRpcImpl ethJsonRpcImpl = new EthJsonRpcImpl(this.standaloneBlockchain);
        for (Credentials credential : credentials) {
            ethJsonRpcImpl.addAccount(credential.getAddress().substring(2), ECKey.fromPrivate((BigInteger)credential.getEcKeyPair().getPrivateKey()));
        }
        JsonRpcServer jsonRpcServer = new JsonRpcServer(new ObjectMapper(), (Object)ethJsonRpcImpl, JsonRpc.class);
        return new RPCServlet(jsonRpcServer);
    }

    public void reset() {
        if (this.holder != null) {
            RPCServlet rpcServlet = this.createBlockchainServlet();
            this.holder.setServlet((Servlet)rpcServlet);
        }
        this.cacheDeploy.clear();
    }

    public TestBlockchain stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
        }
        this.server = null;
        this.standaloneBlockchain = null;
        this.cacheDeploy.clear();
        return this;
    }

    public Web3j web3j() {
        return this.web3j;
    }

    public BigInteger balance(Credentials credential) throws IOException, ExecutionException, InterruptedException {
        return ((EthGetBalance)this.web3j.ethGetBalance(credential.getAddress(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get()).getBalance();
    }

    public BigInteger balance(String address) throws IOException, ExecutionException, InterruptedException {
        return ((EthGetBalance)this.web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get()).getBalance();
    }

    public BigInteger nonce(Credentials credentials) throws IOException, ExecutionException, InterruptedException {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)this.web3j.ethGetTransactionCount(credentials.getAddress(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get();
        return ethGetTransactionCount.getTransactionCount();
    }

    public static Credentials fromECKey(ECKey ecKey) {
        BigInteger privKey = ecKey.getPrivKey();
        ECKeyPair pair = new ECKeyPair(privKey, Sign.publicKeyFromPrivate((BigInteger)privKey));
        return Credentials.create((ECKeyPair)pair);
    }

    public static Credentials fromECPrivateKey(String privateKey) {
        return TestBlockchain.fromECKey(ECKey.fromPrivate((byte[])org.spongycastle.util.encoders.Hex.decode((String)privateKey)));
    }

    @Deprecated
    public static Credentials create(ECKey ecKey) {
        return TestBlockchain.fromECKey(ecKey);
    }

    public List<Type> callConstant(DeployedContract contract, String name, Object ... parameters) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ExecutionException, InterruptedException, ConvertException {
        Function function = Utils.createFunction(contract.contract(), name, parameters);
        if (function == null) {
            throw new RuntimeException("could not create/find function with name: " + name);
        }
        return this.callConstant(contract.from() == null ? contract.owner() : contract.from(), contract.contractAddress(), function);
    }

    public List<Type> callConstant(Credentials credential, String contractAddress, FunctionBuilder functionBuilder) throws InterruptedException, ExecutionException, IOException {
        return this.callConstant(credential, contractAddress, functionBuilder.build());
    }

    public List<Type> callConstant(DeployedContract contract, FunctionBuilder functionBuilder) throws InterruptedException, ExecutionException, IOException {
        return this.callConstant(contract.from() == null ? contract.owner() : contract.from(), contract.contractAddress(), functionBuilder.build());
    }

    public List<Type> callConstant(Credentials credential, String contractAddress, Function function) throws IOException, ExecutionException, InterruptedException {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        EthCall ethCall = (EthCall)this.web3j.ethCall(Transaction.createEthCallTransaction((String)credential.getAddress(), (String)contractAddress, (String)encodedFunction), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get();
        if (ethCall.hasError()) {
            throw new IOException(ethCall.getError().toString());
        }
        String value = ethCall.getValue();
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    public List<Event> call(DeployedContract contract, String name, Object ... parameters) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, ExecutionException, InterruptedException, ConvertException {
        return this.call(contract.from() == null ? contract.owner() : contract.from(), contract, BigInteger.ZERO, name, parameters);
    }

    public List<Event> call(Credentials credential, DeployedContract contract, String name, Object ... parameters) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, ExecutionException, InterruptedException, ConvertException {
        Function function = Utils.createFunction(contract.contract(), name, parameters);
        return this.call(credential, contract, BigInteger.ZERO, function);
    }

    public List<Event> call(Credentials credential, DeployedContract contract, BigInteger weiValue, String name, Object ... parameters) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, ExecutionException, InterruptedException, ConvertException {
        Function function = Utils.createFunction(contract.contract(), name, parameters);
        return this.call(credential, contract, weiValue, function);
    }

    public List<Event> call(Credentials credential, DeployedContract contract, BigInteger weiValue) throws IOException, ExecutionException, InterruptedException {
        return this.call(credential, contract, weiValue, (Function)null);
    }

    public List<Event> call(Credentials credential, DeployedContract contract, BigInteger weiValue, FunctionBuilder functionBuilder) throws IOException, ExecutionException, InterruptedException {
        return this.call(credential, contract, weiValue, functionBuilder.build());
    }

    public List<Event> call(Credentials credential, DeployedContract contract, FunctionBuilder functionBuilder) throws IOException, ExecutionException, InterruptedException {
        return this.call(credential, contract, BigInteger.ZERO, functionBuilder.build());
    }

    public List<Event> call(DeployedContract contract, FunctionBuilder functionBuilder) throws IOException, ExecutionException, InterruptedException {
        return this.call(contract.from() == null ? contract.owner() : contract.from(), contract, BigInteger.ZERO, functionBuilder.build());
    }

    public List<Event> call(Credentials credential, DeployedContract contract, BigInteger weiValue, Function function) throws IOException, ExecutionException, InterruptedException {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        contracts.add(contract.contract());
        for (Contract c : contract.referencedContracts()) {
            contracts.add(c);
        }
        return this.call(credential, contract.contractAddress(), contracts, weiValue, function);
    }

    public List<Event> call(Credentials credential, String contractAddress, FunctionBuilder functionBuilder) throws IOException, ExecutionException, InterruptedException {
        return this.call(credential, contractAddress, new ArrayList<Contract>(), BigInteger.ZERO, functionBuilder.build());
    }

    public List<Event> call(Credentials credential, String contractAddress, BigInteger weiValue, FunctionBuilder functionBuilder) throws IOException, ExecutionException, InterruptedException {
        return this.call(credential, contractAddress, new ArrayList<Contract>(), weiValue, functionBuilder.build());
    }

    public List<Event> call(Credentials credential, String contractAddress, List<Contract> contracts, BigInteger weiValue, FunctionBuilder functionBuilder) throws IOException, ExecutionException, InterruptedException {
        return this.call(credential, contractAddress, contracts, weiValue, functionBuilder.build());
    }

    public void setTime(int timeSeconds) {
        this.standaloneBlockchain.withCurrentTime(new Date(timeSeconds * 1000));
        this.standaloneBlockchain.createBlock();
    }

    public List<Event> call(Credentials credential, String contractAddress, List<Contract> contracts, BigInteger weiValue, Function function) throws IOException, ExecutionException, InterruptedException {
        RawTransaction rawTransaction;
        BigInteger nonce = this.nonce(credential);
        if (function != null) {
            String encodedFunction = FunctionEncoder.encode((Function)function);
            rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)this.gasPrice, (BigInteger)this.gasLimit, (String)contractAddress, (BigInteger)weiValue, (String)encodedFunction);
        } else {
            rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)this.gasPrice, (BigInteger)this.gasLimit, (String)contractAddress, (BigInteger)weiValue);
        }
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credential);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction ret = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        if (ret.hasError()) {
            throw new IOException(ret.getError().getMessage());
        }
        EthGetTransactionReceipt receipt = null;
        long start = System.currentTimeMillis();
        while (start + (long)(this.blockWaitTimeoutSeconds * 1000) > System.currentTimeMillis() && (receipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(ret.getTransactionHash()).sendAsync().get()).getResult() == null) {
            Thread.sleep(250L);
        }
        if (receipt == null) {
            throw new IOException("waited for " + this.blockWaitTimeoutSeconds + ", did not get any reply back.");
        }
        if (!((TransactionReceipt)receipt.getResult()).isStatusOK()) {
            if (function != null) {
                LOG.warn("Function [{}] failed, wei: {}", (Object)function.getName(), (Object)weiValue);
            } else {
                LOG.warn("Function [] failed, wei: {}", (Object)weiValue);
            }
            return null;
        }
        ArrayList<Event> events = new ArrayList<Event>();
        for (Log log : ((TransactionReceipt)receipt.getResult()).getLogs()) {
            for (Contract c : contracts) {
                for (CallTransaction.Function f : c.functions()) {
                    for (String topic : log.getTopics()) {
                        if (!Hash.sha3String((String)f.formatSignature()).equals(topic)) continue;
                        Map<Integer, TypeReference<Type>> outputIndexed = Utils.createEventIndexed(f, true);
                        ArrayList<TypeReference<Type>> tmp = new ArrayList<TypeReference<Type>>(outputIndexed.values());
                        ArrayList<Type> valuesIndexed = new ArrayList<Type>(tmp.size());
                        int logTopicSize = log.getTopics().size();
                        if (logTopicSize != tmp.size() + 1) {
                            throw new IOException("did not get the right number of logs back: " + logTopicSize + DEFAULT_PATH + tmp.size());
                        }
                        if (!((String)log.getTopics().get(0)).equals(topic)) {
                            throw new IOException("did not get the right topic: [" + (String)log.getTopics().get(0) + "]/[" + topic + "]");
                        }
                        for (int j = 1; j < logTopicSize; ++j) {
                            valuesIndexed.add(FunctionReturnDecoder.decodeIndexedValue((String)((String)log.getTopics().get(j)), (TypeReference)((TypeReference)tmp.get(j - 1))));
                        }
                        Map<Integer, TypeReference<Type>> outputNonIndexed = Utils.createEventIndexed(f, false);
                        tmp = new ArrayList<TypeReference<Type>>(outputNonIndexed.values());
                        List valuesNonIndexed = FunctionReturnDecoder.decode((String)log.getData(), tmp);
                        ArrayList<Type> values = new ArrayList<Type>();
                        int len = valuesIndexed.size() + valuesNonIndexed.size();
                        for (int i = 0; i < len; ++i) {
                            if (outputIndexed.containsKey(i)) {
                                values.add((Type)valuesIndexed.remove(0));
                                continue;
                            }
                            if (outputNonIndexed.containsKey(i)) {
                                values.add((Type)valuesNonIndexed.remove(0));
                                continue;
                            }
                            throw new RuntimeException("cannot happen");
                        }
                        events.add(new Event(c, values, f.name, f.formatSignature(), topic));
                    }
                }
            }
        }
        return events;
    }

    public DeployedContract deploy(Credentials credential, Contract contract) throws IOException, ExecutionException, InterruptedException {
        return this.deploy(credential, contract, BigInteger.ZERO, Collections.emptyMap()).get(0);
    }

    public DeployedContract deploy(Credentials credential, String contractName, Map<String, Contract> contracts) throws InterruptedException, ExecutionException, IOException {
        return this.deploy(credential, contracts.get(contractName), contracts);
    }

    public DeployedContract deploy(Credentials credential, Contract contract, Map<String, Contract> contracts) throws IOException, ExecutionException, InterruptedException {
        return this.deploy(credential, contract, BigInteger.ZERO, contracts).get(0);
    }

    public List<DeployedContract> deploy(Credentials credential, Contract contract, BigInteger value, Map<String, Contract> contracts) throws IOException, ExecutionException, InterruptedException {
        return this.deploy(credential, contract, value, contracts, new ArrayList<DeployedContract>());
    }

    public List<DeployedContract> deploy(Credentials credential, Contract contract, BigInteger value, Map<String, Contract> contracts, List<DeployedContract> retVal) throws IOException, ExecutionException, InterruptedException {
        if (contract.code().getCode().contains("__")) {
            Pattern p = Pattern.compile("__<[^>]*>:([^_]*)[_]*__");
            Matcher m = p.matcher(contract.code().getCode());
            int prevStart = 0;
            StringBuilder sb = new StringBuilder();
            while (m.find(prevStart)) {
                String partOne = contract.code().getCode().substring(prevStart, m.start());
                sb.append(partOne);
                String depName = m.group(1);
                Contract dep = contracts.get(depName);
                if (dep == null) {
                    throw new RuntimeException("cannot find dependency: " + depName);
                }
                DeployedContract otherContract = this.cacheDeploy.get(depName);
                if (otherContract == null) {
                    otherContract = this.deploy(credential, dep, BigInteger.ZERO, contracts, retVal).get(retVal.size() - 1);
                    this.cacheDeploy.put(m.group(1), otherContract);
                }
                sb.append(otherContract.contractAddress().substring(2));
                prevStart = m.end();
            }
            sb.append(contract.code().getCode().substring(prevStart));
            contract.code().setCode(sb.toString());
            retVal.add(0, this.deploy(credential, contract, value).addAllReferencedContract(contracts.values()));
        } else {
            retVal.add(0, this.deploy(credential, contract, value).addAllReferencedContract(contracts.values()));
        }
        return retVal;
    }

    public DeployedContract deploy(Credentials credential, Contract contract, BigInteger value) throws IOException, ExecutionException, InterruptedException {
        BigInteger nonce = this.nonce(credential);
        RawTransaction rawTransaction = RawTransaction.createContractTransaction((BigInteger)nonce, (BigInteger)this.gasPrice, (BigInteger)this.gasLimit, (BigInteger)value, (String)contract.code().getCode());
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credential);
        String hexValue = Hex.toHexString((byte[])signedMessage);
        String contractAddress = ContractUtils.generateContractAddress((String)credential.getAddress(), (BigInteger)nonce);
        EthSendTransaction tx = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        EthGetTransactionReceipt receipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(tx.getTransactionHash()).sendAsync().get();
        LOG.info("Contract deployed at {}, {}", (Object)contractAddress, (Object)contract.code().getCode());
        return new DeployedContract(tx, contractAddress, credential, receipt, contract);
    }

    public static Map<String, Contract> compile(File source) throws IOException {
        SolidityCompiler.Result result = new SolidityCompiler(SystemProperties.getDefault()).compileSrc(source, true, true, new SolidityCompiler.Option[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE, SolidityCompiler.Options.METADATA});
        if (result.isFailed()) {
            throw new IOException(result.errors);
        }
        CompilationResult parsed = CompilationResult.parse((String)result.output);
        return TestBlockchain.compile(parsed);
    }

    public static Map<String, Contract> compile(File ... contracts) throws IOException {
        if (contracts.length == 0) {
            throw new RuntimeException("need files as input");
        }
        String contractSrc = Files.readString((File)contracts[0]);
        HashMap<String, String> dependencies = new HashMap<String, String>();
        for (int i = 1; i < contracts.length; ++i) {
            dependencies.put("./" + contracts[i].getName(), Files.readString((File)contracts[i]));
        }
        return TestBlockchain.compile(contractSrc, dependencies);
    }

    public static Map<String, Contract> compile(String contractSrc, Map<String, String> dependencies) throws IOException {
        Pattern p = Pattern.compile("\\s*import\\s*\"([^\"]*)\"\\s*;");
        Matcher m = p.matcher(contractSrc);
        StringBuilder sb = new StringBuilder();
        int prevStart = 0;
        while (m.find(prevStart)) {
            sb.append(contractSrc.substring(prevStart, m.start()));
            System.out.println("AA" + m.group(1) + " de " + dependencies.keySet());
            sb.append(TestBlockchain.stripPragma(dependencies.get(m.group(1))));
            prevStart = m.end();
        }
        sb.append(contractSrc.substring(prevStart));
        return TestBlockchain.compile(sb.toString());
    }

    private static String stripPragma(String contractSrc) {
        return contractSrc.replaceAll("\\s*pragma\\s*solidity.*;", "");
    }

    public static Map<String, Contract> compile(String contractSrc) throws IOException {
        new SolidityCompiler(SystemProperties.getDefault());
        SolidityCompiler.Result result = SolidityCompiler.compile((byte[])contractSrc.getBytes(), (boolean)true, (SolidityCompiler.Option[])new SolidityCompiler.Option[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE, SolidityCompiler.Options.METADATA});
        if (result.isFailed()) {
            throw new IOException(result.errors);
        }
        CompilationResult parsed = CompilationResult.parse((String)result.output);
        return TestBlockchain.compile(parsed);
    }

    private static Map<String, Contract> compile(CompilationResult parsed) throws IOException {
        HashMap<String, Contract> retVal = new HashMap<String, Contract>();
        for (String key : parsed.getContractKeys()) {
            String name = key.substring(key.lastIndexOf(58) + 1);
            CompilationResult.ContractMetadata meta = parsed.getContract(name);
            CallTransaction.Contract details = new CallTransaction.Contract(meta.abi);
            Contract contract = new Contract(new EthCompileSolidity.Code(meta.bin));
            for (CallTransaction.Function f : details.functions) {
                contract.addFunction(f);
            }
            retVal.put(name, contract);
        }
        return retVal;
    }

    static {
        credentials.add(CREDENTIAL_0);
        credentials.add(CREDENTIAL_1);
        credentials.add(CREDENTIAL_2);
        credentials.add(CREDENTIAL_3);
        credentials.add(CREDENTIAL_4);
        credentials.add(CREDENTIAL_5);
        credentials.add(CREDENTIAL_6);
        credentials.add(CREDENTIAL_7);
        credentials.add(CREDENTIAL_8);
        credentials.add(CREDENTIAL_9);
        DEFAULT_PORT = 8545;
    }
}

