/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator;

import io.iconator.testonator.Contract;
import io.iconator.testonator.ConvertException;
import io.iconator.testonator.DeployedContract;
import io.iconator.testonator.Event;
import io.iconator.testonator.FunctionBuilder;
import io.iconator.testonator.TestBlockchain;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.web3j.abi.datatypes.Type;

public class TestUtils {
    private static Map<String, Contract> contracts = null;
    private static Map<String, Contract> contractsSnapshot = null;

    public static Map<String, Contract> setup() throws Exception {
        if (contracts != null) {
            return contracts;
        }
        File contractFile1 = Paths.get(ClassLoader.getSystemResource("SafeMath.sol").toURI()).toFile();
        File contractFile2 = Paths.get(ClassLoader.getSystemResource("Utils.sol").toURI()).toFile();
        File contractFile3 = Paths.get(ClassLoader.getSystemResource("DOS.sol").toURI()).toFile();
        Map contracts = TestBlockchain.compile((File[])new File[]{contractFile3, contractFile1, contractFile2});
        Assert.assertEquals((long)5L, (long)contracts.size());
        for (String name : contracts.keySet()) {
            System.out.println("Available contract names: " + name);
        }
        TestUtils.contracts = contracts;
        return contracts;
    }

    public static Map<String, Contract> setupSnapshot() throws Exception {
        if (contractsSnapshot != null) {
            return contractsSnapshot;
        }
        File contractFile1 = Paths.get(ClassLoader.getSystemResource("ERC20Snapshot.sol").toURI()).toFile();
        File contractFile2 = Paths.get(ClassLoader.getSystemResource("Voting.sol").toURI()).toFile();
        Map contracts = TestBlockchain.compile((File)contractFile1);
        contracts.putAll(TestBlockchain.compile((File)contractFile2));
        Assert.assertEquals((long)3L, (long)contracts.size());
        for (String name : contracts.keySet()) {
            System.out.println("Available contract names: " + name);
        }
        contractsSnapshot = contracts;
        return contractsSnapshot;
    }

    public static void mint(TestBlockchain blockchain, DeployedContract deployed, String address1, String address2, String address3, int value1, int value2, int value3) throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        TestUtils.mint(blockchain, deployed, address1, address2, address3, value1, value2, value3, true);
    }

    public static void mint(TestBlockchain blockchain, DeployedContract deployed, String address1, String address2, String address3, int value1, int value2, int value3, boolean setFlag) throws NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException, InterruptedException, ExecutionException, IOException {
        ArrayList<String> addresses = new ArrayList<String>(3);
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(3);
        int counter = 0;
        if (value1 > 0) {
            addresses.add(address1);
            values.add(BigInteger.valueOf(value1));
            ++counter;
        }
        if (value2 > 0) {
            addresses.add(address2);
            values.add(BigInteger.valueOf(value2));
            ++counter;
        }
        if (value3 > 0) {
            addresses.add(address3);
            values.add(BigInteger.valueOf(value3));
            ++counter;
        }
        List events = blockchain.call(deployed, new FunctionBuilder("mint").addInput("address[]", addresses).addInput("uint256[]", values));
        Assert.assertEquals((long)counter, (long)events.size());
        if (value1 > 0) {
            Assert.assertEquals((Object)("" + value1), (Object)((Type)((Event)events.get(0)).values().get(2)).getValue().toString());
        }
        events = blockchain.call(deployed, new FunctionBuilder("setAdmin").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()));
        if (setFlag) {
            events = blockchain.call(deployed, new FunctionBuilder("finishMinting"));
            Assert.assertEquals((long)0L, (long)events.size());
            List result = blockchain.callConstant(deployed, new FunctionBuilder("mintingDone").outputs(new String[]{"bool"}));
            Assert.assertEquals((Object)"true", (Object)((Type)result.get(0)).getValue().toString());
        }
    }
}

