/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator;

import io.iconator.testonator.Contract;
import io.iconator.testonator.ConvertException;
import io.iconator.testonator.DeployedContract;
import io.iconator.testonator.FunctionBuilder;
import io.iconator.testonator.TestBlockchain;
import io.iconator.testonator.TestUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.web3j.abi.datatypes.Type;

public class TestSnapshot {
    private static TestBlockchain blockchain;
    private static Map<String, Contract> contracts;

    @BeforeClass
    public static void setup() throws Exception {
        blockchain = TestBlockchain.runLocal();
        contracts = TestUtils.setupSnapshot();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        blockchain.shutdown();
    }

    @After
    public void afterTests() {
        blockchain.reset();
    }

    @Test
    public void testTransfer() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("ERC20Snapshot"));
        DeployedContract deployedVoting = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("Voting"));
        TestSnapshot.mint(blockchain, deployed, deployedVoting, deployed.contractAddress());
        blockchain.call(deployedVoting, new FunctionBuilder("vote").addInput("bool", (Object)true));
        List ret = blockchain.callConstant(deployedVoting, new FunctionBuilder("yay").outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"10000", (Object)((Type)ret.get(0)).getValue().toString());
        blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("9999")).outputs(new String[]{"bool"}));
        blockchain.call(deployedVoting, new FunctionBuilder("vote").addInput("bool", (Object)true));
        ret = blockchain.callConstant(deployedVoting, new FunctionBuilder("yay").outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"10001", (Object)((Type)ret.get(0)).getValue().toString());
        blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("1")).outputs(new String[]{"bool"}));
        blockchain.call(deployedVoting, new FunctionBuilder("vote").addInput("bool", (Object)true));
        ret = blockchain.callConstant(deployedVoting, new FunctionBuilder("yay").outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"10002", (Object)((Type)ret.get(0)).getValue().toString());
    }

    private static void mint(TestBlockchain blockchain, DeployedContract deployed, DeployedContract deployedVoting, String contractAddress) throws NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException, InterruptedException, ExecutionException, IOException {
        blockchain.call(deployed, new FunctionBuilder("mint").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()));
        blockchain.call(deployedVoting, new FunctionBuilder("set").addInput("address", (Object)contractAddress));
    }
}

