/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator;

import io.iconator.testonator.Contract;
import io.iconator.testonator.ConvertException;
import io.iconator.testonator.DeployedContract;
import io.iconator.testonator.Event;
import io.iconator.testonator.FunctionBuilder;
import io.iconator.testonator.TestBlockchain;
import io.iconator.testonator.TestUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.web3j.abi.datatypes.Type;

public class TestERC20 {
    private static TestBlockchain blockchain;
    private static Map<String, Contract> contracts;

    @BeforeClass
    public static void setup() throws Exception {
        blockchain = TestBlockchain.runLocal();
        contracts = TestUtils.setup();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        blockchain.shutdown();
    }

    @After
    public void afterTests() {
        blockchain.reset();
    }

    @Test
    public void testReverse() throws InterruptedException, ExecutionException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, BigInteger.ONE);
        Assert.assertNull((Object)events);
    }

    @Test
    public void testTransferFailFlag() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 1000, 10, false);
        List events = blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("10000")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testTransfer() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 1000, 10);
        List events = blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("10000")).outputs(new String[]{"bool"}));
        Assert.assertEquals((long)1L, (long)events.size());
    }

    @Test
    public void testTransferFail() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 1000, 10);
        List events = blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("10001")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testTransferFailContract() throws InterruptedException, ExecutionException, IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, ConvertException, IllegalAccessException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 1000, 10);
        List events = blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)deployed.contractAddress()).addInput("uint256", (Object)new BigInteger("10001")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testTransferFailZero() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 1000, 10);
        List events = blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)"0x0").addInput("uint256", (Object)new BigInteger("10001")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testApprove() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 1000, 10);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("100")).outputs(new String[]{"bool"}));
        Assert.assertEquals((long)1L, (long)events.size());
        List results = blockchain.callConstant(deployed, new FunctionBuilder("allowance").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"100", (Object)((Type)results.get(0)).getValue().toString());
    }

    @Test
    public void testApproveWithdraw() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List results = blockchain.callConstant(deployed, new FunctionBuilder("balanceOf").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"10000", (Object)((Type)results.get(0)).getValue().toString());
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("100")).outputs(new String[]{"bool"}));
        results = blockchain.callConstant(deployed, new FunctionBuilder("balanceOf").addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"0", (Object)((Type)results.get(0)).getValue().toString());
        results = blockchain.callConstant(deployed, new FunctionBuilder("allowance").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"100", (Object)((Type)results.get(0)).getValue().toString());
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("20")).outputs(new String[]{"bool"}));
        results = blockchain.callConstant(deployed, new FunctionBuilder("allowance").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"80", (Object)((Type)results.get(0)).getValue().toString());
        results = blockchain.callConstant(deployed, new FunctionBuilder("balanceOf").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"9980", (Object)((Type)results.get(0)).getValue().toString());
    }

    @Test
    public void testApproveWithdrawTwice() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("100")).outputs(new String[]{"bool"}));
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("20")).outputs(new String[]{"bool"}));
        List results = blockchain.callConstant(deployed, new FunctionBuilder("allowance").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"80", (Object)((Type)results.get(0)).getValue().toString());
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("20")).outputs(new String[]{"bool"}));
        results = blockchain.callConstant(deployed, new FunctionBuilder("allowance").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"60", (Object)((Type)results.get(0)).getValue().toString());
        results = blockchain.callConstant(deployed, new FunctionBuilder("balanceOf").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"9960", (Object)((Type)results.get(0)).getValue().toString());
    }

    @Test
    public void testApproveWithdrawFailTwice() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("100")).outputs(new String[]{"bool"}));
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("50")).outputs(new String[]{"bool"}));
        List results = blockchain.callConstant(deployed, new FunctionBuilder("allowance").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"50", (Object)((Type)results.get(0)).getValue().toString());
        results = blockchain.callConstant(deployed, new FunctionBuilder("balanceOf").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"9950", (Object)((Type)results.get(0)).getValue().toString());
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("60")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testApproveWithdrawNoAllowance() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("60")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testApproveWithdrawTransfer() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("100")).outputs(new String[]{"bool"}));
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("60")).outputs(new String[]{"bool"}));
        events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("0")).outputs(new String[]{"bool"}));
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("10")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testApproveMax() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639935")).outputs(new String[]{"bool"}));
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("60")).outputs(new String[]{"bool"}));
        List results = blockchain.callConstant(deployed, new FunctionBuilder("allowance").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).outputs(new String[]{"uint256"}));
        Assert.assertEquals((Object)"115792089237316195423570985008687907853269984665640564039457584007913129639875", (Object)((Type)results.get(0)).getValue().toString());
    }

    @Test
    public void testApproveFailZero() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)"0x0").addInput("uint256", (Object)new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639935")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testEventMinting() throws NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException, InterruptedException, ExecutionException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        ArrayList<String> addresses = new ArrayList<String>(1);
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(1);
        addresses.add(TestBlockchain.CREDENTIAL_5.getAddress());
        values.add(BigInteger.valueOf(2222L));
        List events = blockchain.call(deployed, new FunctionBuilder("mint").addInput("address[]", addresses).addInput("uint256[]", values));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"Transfer", (Object)((Event)events.get(0)).name());
        Assert.assertEquals((Object)"0x0000000000000000000000000000000000000000", (Object)((Type)((Event)events.get(0)).values().get(0)).getValue().toString());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_5.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(1)).getValue().toString());
        Assert.assertEquals((Object)"2222", (Object)((Type)((Event)events.get(0)).values().get(2)).getValue().toString());
    }

    @Test
    public void testEventTransfer() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("10000")).outputs(new String[]{"bool"}));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"Transfer", (Object)((Event)events.get(0)).name());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_0.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(0)).getValue().toString());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_1.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(1)).getValue().toString());
        Assert.assertEquals((Object)"10000", (Object)((Type)((Event)events.get(0)).values().get(2)).getValue().toString());
    }

    @Test
    public void testEventTransferZero() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("0")).outputs(new String[]{"bool"}));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"Transfer", (Object)((Event)events.get(0)).name());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_0.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(0)).getValue().toString());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_1.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(1)).getValue().toString());
        Assert.assertEquals((Object)"0", (Object)((Type)((Event)events.get(0)).values().get(2)).getValue().toString());
    }

    @Test
    public void testEventMintAllFail() throws NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException, InterruptedException, ExecutionException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        ArrayList<String> addresses = new ArrayList<String>(1);
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(1);
        addresses.add(TestBlockchain.CREDENTIAL_5.getAddress());
        values.add(new BigInteger("900000000000000000000000001"));
        List events = blockchain.call(deployed, new FunctionBuilder("mint").addInput("address[]", addresses).addInput("uint256[]", values));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testEventMintAll() throws NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException, InterruptedException, ExecutionException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        ArrayList<String> addresses = new ArrayList<String>(1);
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(1);
        addresses.add(TestBlockchain.CREDENTIAL_2.getAddress());
        values.add(new BigInteger("900000000000000000000000000"));
        List events = blockchain.call(deployed, new FunctionBuilder("mint").addInput("address[]", addresses).addInput("uint256[]", values));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"Transfer", (Object)((Event)events.get(0)).name());
        Assert.assertEquals((Object)"0x0000000000000000000000000000000000000000", (Object)((Type)((Event)events.get(0)).values().get(0)).getValue().toString());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_2.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(1)).getValue().toString());
        Assert.assertEquals((Object)"900000000000000000000000000", (Object)((Type)((Event)events.get(0)).values().get(2)).getValue().toString());
    }

    @Test
    public void testEventApprove() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639935")).outputs(new String[]{"bool"}));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"Approval", (Object)((Event)events.get(0)).name());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_0.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(0)).getValue().toString());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_1.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(1)).getValue().toString());
        Assert.assertEquals((Object)"115792089237316195423570985008687907853269984665640564039457584007913129639935", (Object)((Type)((Event)events.get(0)).values().get(2)).getValue().toString());
    }

    @Test
    public void testEventTransferFrom() throws NoSuchMethodException, InterruptedException, ExecutionException, InstantiationException, ConvertException, IllegalAccessException, InvocationTargetException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        TestUtils.mint(blockchain, deployed, TestBlockchain.CREDENTIAL_0.getAddress(), TestBlockchain.CREDENTIAL_1.getAddress(), TestBlockchain.CREDENTIAL_2.getAddress(), 10000, 0, 0);
        List events = blockchain.call(TestBlockchain.CREDENTIAL_0, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639935")).outputs(new String[]{"bool"}));
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_0.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("60")).outputs(new String[]{"bool"}));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"Transfer", (Object)((Event)events.get(0)).name());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_0.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(0)).getValue().toString());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_2.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(1)).getValue().toString());
        Assert.assertEquals((Object)"60", (Object)((Type)((Event)events.get(0)).values().get(2)).getValue().toString());
    }

    @Test
    public void testLockup() throws NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException, InterruptedException, ExecutionException, IOException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        ArrayList<String> addresses = new ArrayList<String>(1);
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(1);
        addresses.add(TestBlockchain.CREDENTIAL_5.getAddress());
        values.add(BigInteger.valueOf(2222L));
        List events = blockchain.call(deployed, new FunctionBuilder("mint").addInput("address[]", addresses).addInput("uint256[]", values));
        events = blockchain.call(deployed, new FunctionBuilder("lockTokens").addInput("address[]", addresses).addInput("uint256[]", values));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"TokensLocked", (Object)((Event)events.get(0)).name());
        Assert.assertEquals((Object)TestBlockchain.CREDENTIAL_5.getAddress(), (Object)((Type)((Event)events.get(0)).values().get(0)).getValue().toString());
        Assert.assertEquals((Object)"2222", (Object)((Type)((Event)events.get(0)).values().get(1)).getValue().toString());
        events = blockchain.call(deployed, new FunctionBuilder("setAdmin").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()));
        events = blockchain.call(deployed, new FunctionBuilder("finishMinting"));
        Assert.assertEquals((long)0L, (long)events.size());
        events = blockchain.call(TestBlockchain.CREDENTIAL_5, deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("2222")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testWithdrawTransferFrom() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        ArrayList<String> addresses = new ArrayList<String>(1);
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(1);
        addresses.add(TestBlockchain.CREDENTIAL_5.getAddress());
        values.add(BigInteger.valueOf(2222L));
        List events = blockchain.call(deployed, new FunctionBuilder("mint").addInput("address[]", addresses).addInput("uint256[]", values));
        events = blockchain.call(deployed, new FunctionBuilder("lockTokens").addInput("address[]", addresses).addInput("uint256[]", values));
        events = blockchain.call(deployed, new FunctionBuilder("setAdmin").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()));
        events = blockchain.call(deployed, new FunctionBuilder("finishMinting"));
        Assert.assertEquals((long)0L, (long)events.size());
        events = blockchain.call(TestBlockchain.CREDENTIAL_5, deployed, new FunctionBuilder("approve").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("50")).outputs(new String[]{"bool"}));
        events = blockchain.call(TestBlockchain.CREDENTIAL_1, deployed, new FunctionBuilder("transferFrom").addInput("address", (Object)TestBlockchain.CREDENTIAL_5.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()).addInput("uint256", (Object)new BigInteger("50")).outputs(new String[]{"bool"}));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testWithdraw() throws InterruptedException, ExecutionException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, ConvertException, InvocationTargetException {
        DeployedContract deployed = blockchain.deploy(TestBlockchain.CREDENTIAL_0, contracts.get("DOS"));
        ArrayList<String> addresses = new ArrayList<String>(1);
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(1);
        addresses.add(TestBlockchain.CREDENTIAL_5.getAddress());
        values.add(BigInteger.valueOf(2222L));
        List events = blockchain.call(deployed, new FunctionBuilder("mint").addInput("address[]", addresses).addInput("uint256[]", values));
        events = blockchain.call(deployed, new FunctionBuilder("lockTokens").addInput("address[]", addresses).addInput("uint256[]", values));
        events = blockchain.call(deployed, new FunctionBuilder("setAdmin").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("address", (Object)TestBlockchain.CREDENTIAL_2.getAddress()));
        events = blockchain.call(deployed, new FunctionBuilder("finishMinting"));
        Assert.assertEquals((long)0L, (long)events.size());
        blockchain.setTime(2222);
        events = blockchain.call(TestBlockchain.CREDENTIAL_5, deployed, new FunctionBuilder("transfer").addInput("address", (Object)TestBlockchain.CREDENTIAL_1.getAddress()).addInput("uint256", (Object)new BigInteger("2222")).outputs(new String[]{"bool"}));
        Assert.assertEquals((long)1L, (long)events.size());
    }
}

