/*
 * Decompiled with CFR 0.152.
 */
package io.iconator.testonator.jsonrpc;

import java.math.BigInteger;
import org.ethereum.util.ByteUtil;
import org.spongycastle.util.encoders.Hex;

public class TypeConverter {
    public static BigInteger StringHexToBigInteger(String input) {
        if (input.startsWith("0x")) {
            return new BigInteger(input.substring(2), 16);
        }
        return new BigInteger(input, 10);
    }

    public static byte[] StringHexToByteArray(String x) {
        return ByteUtil.hexStringToBytes((String)TypeConverter.fromHex(x));
    }

    public static long HexToLong(String x) {
        return ByteUtil.byteArrayToLong((byte[])Hex.decode((String)TypeConverter.fromHex(x)));
    }

    private static String fromHex(String x) {
        if (x.startsWith("0x")) {
            x = x.substring(2);
        }
        if (x.length() % 2 != 0) {
            x = "0" + x;
        }
        return x;
    }

    public static String toJsonHexAddress(byte[] x) {
        return x == null || x.length == 0 ? null : "0x" + Hex.toHexString((byte[])x);
    }

    public static String toJsonHexNumber(byte[] x) {
        String hex = Hex.toHexString((byte[])x);
        return TypeConverter.toJsonHex(hex.isEmpty() ? "0" : hex);
    }

    public static String toJsonHex(byte[] x) {
        return "0x" + Hex.toHexString((byte[])x);
    }

    public static String toJsonHex(String x) {
        return "0x" + x;
    }

    public static String toJsonHex(long n) {
        return "0x" + Long.toHexString(n);
    }

    public static String toJsonHex(BigInteger n) {
        return "0x" + n.toString(16);
    }
}

