/*
 * Decompiled with CFR 0.152.
 */
package hkube.communication.zmq;

import hkube.communication.ICommConfig;
import hkube.communication.IRequestListener;
import hkube.communication.IRequestServer;
import hkube.model.HeaderContentPair;
import java.util.ArrayList;
import java.util.List;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public class ZMQServer
implements IRequestServer {
    private ZMQ.Socket socket = null;
    private ZMQ.Socket pingSocket = null;
    private List<IRequestListener> listeners = new ArrayList<IRequestListener>();
    Thread thread;
    Thread pingThread;

    public ZMQServer(ICommConfig config) {
        ZContext context = new ZContext();
        this.socket = context.createSocket(4);
        this.pingSocket = context.createSocket(4);
        this.socket.bind("tcp://*:" + config.getListeningPort());
        this.pingSocket.bind("tcp://*:" + (Integer.valueOf(config.getListeningPort()) + 1));
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    byte[] request = ZMQServer.this.socket.recv(0);
                    ZMQServer.this.listeners.forEach(listener -> listener.onRequest(request));
                }
            }
        });
        this.thread.start();
        this.pingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    byte[] request = ZMQServer.this.pingSocket.recv(0);
                    if (!new String(request).equals("ping")) continue;
                    ZMQServer.this.pingSocket.send("pong".getBytes(), 0);
                }
            }
        });
        this.pingThread.start();
    }

    public void addRequestsListener(IRequestListener listener) {
        this.listeners.add(listener);
    }

    public void reply(List<HeaderContentPair> replies) {
        for (int i = 0; i < replies.size(); ++i) {
            HeaderContentPair reply = replies.get(i);
            this.socket.send(reply.getHeaderAsBytes(), 2);
            if (i == replies.size() - 1) {
                this.socket.send(reply.getContent(), 0);
                continue;
            }
            this.socket.send(reply.getContent(), 2);
        }
    }

    public void close() {
        this.thread.interrupt();
        this.pingThread.interrupt();
        this.socket.close();
        this.pingSocket.close();
    }
}

